/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.labels;

import java.util.Arrays;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.JArrayPool;
import net.algart.arrays.TooLargeArrayException;

public abstract class LabelsProcessor
extends Arrays.ParallelExecutor
implements AutoCloseable {
    private static final int NUMBER_OR_PARTICLES_IN_BLOCK_FOR_PARALLEL_PROCESSING = 64;
    private static final int MAX_ALLOWED_LABEL = 0x3FFFFFFE;
    private static final int BUFFER_SIZE = 65536;
    private static final JArrayPool BYTE_BUFFERS = JArrayPool.getInstance(Byte.TYPE, (int)65536);
    private static final JArrayPool SHORT_BUFFERS = JArrayPool.getInstance(Short.TYPE, (int)65536);
    private static final JArrayPool INT_BUFFERS = JArrayPool.getInstance(Integer.TYPE, (int)65536);
    private static final JArrayPool FLOAT_BUFFERS = JArrayPool.getInstance(Float.TYPE, (int)65536);
    private static final JArrayPool DOUBLE_BUFFERS = JArrayPool.getInstance(Double.TYPE, (int)65536);
    private static final JArrayPool CLEARED_INT_BUFFERS = JArrayPool.getInstance(Integer.TYPE, (int)65536);
    private static final JArrayPool CLEARED_DOUBLE_BUFFERS = JArrayPool.getInstance(Double.TYPE, (int)65536);

    protected LabelsProcessor(Array src) {
        this(src, 32768);
    }

    protected LabelsProcessor(Array src, int blockSize) {
        super(null, null, src, blockSize, 0, 0L);
    }

    protected final void processSubArr(long position, int count, int threadIndex) {
        int p = (int)position;
        assert ((long)p == position) : "Java arrays cannot be >=2^31: " + position;
        this.processSubArr(p, count, threadIndex);
    }

    protected abstract void processSubArr(int var1, int var2, int var3);

    protected static int numberOrParticlesInBlockForParallelProcessing(int numberOfParticles) {
        int maxRecommended = numberOfParticles / (2 * Arrays.SystemSettings.cpuCount());
        return Math.max(4, Math.min(maxRecommended, 64));
    }

    protected static boolean isArraySupported(Object array) {
        return array instanceof byte[] || array instanceof short[] || array instanceof int[] || array instanceof float[] || array instanceof double[];
    }

    protected static byte[][] castToByte(Object[] channels) {
        byte[][] result = new byte[channels.length][];
        for (int k = 0; k < channels.length; ++k) {
            result[k] = (byte[])channels[k];
        }
        return result;
    }

    protected static short[][] castToShort(Object[] channels) {
        short[][] result = new short[channels.length][];
        for (int k = 0; k < channels.length; ++k) {
            result[k] = (short[])channels[k];
        }
        return result;
    }

    protected static int[][] castToInt(Object[] channels) {
        int[][] result = new int[channels.length][];
        for (int k = 0; k < channels.length; ++k) {
            result[k] = (int[])channels[k];
        }
        return result;
    }

    protected static float[][] castToFloat(Object[] channels) {
        float[][] result = new float[channels.length][];
        for (int k = 0; k < channels.length; ++k) {
            result[k] = (float[])channels[k];
        }
        return result;
    }

    protected static double[][] castToDouble(Object[] channels) {
        double[][] result = new double[channels.length][];
        for (int k = 0; k < channels.length; ++k) {
            result[k] = (double[])channels[k];
        }
        return result;
    }

    protected static byte[][] requestByteArrays(int numberOfArrays) {
        byte[][] result = new byte[numberOfArrays][];
        for (int k = 0; k < result.length; ++k) {
            result[k] = (byte[])BYTE_BUFFERS.requestArray();
        }
        return result;
    }

    protected static byte[][][] requestByteArrays(int numberOfArrays, int numberOfChannels) {
        byte[][][] result = new byte[numberOfArrays][][];
        for (int k = 0; k < result.length; ++k) {
            result[k] = LabelsProcessor.requestByteArrays(numberOfChannels);
        }
        return result;
    }

    protected static void releaseByteArrays(byte[][] arrays) {
        for (int k = arrays.length - 1; k >= 0; --k) {
            BYTE_BUFFERS.releaseArray((Object)arrays[k]);
        }
    }

    protected static void releaseByteArrays(byte[][][] arrays) {
        for (int k = arrays.length - 1; k >= 0; --k) {
            LabelsProcessor.releaseByteArrays(arrays[k]);
        }
    }

    protected static short[][] requestShortArrays(int numberOfArrays) {
        short[][] result = new short[numberOfArrays][];
        for (int k = 0; k < result.length; ++k) {
            result[k] = (short[])SHORT_BUFFERS.requestArray();
        }
        return result;
    }

    protected static short[][][] requestShortArrays(int numberOfArrays, int numberOfChannels) {
        short[][][] result = new short[numberOfArrays][][];
        for (int k = 0; k < result.length; ++k) {
            result[k] = LabelsProcessor.requestShortArrays(numberOfChannels);
        }
        return result;
    }

    protected static void releaseShortArrays(short[][] arrays) {
        for (int k = arrays.length - 1; k >= 0; --k) {
            SHORT_BUFFERS.releaseArray((Object)arrays[k]);
        }
    }

    protected static void releaseShortArrays(short[][][] arrays) {
        for (int k = arrays.length - 1; k >= 0; --k) {
            LabelsProcessor.releaseShortArrays(arrays[k]);
        }
    }

    protected static int[][] requestIntArrays(int numberOfArrays) {
        int[][] result = new int[numberOfArrays][];
        for (int k = 0; k < result.length; ++k) {
            result[k] = (int[])INT_BUFFERS.requestArray();
        }
        return result;
    }

    protected static int[][][] requestIntArrays(int numberOfArrays, int numberOfChannels) {
        int[][][] result = new int[numberOfArrays][][];
        for (int k = 0; k < result.length; ++k) {
            result[k] = LabelsProcessor.requestIntArrays(numberOfChannels);
        }
        return result;
    }

    protected static void releaseIntArrays(int[][] arrays) {
        for (int k = arrays.length - 1; k >= 0; --k) {
            INT_BUFFERS.releaseArray((Object)arrays[k]);
        }
    }

    protected static void releaseIntArrays(int[][][] arrays) {
        for (int k = arrays.length - 1; k >= 0; --k) {
            LabelsProcessor.releaseIntArrays(arrays[k]);
        }
    }

    protected static float[][] requestFloatArrays(int numberOfArrays) {
        float[][] result = new float[numberOfArrays][];
        for (int k = 0; k < result.length; ++k) {
            result[k] = (float[])FLOAT_BUFFERS.requestArray();
        }
        return result;
    }

    protected static float[][][] requestFloatArrays(int numberOfArrays, int numberOfChannels) {
        float[][][] result = new float[numberOfArrays][][];
        for (int k = 0; k < result.length; ++k) {
            result[k] = LabelsProcessor.requestFloatArrays(numberOfChannels);
        }
        return result;
    }

    protected static void releaseFloatArrays(float[][] arrays) {
        for (int k = arrays.length - 1; k >= 0; --k) {
            FLOAT_BUFFERS.releaseArray((Object)arrays[k]);
        }
    }

    protected static void releaseFloatArrays(float[][][] arrays) {
        for (int k = arrays.length - 1; k >= 0; --k) {
            LabelsProcessor.releaseFloatArrays(arrays[k]);
        }
    }

    protected static double[][] requestDoubleArrays(int numberOfArrays) {
        double[][] result = new double[numberOfArrays][];
        for (int k = 0; k < result.length; ++k) {
            result[k] = (double[])DOUBLE_BUFFERS.requestArray();
        }
        return result;
    }

    protected static double[][][] requestDoubleArrays(int numberOfArrays, int numberOfChannels) {
        double[][][] result = new double[numberOfArrays][][];
        for (int k = 0; k < result.length; ++k) {
            result[k] = LabelsProcessor.requestDoubleArrays(numberOfChannels);
        }
        return result;
    }

    protected static void releaseDoubleArrays(double[][] arrays) {
        for (int k = arrays.length - 1; k >= 0; --k) {
            DOUBLE_BUFFERS.releaseArray((Object)arrays[k]);
        }
    }

    protected static void releaseDoubleArrays(double[][][] arrays) {
        for (int k = arrays.length - 1; k >= 0; --k) {
            LabelsProcessor.releaseDoubleArrays(arrays[k]);
        }
    }

    protected static int[][] requestClearedIntArrays(int numberOfArrays) {
        int[][] result = new int[numberOfArrays][];
        for (int k = 0; k < result.length; ++k) {
            result[k] = (int[])CLEARED_INT_BUFFERS.requestArray();
        }
        return result;
    }

    protected static int[][][] requestClearedIntArrays(int numberOfArrays, int numberOfChannels) {
        int[][][] result = new int[numberOfArrays][][];
        for (int k = 0; k < result.length; ++k) {
            result[k] = LabelsProcessor.requestClearedIntArrays(numberOfChannels);
        }
        return result;
    }

    protected static void releaseAndClearIntArrays(int[][] arrays, int numberOfElementsToZero) {
        for (int k = arrays.length - 1; k >= 0; --k) {
            if (numberOfElementsToZero > 0) {
                int length = Math.min(numberOfElementsToZero, arrays[k].length);
                Arrays.fill(arrays[k], 0, length, 0);
            }
            CLEARED_INT_BUFFERS.releaseArray((Object)arrays[k]);
        }
    }

    protected static void releaseAndClearIntArrays(int[][][] arrays, int numberOfElementsToZero) {
        for (int k = arrays.length - 1; k >= 0; --k) {
            LabelsProcessor.releaseAndClearIntArrays(arrays[k], numberOfElementsToZero);
        }
    }

    protected static double[][] requestClearedDoubleArrays(int numberOfArrays) {
        double[][] result = new double[numberOfArrays][];
        for (int k = 0; k < result.length; ++k) {
            result[k] = (double[])CLEARED_DOUBLE_BUFFERS.requestArray();
        }
        return result;
    }

    protected static double[][][] requestClearedDoubleArrays(int numberOfArrays, int numberOfChannels) {
        double[][][] result = new double[numberOfArrays][][];
        for (int k = 0; k < result.length; ++k) {
            result[k] = LabelsProcessor.requestClearedDoubleArrays(numberOfChannels);
        }
        return result;
    }

    protected static void releaseAndClearDoubleArrays(double[][] arrays, int numberOfElementsToZero) {
        for (int k = arrays.length - 1; k >= 0; --k) {
            if (numberOfElementsToZero > 0) {
                int length = Math.min(numberOfElementsToZero, arrays[k].length);
                Arrays.fill(arrays[k], 0, length, 0.0);
            }
            CLEARED_DOUBLE_BUFFERS.releaseArray((Object)arrays[k]);
        }
    }

    protected static void releaseAndClearDoubleArrays(double[][][] arrays, int numberOfElementsToZero) {
        for (int k = arrays.length - 1; k >= 0; --k) {
            LabelsProcessor.releaseAndClearDoubleArrays(arrays[k], numberOfElementsToZero);
        }
    }

    protected static void ensureCapacityForPixels(byte[][] arrays, int totalNumberOfPixels, int newElementIndex) {
        if (newElementIndex < arrays[0].length) {
            return;
        }
        int newLength = LabelsProcessor.increaseCapacityForPixels(newElementIndex, totalNumberOfPixels, arrays.length);
        assert (newElementIndex < newLength);
        for (int k = 0; k < arrays.length; ++k) {
            arrays[k] = Arrays.copyOf(arrays[k], newLength);
        }
    }

    protected static void ensureCapacityForPixels(short[][] arrays, int totalNumberOfPixels, int newElementIndex) {
        if (newElementIndex < arrays[0].length) {
            return;
        }
        int newLength = LabelsProcessor.increaseCapacityForPixels(newElementIndex, totalNumberOfPixels, arrays.length);
        assert (newElementIndex < newLength);
        for (int k = 0; k < arrays.length; ++k) {
            arrays[k] = Arrays.copyOf(arrays[k], newLength);
        }
    }

    protected static void ensureCapacityForPixels(int[][] arrays, int totalNumberOfPixels, int newElementIndex) {
        if (newElementIndex < arrays[0].length) {
            return;
        }
        int newLength = LabelsProcessor.increaseCapacityForPixels(newElementIndex, totalNumberOfPixels, arrays.length);
        assert (newElementIndex < newLength);
        for (int k = 0; k < arrays.length; ++k) {
            arrays[k] = Arrays.copyOf(arrays[k], newLength);
        }
    }

    protected static void ensureCapacityForPixels(float[][] arrays, int totalNumberOfPixels, int newElementIndex) {
        if (newElementIndex < arrays[0].length) {
            return;
        }
        int newLength = LabelsProcessor.increaseCapacityForPixels(newElementIndex, totalNumberOfPixels, arrays.length);
        assert (newElementIndex < newLength);
        for (int k = 0; k < arrays.length; ++k) {
            arrays[k] = Arrays.copyOf(arrays[k], newLength);
        }
    }

    protected static void ensureCapacityForPixels(double[][] arrays, int totalNumberOfPixels, int newElementIndex) {
        if (newElementIndex < arrays[0].length) {
            return;
        }
        int newLength = LabelsProcessor.increaseCapacityForPixels(newElementIndex, totalNumberOfPixels, arrays.length);
        assert (newElementIndex < newLength);
        for (int k = 0; k < arrays.length; ++k) {
            arrays[k] = Arrays.copyOf(arrays[k], newLength);
        }
    }

    protected static int[] ensureCapacityForLabel(int[] array, int label) {
        if (label < array.length) {
            return array;
        }
        int newLength = LabelsProcessor.increaseCapacityForLabel(label, array.length);
        assert (label < newLength);
        return Arrays.copyOf(array, newLength);
    }

    protected static double[] ensureCapacityForLabel(double[] array, int label) {
        if (label < array.length) {
            return array;
        }
        int newLength = LabelsProcessor.increaseCapacityForLabel(label, array.length);
        assert (label < newLength);
        return Arrays.copyOf(array, newLength);
    }

    protected static void ensureSeveralArraysCapacityForLabel(double[][] arrays, int label) {
        if (label < arrays[0].length) {
            return;
        }
        int newLength = LabelsProcessor.increaseCapacityForLabel(label, arrays[0].length);
        assert (label < newLength);
        for (int k = 0; k < arrays.length; ++k) {
            arrays[k] = Arrays.copyOf(arrays[k], newLength);
        }
    }

    private static int increaseCapacityForPixels(int newElementIndex, int totalNumberOfPixels, int currentLength) {
        if (newElementIndex >= totalNumberOfPixels) {
            throw new AssertionError((Object)("Invalid usage: required number of elements " + (newElementIndex + 1) + " > total number of pixels " + totalNumberOfPixels));
        }
        long newLength = currentLength;
        while ((long)newElementIndex >= newLength) {
            newLength = Math.min(2L * newLength, (long)totalNumberOfPixels);
        }
        return (int)newLength;
    }

    private static int increaseCapacityForLabel(int label, int currentLength) {
        if (label > 0x3FFFFFFE) {
            throw new TooLargeArrayException("Too large label " + label + " > 1073741822: it is probably a random int value, not a label");
        }
        long newLength = currentLength;
        while ((long)label >= newLength) {
            newLength = Math.min(2L * newLength, 0x3FFFFFFEL);
        }
        return (int)newLength;
    }
}

