/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.binary.components;

import java.util.List;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatableBitArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.executors.modules.cv.matrices.objects.RetainOrRemoveMode;
import net.algart.executors.modules.cv.matrices.objects.binary.components.ConnectedComponentScanning;
import net.algart.math.functions.Func;
import net.algart.matrices.scanning.ConnectedObjectScanner;
import net.algart.multimatrix.MultiMatrix2D;

public final class FilterConnectedObjectsByAreas
extends ConnectedComponentScanning {
    public static final String INPUT_OBJECTS = "objects";
    public static final String INPUT_MASK = "mask";
    private RetainOrRemoveMode mode = RetainOrRemoveMode.REMOVE;
    private AreaInterpretation areaInterpretation = AreaInterpretation.FRACTION_OF_WHOLE_IMAGE_0_1;
    private double minArea = Double.NEGATIVE_INFINITY;
    private double maxArea = Double.POSITIVE_INFINITY;
    private boolean invertMask = false;

    public FilterConnectedObjectsByAreas() {
        super(INPUT_OBJECTS, INPUT_MASK);
    }

    public RetainOrRemoveMode getMode() {
        return this.mode;
    }

    public FilterConnectedObjectsByAreas setMode(RetainOrRemoveMode mode) {
        this.mode = (RetainOrRemoveMode)((Object)FilterConnectedObjectsByAreas.nonNull((Object)((Object)mode)));
        return this;
    }

    public AreaInterpretation getAreaInterpretation() {
        return this.areaInterpretation;
    }

    public FilterConnectedObjectsByAreas setAreaInterpretation(AreaInterpretation areaInterpretation) {
        this.areaInterpretation = (AreaInterpretation)((Object)FilterConnectedObjectsByAreas.nonNull((Object)((Object)areaInterpretation)));
        return this;
    }

    public double getMinArea() {
        return this.minArea;
    }

    public FilterConnectedObjectsByAreas setMinArea(double minArea) {
        this.minArea = FilterConnectedObjectsByAreas.nonNegative((double)minArea);
        return this;
    }

    public FilterConnectedObjectsByAreas setMinArea(String minArea) {
        this.minArea = FilterConnectedObjectsByAreas.doubleOrNegativeInfinity((String)minArea);
        return this;
    }

    public double getMaxArea() {
        return this.maxArea;
    }

    public FilterConnectedObjectsByAreas setMaxArea(double maxArea) {
        this.maxArea = FilterConnectedObjectsByAreas.nonNegative((double)maxArea);
        return this;
    }

    public FilterConnectedObjectsByAreas setMaxArea(String maxArea) {
        this.maxArea = FilterConnectedObjectsByAreas.doubleOrPositiveInfinity((String)maxArea);
        return this;
    }

    public boolean isInvertMask() {
        return this.invertMask;
    }

    public FilterConnectedObjectsByAreas setInvertMask(boolean invertMask) {
        this.invertMask = invertMask;
        return this;
    }

    protected Matrix<? extends PArray> processMatrix(List<Matrix<? extends UpdatablePArray>> bitMatrices, List<MultiMatrix2D> sources) {
        Matrix objectsClone;
        Matrix objects = FilterConnectedObjectsByAreas.asBit(bitMatrices.get(0));
        Matrix mask = FilterConnectedObjectsByAreas.asBit(bitMatrices.get(1));
        Matrix matrix = objectsClone = this.mode == RetainOrRemoveMode.REMOVE ? FilterConnectedObjectsByAreas.cloneBit((Matrix)objects) : null;
        if (this.invertMask && mask != null) {
            Matrices.applyFunc(null, (Func)Func.REVERSE, (Matrix)mask, (Matrix)mask);
            this.clearBorderInExtended(mask);
        }
        long minNonClearedSize = this.areaInterpretation.convert(this.minArea, objects);
        long maxNonClearedSize = this.areaInterpretation.convert(this.maxArea, objects);
        ConnectedObjectScanner scanner = this.connectedObjectScanner((Matrix<? extends UpdatableBitArray>)objects);
        long pixelCounter = scanner.clearAllBySizes(null, mask, minNonClearedSize, maxNonClearedSize);
        FilterConnectedObjectsByAreas.logDebug(() -> "Filtering connected objects by areas: " + pixelCounter + " pixels scanned for " + String.valueOf(objects));
        if (this.mode == RetainOrRemoveMode.REMOVE) {
            Matrices.applyFunc(null, (Func)Func.ABS_DIFF, (Matrix)objects, (Matrix)objects, (Matrix)objectsClone);
        }
        return objects;
    }

    protected boolean allowUninitializedInput(int inputIndex) {
        return inputIndex == 1;
    }

    public static enum AreaInterpretation {
        NUMBER_OF_PIXELS,
        FRACTION_OF_WHOLE_IMAGE_0_1;


        long convert(double area, Matrix<?> matrix) {
            if (this == FRACTION_OF_WHOLE_IMAGE_0_1) {
                area *= (double)matrix.size();
            }
            return StrictMath.round(area);
        }
    }
}

