/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.binary.boundaries;

import java.util.Locale;
import java.util.function.BiConsumer;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatableBitArray;
import net.algart.executors.modules.core.common.matrices.BitMultiMatrixFilter;
import net.algart.math.IPoint;
import net.algart.math.IRectangularArea;
import net.algart.matrices.scanning.ConnectivityType;
import net.algart.matrices.scanning.ContainingMainBoundaryFinder;

public final class FillMainBoundaryAroundPoint
extends BitMultiMatrixFilter {
    public static final String OUTPUT_INSIDE = "is_inside";
    public static final String OUTPUT_FOUND_X = "found_x";
    public static final String OUTPUT_FOUND_Y = "found_y";
    public static final String OUTPUT_AREA = "area";
    public static final String OUTPUT_CONTAINING_RECTANGLE = "containing_rectangle";
    private long x = 0L;
    private long y = 0L;
    private Mode mode = Mode.CLEAR_OUTSIDE;
    private ConnectivityType connectivityType = ConnectivityType.STRAIGHT_AND_DIAGONAL;

    public FillMainBoundaryAroundPoint() {
        this.addOutputScalar(OUTPUT_INSIDE);
        this.addOutputScalar(OUTPUT_FOUND_X);
        this.addOutputScalar(OUTPUT_FOUND_Y);
        this.addOutputScalar(OUTPUT_AREA);
        this.addOutputNumbers(OUTPUT_CONTAINING_RECTANGLE);
    }

    public long getX() {
        return this.x;
    }

    public FillMainBoundaryAroundPoint setX(long x) {
        this.x = x;
        return this;
    }

    public long getY() {
        return this.y;
    }

    public FillMainBoundaryAroundPoint setY(long y) {
        this.y = y;
        return this;
    }

    public Mode getMode() {
        return this.mode;
    }

    public FillMainBoundaryAroundPoint setMode(Mode mode) {
        this.mode = (Mode)((Object)FillMainBoundaryAroundPoint.nonNull((Object)((Object)mode)));
        return this;
    }

    public ConnectivityType getConnectivityType() {
        return this.connectivityType;
    }

    public FillMainBoundaryAroundPoint setConnectivityType(ConnectivityType connectivityType) {
        this.connectivityType = (ConnectivityType)FillMainBoundaryAroundPoint.nonNull((Object)connectivityType);
        return this;
    }

    protected Matrix<? extends PArray> processMatrix(Matrix<? extends PArray> objects) {
        long t1 = FillMainBoundaryAroundPoint.debugTime();
        Matrix source = objects.cast(BitArray.class);
        ContainingMainBoundaryFinder finder = ContainingMainBoundaryFinder.newInstance((Matrix)source).setConnectivityType(this.connectivityType);
        Matrix result = Arrays.SMM.newBitMatrix(objects.dimensions());
        if (this.mode.fillInSource()) {
            Matrices.copy((Matrix)result, (Matrix)source);
        }
        long t2 = FillMainBoundaryAroundPoint.debugTime();
        long found = finder.find(this.x, this.y);
        long t3 = FillMainBoundaryAroundPoint.debugTime();
        this.mode.filler.accept(finder, (Matrix<? extends UpdatableBitArray>)result);
        long t4 = FillMainBoundaryAroundPoint.debugTime();
        if (this.isOutputNecessary(OUTPUT_CONTAINING_RECTANGLE)) {
            IRectangularArea rectangle = finder.findContainingRectangle();
            if (rectangle != null) {
                this.getNumbers(OUTPUT_CONTAINING_RECTANGLE).setTo(rectangle);
            } else {
                this.getNumbers(OUTPUT_CONTAINING_RECTANGLE).remove();
            }
        }
        long t5 = FillMainBoundaryAroundPoint.debugTime();
        this.getScalar(OUTPUT_INSIDE).setTo(found >= 0L);
        if (found >= 0L) {
            this.getScalar(OUTPUT_FOUND_X).setTo(found);
            this.getScalar(OUTPUT_FOUND_Y).setTo(this.y);
            this.getScalar(OUTPUT_AREA).setTo(finder.scanner().orientedArea());
        } else {
            this.getScalar(OUTPUT_FOUND_X).remove();
            this.getScalar(OUTPUT_FOUND_Y).remove();
            this.getScalar(OUTPUT_AREA).remove();
        }
        FillMainBoundaryAroundPoint.logDebug(() -> String.format(Locale.US, "%s main boundary in matrix %dx%d around point (%d,%d) in %.3f ms: %.6f ms allocating%s + %.6f ms finding + %.6f ms %s + %.6f finding rectangle", found > 0L ? "Found at " + found : "Not found", source.dimX(), source.dimY(), this.x, this.y, (double)(t5 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, this.mode.fillInSource() ? "" : "/copying", (double)(t3 - t2) * 1.0E-6, (double)(t4 - t3) * 1.0E-6, this.mode.modeName(), (double)(t5 - t4) * 1.0E-6));
        return result;
    }

    public static enum Mode {
        FILL_INSIDE(ContainingMainBoundaryFinder::fillBitsInside, "filling"){

            @Override
            IPoint processRectangle(ContainingMainBoundaryFinder finder, Matrix<? extends UpdatableBitArray> result, Matrix<? extends BitArray> source, IRectangularArea rectangle) {
                return finder.fillAtRectangle(result, source, rectangle);
            }
        }
        ,
        CLEAR_OUTSIDE(ContainingMainBoundaryFinder::clearBitsOutside, "clearing outside"){

            @Override
            IPoint processRectangle(ContainingMainBoundaryFinder finder, Matrix<? extends UpdatableBitArray> result, Matrix<? extends BitArray> source, IRectangularArea rectangle) {
                return finder.clearOutsideRectangle(result, source, rectangle);
            }
        }
        ,
        FILL_IN_NEW_MATRIX(ContainingMainBoundaryFinder::fillBitsInside, "drawing"){

            @Override
            IPoint processRectangle(ContainingMainBoundaryFinder finder, Matrix<? extends UpdatableBitArray> result, Matrix<? extends BitArray> source, IRectangularArea rectangle) {
                return finder.buildAroundRectangle(result, source, rectangle);
            }
        };

        private final BiConsumer<ContainingMainBoundaryFinder, Matrix<? extends UpdatableBitArray>> filler;
        private final String modeName;

        private Mode(BiConsumer<ContainingMainBoundaryFinder, Matrix<? extends UpdatableBitArray>> filler, String modeName) {
            this.filler = filler;
            this.modeName = modeName;
        }

        public String modeName() {
            return this.modeName;
        }

        abstract IPoint processRectangle(ContainingMainBoundaryFinder var1, Matrix<? extends UpdatableBitArray> var2, Matrix<? extends BitArray> var3, IRectangularArea var4);

        private boolean fillInSource() {
            return this != FILL_IN_NEW_MATRIX;
        }
    }
}

