/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.binary.boundaries;

import net.algart.contours.Contours;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.numbers.NumbersFilter;

public final class ExtractContoursRange
extends NumbersFilter
implements ReadOnlyExecutionInput {
    public static final String INPUT_CONTOURS = "contours";
    public static final String OUTPUT_CONTOURS = "contours";
    public static final String OUTPUT_OTHER_CONTOURS = "other_contours";
    private int firstIndex = 0;
    private int numberOfContours = 0;

    public ExtractContoursRange() {
        this.setDefaultInputNumbers("contours");
        this.setDefaultOutputNumbers("contours");
        this.addOutputNumbers(OUTPUT_OTHER_CONTOURS);
    }

    public int getFirstIndex() {
        return this.firstIndex;
    }

    public ExtractContoursRange setFirstIndex(int firstIndex) {
        this.firstIndex = ExtractContoursRange.nonNegative((int)firstIndex);
        return this;
    }

    public int getNumberOfContours() {
        return this.numberOfContours;
    }

    public ExtractContoursRange setNumberOfContours(int numberOfContours) {
        this.numberOfContours = ExtractContoursRange.nonNegative((int)numberOfContours);
        return this;
    }

    protected SNumbers processNumbers(SNumbers source) {
        Contours contours = Contours.deserialize((int[])source.toIntArray());
        int length = this.numberOfContours != 0 ? this.numberOfContours : contours.numberOfContours() - this.firstIndex;
        int toIndex = Math.addExact(this.firstIndex, length);
        Contours result = contours.contoursRange(this.firstIndex, toIndex);
        if (this.isOutputNecessary(OUTPUT_OTHER_CONTOURS)) {
            contours.removeContoursRange(this.firstIndex, toIndex);
            this.getNumbers(OUTPUT_OTHER_CONTOURS).setTo(contours);
        }
        return SNumbers.of((Contours)result);
    }
}

