/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects;

import java.util.HashMap;
import java.util.Objects;
import net.algart.executors.api.data.SMat;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.matrices.MultiMatrixToNumbers;
import net.algart.executors.modules.cv.matrices.objects.ValuesAtLabelledObjects;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public final class GetLabelledObjects
extends MultiMatrixToNumbers {
    public static final String INPUT_LABELS = "labels";
    public static final String OUTPUT_PAINT_LABELLED = "paint_labelled";
    private boolean rawValues = true;
    private boolean paintLabelledOnSource = false;
    private boolean visiblePaintLabelled = false;

    public GetLabelledObjects() {
        this.addInputMat(INPUT_LABELS);
        this.addOutputMat(OUTPUT_PAINT_LABELLED);
    }

    public boolean isRawValues() {
        return this.rawValues;
    }

    public GetLabelledObjects setRawValues(boolean rawValues) {
        this.rawValues = rawValues;
        return this;
    }

    public boolean isPaintLabelledOnSource() {
        return this.paintLabelledOnSource;
    }

    public GetLabelledObjects setPaintLabelledOnSource(boolean paintLabelledOnSource) {
        this.paintLabelledOnSource = paintLabelledOnSource;
        return this;
    }

    public boolean isVisiblePaintLabelled() {
        return this.visiblePaintLabelled;
    }

    public GetLabelledObjects setVisiblePaintLabelled(boolean visiblePaintLabelled) {
        this.visiblePaintLabelled = visiblePaintLabelled;
        return this;
    }

    public GetLabelledObjects requestFillLabelled() {
        this.requestOutput(new String[]{OUTPUT_PAINT_LABELLED});
        return this;
    }

    public SMat resultFillLabelled() {
        return this.getMat(OUTPUT_PAINT_LABELLED);
    }

    public SNumbers analyse(MultiMatrix source) {
        Objects.requireNonNull(source, "Null source");
        ValuesAtLabelledObjects valuesAtLabelledObjects = new ValuesAtLabelledObjects().setRawValues(this.rawValues).setPaintLabelledOnSource(this.paintLabelledOnSource);
        HashMap<ValuesAtLabelledObjects.ObjectParameter, SNumbers> results = new HashMap<ValuesAtLabelledObjects.ObjectParameter, SNumbers>();
        SNumbers result = new SNumbers();
        results.put(ValuesAtLabelledObjects.ObjectParameter.FIRST_NON_ZERO, result);
        MultiMatrix2D source2D = source.asMultiMatrix2D();
        MultiMatrix2D labelsMatrix = this.getInputMat(INPUT_LABELS).toMultiMatrix2D();
        valuesAtLabelledObjects.analyse(results, source2D, labelsMatrix, null, null);
        if (this.isOutputNecessary(OUTPUT_PAINT_LABELLED)) {
            this.getMat(OUTPUT_PAINT_LABELLED).setTo((MultiMatrix)ValuesAtLabelledObjects.paintLabelledObjects(result, source2D, labelsMatrix, null, false, this.paintLabelledOnSource));
        }
        return result;
    }

    public String visibleOutputPortName() {
        return this.visiblePaintLabelled ? OUTPUT_PAINT_LABELLED : super.visibleOutputPortName();
    }
}

