/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.misc;

import java.util.Locale;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.executors.modules.core.common.matrices.MultiMatrixChannel2DFilter;
import net.algart.executors.modules.cv.matrices.misc.slopes.MatrixBoundariesEmphasizer;
import net.algart.executors.modules.cv.matrices.misc.slopes.SlopeEmphasizer;
import net.algart.multimatrix.MultiMatrix2D;

public final class QuickEmphasizeBoundaries
extends MultiMatrixChannel2DFilter {
    private boolean autoConvertToGrayscale = false;
    private double minimalChange = 0.0;
    private int slopeWidth = 1;
    private boolean allowLongSlopes = true;
    private boolean processAscending = true;
    private boolean processDescending = true;
    private boolean exactHalfSum = true;
    private EmphasizedDirections emphasizedDirections = EmphasizedDirections.HORIZONTAL_AND_VERTICAL;
    private boolean rawValues = false;

    public boolean isAutoConvertToGrayscale() {
        return this.autoConvertToGrayscale;
    }

    public QuickEmphasizeBoundaries setAutoConvertToGrayscale(boolean autoConvertToGrayscale) {
        this.autoConvertToGrayscale = autoConvertToGrayscale;
        return this;
    }

    public double getMinimalChange() {
        return this.minimalChange;
    }

    public QuickEmphasizeBoundaries setMinimalChange(double minimalChange) {
        this.minimalChange = QuickEmphasizeBoundaries.nonNegative((double)minimalChange);
        return this;
    }

    public int getSlopeWidth() {
        return this.slopeWidth;
    }

    public QuickEmphasizeBoundaries setSlopeWidth(int slopeWidth) {
        this.slopeWidth = QuickEmphasizeBoundaries.positive((int)slopeWidth);
        return this;
    }

    public boolean isAllowLongSlopes() {
        return this.allowLongSlopes;
    }

    public QuickEmphasizeBoundaries setAllowLongSlopes(boolean allowLongSlopes) {
        this.allowLongSlopes = allowLongSlopes;
        return this;
    }

    public boolean isProcessAscending() {
        return this.processAscending;
    }

    public QuickEmphasizeBoundaries setProcessAscending(boolean processAscending) {
        this.processAscending = processAscending;
        return this;
    }

    public boolean isProcessDescending() {
        return this.processDescending;
    }

    public QuickEmphasizeBoundaries setProcessDescending(boolean processDescending) {
        this.processDescending = processDescending;
        return this;
    }

    public boolean isExactHalfSum() {
        return this.exactHalfSum;
    }

    public QuickEmphasizeBoundaries setExactHalfSum(boolean exactHalfSum) {
        this.exactHalfSum = exactHalfSum;
        return this;
    }

    public EmphasizedDirections getEmphasizedDirections() {
        return this.emphasizedDirections;
    }

    public QuickEmphasizeBoundaries setEmphasizedDirections(EmphasizedDirections emphasizedDirections) {
        this.emphasizedDirections = (EmphasizedDirections)((Object)QuickEmphasizeBoundaries.nonNull((Object)((Object)emphasizedDirections)));
        return this;
    }

    public boolean isRawValues() {
        return this.rawValues;
    }

    public QuickEmphasizeBoundaries setRawValues(boolean rawValues) {
        this.rawValues = rawValues;
        return this;
    }

    public MultiMatrix2D process(MultiMatrix2D source) {
        if (this.autoConvertToGrayscale) {
            source = source.toMonoIfNot();
        }
        return super.process(source);
    }

    protected Matrix<? extends PArray> processChannel(Matrix<? extends PArray> m) {
        if (m.elementType() == Boolean.TYPE) {
            return m;
        }
        long t1 = QuickEmphasizeBoundaries.debugTime();
        double scale = this.rawValues ? 1.0 : m.maxPossibleValue();
        SlopeEmphasizer slopeEmphasizer = SlopeEmphasizer.getInstance().setMinimalChange(this.minimalChange * scale).setSlopeWidth(this.slopeWidth).setAllowLongSlopes(this.allowLongSlopes).setProcessAscending(this.processAscending).setProcessDescending(this.processDescending).setExactHalfSum(this.exactHalfSum);
        Matrix result = Matrices.clone(m);
        long t2 = QuickEmphasizeBoundaries.debugTime();
        this.emphasizedDirections.process(MatrixBoundariesEmphasizer.getInstance(slopeEmphasizer), (Matrix<? extends UpdatablePArray>)result);
        long t3 = QuickEmphasizeBoundaries.debugTime();
        QuickEmphasizeBoundaries.logDebug(() -> String.format(Locale.US, "Emphasizing boundaries for %s, channel %d: %.3f ms = %.3f ms cloning + %.3f ms processing", m, this.currentChannel(), (double)(t3 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6));
        return result;
    }

    public static enum EmphasizedDirections {
        HORIZONTAL{

            @Override
            void process(MatrixBoundariesEmphasizer emphasizer, Matrix<? extends UpdatablePArray> matrix) {
                emphasizer.setDirectionToEmphasize(0).emphasize(matrix);
            }
        }
        ,
        VERTICAL{

            @Override
            void process(MatrixBoundariesEmphasizer emphasizer, Matrix<? extends UpdatablePArray> matrix) {
                emphasizer.setDirectionToEmphasize(1).emphasize(matrix);
            }
        }
        ,
        HORIZONTAL_AND_VERTICAL{

            @Override
            void process(MatrixBoundariesEmphasizer emphasizer, Matrix<? extends UpdatablePArray> matrix) {
                emphasizer.setDirectionToEmphasize(0).emphasize(matrix);
                emphasizer.setDirectionToEmphasize(1).emphasize(matrix);
            }
        }
        ,
        VERTICAL_AND_HORIZONTAL{

            @Override
            void process(MatrixBoundariesEmphasizer emphasizer, Matrix<? extends UpdatablePArray> matrix) {
                emphasizer.setDirectionToEmphasize(1).emphasize(matrix);
                emphasizer.setDirectionToEmphasize(0).emphasize(matrix);
            }
        };


        abstract void process(MatrixBoundariesEmphasizer var1, Matrix<? extends UpdatablePArray> var2);
    }
}

