/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.camera.reflectance;

import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import net.algart.arrays.Arrays;
import net.algart.arrays.PArray;
import net.algart.executors.api.parameters.ParameterValueType;
import net.algart.executors.modules.cv.matrices.camera.reflectance.ReflectanceTranslationType;
import net.algart.json.AbstractConvertibleToJson;
import net.algart.json.Jsons;
import net.algart.math.functions.AbstractFunc;
import net.algart.math.functions.Func;

public class ReflectanceSettings
extends AbstractConvertibleToJson {
    public static final String APP_NAME = "reflectance-settings";
    public static final String CURRENT_VERSION = "1.0";
    private Path reflectanceJsonFile = null;
    private String version = "1.0";
    private ReflectanceTranslationType type = ReflectanceTranslationType.LINEAR;
    private Translation translation = new LinearTranslation();

    public ReflectanceSettings() {
    }

    public ReflectanceSettings(JsonObject json, Path file) {
        if (!ReflectanceSettings.isReflectanceJson(json)) {
            throw new JsonException("JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + " is not a reflectance settings: no \"app\":\"reflectance-settings\" element");
        }
        this.reflectanceJsonFile = file;
        this.version = json.getString("version", CURRENT_VERSION);
        String type = json.getString("type", ParameterValueType.STRING.typeName());
        this.type = ReflectanceTranslationType.ofOrNull(type);
        Jsons.requireNonNull((Object)((Object)this.type), (JsonObject)json, (String)"type", (String)("unknown translation type (\"" + type + "\")"), (Path)file);
        this.translation = this.type.newSettings(Jsons.reqJsonObject((JsonObject)json, (String)"translation", (Path)file));
    }

    public static ReflectanceSettings read(Path reflectanceJsonFile) throws IOException {
        Objects.requireNonNull(reflectanceJsonFile, "Null reflectanceJsonFile");
        JsonObject json = Jsons.readJson((Path)reflectanceJsonFile);
        return new ReflectanceSettings(json, reflectanceJsonFile);
    }

    public void write(Path reflectanceJsonFile, OpenOption ... options) throws IOException {
        Objects.requireNonNull(reflectanceJsonFile, "Null reflectanceJsonFile");
        Files.writeString(reflectanceJsonFile, (CharSequence)Jsons.toPrettyString((JsonObject)this.toJson()), options);
    }

    public static ReflectanceSettings of(JsonObject reflectanceJson) {
        return new ReflectanceSettings(reflectanceJson, null);
    }

    public static ReflectanceSettings of(String reflectanceJsonString) {
        return ReflectanceSettings.of(Jsons.toJson((String)reflectanceJsonString));
    }

    public static boolean isReflectanceJson(JsonObject reflectanceJson) {
        Objects.requireNonNull(reflectanceJson, "Null reflectance JSON");
        return APP_NAME.equals(reflectanceJson.getString("app", null));
    }

    public Path getReflectanceJsonFile() {
        return this.reflectanceJsonFile;
    }

    public String getVersion() {
        return this.version;
    }

    public ReflectanceSettings setVersion(String version) {
        this.version = (String)ReflectanceSettings.nonNull((Object)version);
        return this;
    }

    public ReflectanceTranslationType getType() {
        return this.type;
    }

    public ReflectanceSettings setType(ReflectanceTranslationType type) {
        this.type = (ReflectanceTranslationType)((Object)ReflectanceSettings.nonNull((Object)((Object)type)));
        this.translation = this.type.newSettings();
        return this;
    }

    public Translation getTranslation() {
        return this.translation;
    }

    public ReflectanceSettings setTranslation(Translation translation) {
        this.translation = (Translation)((Object)ReflectanceSettings.nonNull((Object)((Object)translation)));
        return this;
    }

    public double intensityToReflectance(double intensity) {
        return this.translation.intensityToReflectance(intensity);
    }

    public double reflectanceToIntensity(double reflectance) {
        return this.translation.reflectanceToIntensity(reflectance);
    }

    public double intensity255ToReflectance(double intensity) {
        return this.translation.intensity255ToReflectance(intensity);
    }

    public double reflectanceToIntensity255(double reflectance) {
        return this.translation.reflectanceToIntensity255(reflectance);
    }

    public Func normalizedIntensityToReflectanceFunc() {
        return new AbstractFunc(){

            public double get(double ... x) {
                return this.get(x[0]);
            }

            public double get(double x0) {
                return ReflectanceSettings.this.intensityToReflectance(x0);
            }
        };
    }

    public Func intensityToReflectanceFunc(Class<?> intensityElementType) {
        return this.intensityToReflectanceFunc(intensityElementType, false);
    }

    public Func intensityToReflectanceFunc(final Class<?> intensityElementType, boolean maximalPrecision) {
        Objects.requireNonNull(intensityElementType, "Null intensityElementType");
        if (Arrays.isFloatingPointElementType(intensityElementType)) {
            return this.normalizedIntensityToReflectanceFunc();
        }
        if (maximalPrecision) {
            if (intensityElementType == Byte.TYPE) {
                return new AbstractFunc(){

                    public double get(double ... x) {
                        return this.get(x[0]);
                    }

                    public double get(double x0) {
                        return ReflectanceSettings.this.intensity255ToReflectance(x0);
                    }
                };
            }
            return new AbstractFunc(){
                final double scale;
                {
                    this.scale = Arrays.maxPossibleValue((Class)Arrays.type(PArray.class, (Class)intensityElementType));
                }

                public double get(double ... x) {
                    return this.get(x[0]);
                }

                public double get(double x0) {
                    return ReflectanceSettings.this.intensityToReflectance(x0 / this.scale);
                }
            };
        }
        return new AbstractFunc(){
            final double scale;
            {
                this.scale = 1.0 / Arrays.maxPossibleValue((Class)Arrays.type(PArray.class, (Class)intensityElementType));
            }

            public double get(double ... x) {
                return this.get(x[0]);
            }

            public double get(double x0) {
                return ReflectanceSettings.this.intensityToReflectance(x0 * this.scale);
            }
        };
    }

    public Func reflectanceToNormalizedIntensityFunc() {
        return new AbstractFunc(){

            public double get(double ... x) {
                return this.get(x[0]);
            }

            public double get(double x0) {
                return ReflectanceSettings.this.reflectanceToIntensity(x0);
            }
        };
    }

    public Func reflectanceToIntensityFunc(Class<?> intensityElementType) {
        return this.reflectanceToIntensityFunc(intensityElementType, false);
    }

    public Func reflectanceToIntensityFunc(final Class<?> intensityElementType, boolean maximalPrecision) {
        Objects.requireNonNull(intensityElementType, "Null intensityElementType");
        if (Arrays.isFloatingPointElementType(intensityElementType)) {
            return this.reflectanceToNormalizedIntensityFunc();
        }
        if (maximalPrecision && intensityElementType == Byte.TYPE) {
            return new AbstractFunc(){

                public double get(double ... x) {
                    return this.get(x[0]);
                }

                public double get(double x0) {
                    return Math.round(ReflectanceSettings.this.reflectanceToIntensity255(x0));
                }
            };
        }
        return new AbstractFunc(){
            final double scale;
            {
                this.scale = Arrays.maxPossibleValue((Class)Arrays.type(PArray.class, (Class)intensityElementType));
            }

            public double get(double ... x) {
                return this.get(x[0]);
            }

            public double get(double x0) {
                return Math.round(ReflectanceSettings.this.reflectanceToIntensity(x0) * this.scale);
            }
        };
    }

    public void buildJson(JsonObjectBuilder builder) {
        builder.add("app", APP_NAME);
        builder.add("version", this.version);
        builder.add("type", this.type.typeName());
        builder.add("translation", (JsonValue)this.translation.toJson());
    }

    public String toString() {
        return "ReflectanceSettings{reflectanceJsonFile=" + String.valueOf(this.reflectanceJsonFile) + ", version='" + this.version + "', type=" + String.valueOf((Object)this.type) + ", translation=" + String.valueOf((Object)this.translation) + "}";
    }

    public static class LinearTranslation
    extends Translation {
        double a;
        double a255;
        double aInv;
        double b;
        double bInv;

        public LinearTranslation() {
            this.initialize();
            this.correct();
        }

        public LinearTranslation(JsonObject json) {
            this.initialize();
            this.correct();
            if (json.containsKey((Object)"a255")) {
                this.setA255(Jsons.reqDouble((JsonObject)json, (String)"a255"));
            } else {
                this.setA(Jsons.reqDouble((JsonObject)json, (String)"a"));
            }
            this.setB(Jsons.reqDouble((JsonObject)json, (String)"b"));
        }

        public double getA() {
            return this.a;
        }

        public LinearTranslation setA(double a) {
            this.a = a;
            this.a255 = a / 255.0;
            this.correct();
            return this;
        }

        public LinearTranslation setA255(double a255) {
            this.a = a255 * 255.0;
            this.a255 = a255;
            this.correct();
            return this;
        }

        public double getB() {
            return this.b;
        }

        public LinearTranslation setB(double b) {
            this.b = b;
            this.correct();
            return this;
        }

        public void buildJson(JsonObjectBuilder builder) {
            builder.add("a", this.a);
            builder.add("a255", this.a / 255.0);
            builder.add("b", this.b);
        }

        public String toString() {
            return "LinearTranslationSettings{a=" + this.a + ", b=" + this.b + "}";
        }

        void initialize() {
            this.a255 = 0.02005625;
            this.a = this.a255 * 255.0;
            this.b = -2.1108;
        }

        @Override
        protected double intensityToReflectance(double intensity) {
            return this.a * intensity + this.b;
        }

        @Override
        protected double reflectanceToIntensity(double reflectance) {
            return (reflectance - this.b) * this.aInv;
        }

        @Override
        protected double intensity255ToReflectance(double intensity) {
            return this.a255 * intensity + this.b;
        }

        @Override
        protected double reflectanceToIntensity255(double reflectance) {
            return (reflectance - this.b) / this.a255;
        }

        private void correct() {
            this.aInv = 1.0 / this.a;
            this.bInv = 1.0 / this.b;
        }
    }

    public static abstract class Translation
    extends AbstractConvertibleToJson {
        private final double byteScale = 0.00392156862745098;

        protected abstract double intensityToReflectance(double var1);

        protected abstract double reflectanceToIntensity(double var1);

        protected double intensity255ToReflectance(double intensity) {
            return this.intensityToReflectance(intensity * 0.00392156862745098);
        }

        protected double reflectanceToIntensity255(double reflectance) {
            return this.reflectanceToIntensity(reflectance) * 255.0;
        }
    }

    public static class LogLinearTranslation
    extends LinearTranslation {
        public LogLinearTranslation() {
        }

        public LogLinearTranslation(JsonObject json) {
            super(json);
        }

        @Override
        void initialize() {
            this.a255 = 0.0243;
            this.a = this.a255 * 255.0;
            this.b = 0.0198888;
        }

        @Override
        protected double intensityToReflectance(double intensity) {
            return this.b * Math.exp(intensity * this.a);
        }

        @Override
        protected double reflectanceToIntensity(double reflectance) {
            return Math.log(reflectance * this.bInv) * this.aInv;
        }

        @Override
        protected double intensity255ToReflectance(double intensity) {
            return this.b * Math.exp(intensity * this.a255);
        }

        @Override
        protected double reflectanceToIntensity255(double reflectance) {
            return Math.log(reflectance / this.b) * this.a255;
        }
    }
}

