/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.viewers.ui.content.tools;

import com.siams.cv.monitor.model.SimplePrimitive;
import com.siams.cv.monitor.viewers.ui.content.tools.SelectionTool;
import com.siams.stare.utils.Rect;
import java.util.List;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Rectangle;

public class RectangleSelectionTool
extends SelectionTool {
    private final Rectangle viewNode = new Rectangle();
    private final Rect model = new Rect();
    private double scale = 1.0;
    private Point2D mouseGestureStartPoint = Point2D.ZERO;
    private Bounds startShape;
    private ResizeStrategy resizeStrategy = ResizeStrategy.NONE;

    RectangleSelectionTool(Pane handlePane) {
        super(handlePane);
        this.setDefaultSize();
        this.updateModel((Bounds)new BoundingBox(0.0, 0.0, 0.0, 0.0), this.viewNode.getBoundsInParent());
        this.viewNode.setVisible(false);
        this.viewNode.setManaged(false);
        handlePane.getChildren().add((Object)this.viewNode);
        this.initializeActiveProperty();
        this.initializeActions();
    }

    @Override
    public Node getView() {
        return this.viewNode;
    }

    @Override
    public List<SimplePrimitive> getModel() {
        return List.of(new SimplePrimitive("x", this.model.getX()), new SimplePrimitive("y", this.model.getY()), new SimplePrimitive("width", this.model.getWidth()), new SimplePrimitive("height", this.model.getHeight()));
    }

    @Override
    public String getName() {
        return "Rectangle";
    }

    @Override
    public void onHandlePaneClicked(MouseEvent event) {
        if (!this.active.get()) {
            return;
        }
        if (!event.isStillSincePress()) {
            return;
        }
        Point2D newPosition = new Point2D(event.getX() - 0.5 * this.viewNode.getWidth(), event.getY() - 0.5 * this.viewNode.getHeight());
        Bounds boundsBefore = this.viewNode.getBoundsInParent();
        this.setViewPosition(newPosition);
        this.updateModel(boundsBefore, this.viewNode.getBoundsInParent());
    }

    @Override
    public Point2D getModelPosition() {
        return this.model.upperLeft();
    }

    @Override
    public void setViewPosition(Point2D newPosition) {
        this.viewNode.setX(newPosition.getX());
        this.viewNode.setY(newPosition.getY());
    }

    @Override
    public void setScale(double scale) {
        this.scale = scale;
        this.viewNode.setWidth(this.model.getWidth() * scale);
        this.viewNode.setHeight(this.model.getHeight() * scale);
    }

    private void setDefaultSize() {
        this.viewNode.setX(0.0);
        this.viewNode.setY(0.0);
        this.viewNode.setWidth(100.0);
        this.viewNode.setHeight(50.0);
    }

    private void initializeActiveProperty() {
        this.active.addListener((ob, o, n) -> {
            this.viewNode.setVisible(n.booleanValue());
            this.viewNode.setManaged(n.booleanValue());
        });
    }

    private void initializeActions() {
        this.viewNode.setOnMouseMoved(event -> {
            event.consume();
            assert (this.viewNode == event.getSource());
            Bounds nodeBounds = this.viewNode.getBoundsInParent();
            Point2D positionInsideWorkingNode = new Point2D(event.getX() - nodeBounds.getMinX(), event.getY() - nodeBounds.getMinY());
            this.viewNode.getScene().setCursor(this.getCursorForMousePosition(positionInsideWorkingNode));
        });
        this.viewNode.setOnMouseExited(event -> {
            event.consume();
            this.viewNode.getScene().setCursor(Cursor.DEFAULT);
        });
        this.viewNode.setOnMousePressed(event -> {
            event.consume();
            assert (this.viewNode == event.getSource());
            Bounds nodeBounds = this.viewNode.getBoundsInParent();
            Point2D positionInsideWorkingNode = new Point2D(event.getX() - nodeBounds.getMinX(), event.getY() - nodeBounds.getMinY());
            this.mouseGestureStartPoint = new Point2D(event.getSceneX(), event.getSceneY());
            this.startShape = this.viewNode.getBoundsInParent();
            this.resizeStrategy = this.getResizeStrategyForMousePosition(positionInsideWorkingNode);
        });
        this.viewNode.setOnMouseDragged(event -> {
            event.consume();
            double minWorkingNodeSize = 20.0;
            double dx = event.getSceneX() - this.mouseGestureStartPoint.getX();
            double dy = event.getSceneY() - this.mouseGestureStartPoint.getY();
            double newX = this.startShape.getMinX() + dx * (double)this.resizeStrategy.x;
            double newY = this.startShape.getMinY() + dy * (double)this.resizeStrategy.y;
            double newW = this.startShape.getWidth() + dx * (double)this.resizeStrategy.width;
            double newH = this.startShape.getHeight() + dy * (double)this.resizeStrategy.height;
            if (newW < 20.0) {
                newW = 20.0;
                newX = this.viewNode.getX();
            }
            if (newH < 20.0) {
                newH = 20.0;
                newY = this.viewNode.getY();
            }
            this.viewNode.setX(newX);
            this.viewNode.setY(newY);
            this.viewNode.setWidth(newW);
            this.viewNode.setHeight(newH);
        });
        this.viewNode.setOnMouseReleased(event -> {
            event.consume();
            this.updateModel(this.startShape, this.viewNode.getBoundsInParent());
            this.resizeStrategy = ResizeStrategy.NONE;
        });
    }

    private void updateModel(Bounds boundsBefore, Bounds boundsAfter) {
        double dx = (boundsAfter.getMinX() - boundsBefore.getMinX()) / this.scale;
        double dy = (boundsAfter.getMinY() - boundsBefore.getMinY()) / this.scale;
        double dw = (boundsAfter.getWidth() - boundsBefore.getWidth()) / this.scale;
        double dh = (boundsAfter.getHeight() - boundsBefore.getHeight()) / this.scale;
        this.model.set(this.model.getX() + dx, this.model.getY() + dy, this.model.getWidth() + dw, this.model.getHeight() + dh);
        if (this.modelChangeListener != null) {
            this.modelChangeListener.accept(this.getModel());
        }
    }

    private Cursor getCursorForMousePosition(Point2D pos) {
        double THR = 10.0;
        double x = pos.getX();
        double y = pos.getY();
        if (x < 10.0 && y < 10.0) {
            return Cursor.NW_RESIZE;
        }
        if (this.viewNode.getWidth() - x < 10.0 && y < 10.0) {
            return Cursor.NE_RESIZE;
        }
        if (this.viewNode.getWidth() - x < 10.0 && this.viewNode.getHeight() - y < 10.0) {
            return Cursor.SE_RESIZE;
        }
        if (x < 10.0 && this.viewNode.getHeight() - y < 10.0) {
            return Cursor.SW_RESIZE;
        }
        if (x < 10.0 || this.viewNode.getWidth() - x < 10.0) {
            return Cursor.E_RESIZE;
        }
        if (y < 10.0 || this.viewNode.getHeight() - y < 10.0) {
            return Cursor.N_RESIZE;
        }
        return Cursor.MOVE;
    }

    private ResizeStrategy getResizeStrategyForMousePosition(Point2D pos) {
        double THR = 10.0;
        double x = pos.getX();
        double y = pos.getY();
        if (x < 10.0 && y < 10.0) {
            return ResizeStrategy.TOP_LEFT;
        }
        if (this.viewNode.getWidth() - x < 10.0 && y < 10.0) {
            return ResizeStrategy.TOP_RIGHT;
        }
        if (this.viewNode.getWidth() - x < 10.0 && this.viewNode.getHeight() - y < 10.0) {
            return ResizeStrategy.BOTTOM_RIGHT;
        }
        if (x < 10.0 && this.viewNode.getHeight() - y < 10.0) {
            return ResizeStrategy.BOTTOM_LEFT;
        }
        if (x < 10.0) {
            return ResizeStrategy.LEFT;
        }
        if (this.viewNode.getWidth() - x < 10.0) {
            return ResizeStrategy.RIGHT;
        }
        if (y < 10.0) {
            return ResizeStrategy.TOP;
        }
        if (this.viewNode.getHeight() - y < 10.0) {
            return ResizeStrategy.BOTTOM;
        }
        return ResizeStrategy.DRAG;
    }

    private static enum ResizeStrategy {
        BOTTOM_LEFT(1, 0, -1, 1),
        LEFT(1, 0, -1, 0),
        TOP_LEFT(1, 1, -1, -1),
        TOP(0, 1, 0, -1),
        TOP_RIGHT(0, 1, 1, -1),
        RIGHT(0, 0, 1, 0),
        BOTTOM_RIGHT(0, 0, 1, 1),
        BOTTOM(0, 0, 0, 1),
        DRAG(1, 1, 0, 0),
        NONE(0, 0, 0, 0);

        final int x;
        final int y;
        final int width;
        final int height;

        private ResizeStrategy(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }
    }
}

