/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.viewers.ui.content;

import com.siams.cv.monitor.model.viewer.ChartViewerModel;
import com.siams.cv.monitor.model.viewer.CropViewerModel;
import com.siams.cv.monitor.model.viewer.ImageBorderViewerModel;
import com.siams.cv.monitor.model.viewer.ImageMaskViewerModel;
import com.siams.cv.monitor.model.viewer.ImageViewerModel;
import com.siams.cv.monitor.model.viewer.PlainTextViewerModel;
import com.siams.cv.monitor.model.viewer.SphViewerModel;
import com.siams.cv.monitor.model.viewer.TableViewerModel;
import com.siams.cv.monitor.model.viewer.TriangulationViewerModel;
import com.siams.cv.monitor.model.viewer.ViewerKind;
import com.siams.cv.monitor.model.viewer.ViewerModel;
import com.siams.cv.monitor.model.viewer.VoxelViewerModel;
import com.siams.cv.monitor.viewers.ui.content.BaseVoxelViewer;
import com.siams.cv.monitor.viewers.ui.content.CropViewer;
import com.siams.cv.monitor.viewers.ui.content.FxChartViewer;
import com.siams.cv.monitor.viewers.ui.content.ImageBorderViewer;
import com.siams.cv.monitor.viewers.ui.content.ImageViewer;
import com.siams.cv.monitor.viewers.ui.content.MaskViewer;
import com.siams.cv.monitor.viewers.ui.content.PlainTextViewer;
import com.siams.cv.monitor.viewers.ui.content.TableViewer;
import com.siams.cv.monitor.viewers.ui.content.TriangulationViewer;
import com.siams.cv.monitor.viewers.ui.content.Viewer;
import com.siams.cv.monitor.viewers.ui.content.sph.SphViewer;
import com.siams.notifications.StareNotification;
import org.apache.log4j.Logger;

public class ViewerFactory {
    private static final Logger logger = Logger.getLogger(ViewerFactory.class);

    public static <T extends Viewer> T create(ViewerKind kind, ViewerModel viewerModel) {
        Viewer viewer = null;
        switch (kind) {
            case COMPARE: {
                StareNotification.showWarn((String)"CompareViewer is abstract now and can't be created via ViewerFactory");
                break;
            }
            case IMAGE: {
                assert (viewerModel instanceof ImageViewerModel);
                ImageViewer imageViewer = new ImageViewer((ImageViewerModel)viewerModel);
                imageViewer.initialize();
                viewer = imageViewer;
                break;
            }
            case BOUNDARIES: {
                assert (viewerModel instanceof ImageBorderViewerModel);
                ImageBorderViewer imageBorderViewer = new ImageBorderViewer((ImageBorderViewerModel)viewerModel);
                imageBorderViewer.initialize();
                viewer = imageBorderViewer;
                break;
            }
            case MASK: {
                assert (viewerModel instanceof ImageMaskViewerModel);
                MaskViewer maskViewer = new MaskViewer((ImageMaskViewerModel)viewerModel);
                maskViewer.initialize();
                viewer = maskViewer;
                break;
            }
            case PLAIN_TEXT: {
                assert (viewerModel instanceof PlainTextViewerModel);
                PlainTextViewer plainTextViewer = new PlainTextViewer((PlainTextViewerModel)viewerModel);
                plainTextViewer.initialize();
                viewer = plainTextViewer;
                break;
            }
            case TABLE: {
                assert (viewerModel instanceof TableViewerModel);
                TableViewer tableViewer = new TableViewer((TableViewerModel)viewerModel);
                tableViewer.initialize();
                viewer = tableViewer;
                break;
            }
            case SPHEREPOLYHEDRA: {
                assert (viewerModel instanceof SphViewerModel);
                SphViewer sphViewer = new SphViewer((SphViewerModel)viewerModel);
                sphViewer.initialize();
                viewer = sphViewer;
                break;
            }
            case VOXEL: {
                BaseVoxelViewer voxelViewer = new BaseVoxelViewer((VoxelViewerModel)viewerModel);
                voxelViewer.initialize();
                viewer = voxelViewer;
                break;
            }
            case CROP: {
                assert (viewerModel instanceof CropViewerModel);
                CropViewer cropViewer = new CropViewer((CropViewerModel)viewerModel);
                cropViewer.initialize();
                viewer = cropViewer;
                break;
            }
            case CHART: {
                assert (viewerModel instanceof ChartViewerModel);
                FxChartViewer chartViewer = new FxChartViewer((ChartViewerModel)viewerModel);
                chartViewer.initialize();
                viewer = chartViewer;
                break;
            }
            case TRIANGULATION: {
                assert (viewerModel instanceof TriangulationViewerModel);
                TriangulationViewer triangulationViewer = new TriangulationViewer((TriangulationViewerModel)viewerModel);
                triangulationViewer.initialize();
                viewer = triangulationViewer;
            }
        }
        return (T)viewer;
    }
}

