/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.viewers.ui.content;

import com.siams.cv.monitor.model.viewer.ViewerModel;
import com.siams.cv.monitor.viewers.ui.content.BaseViewerDataSource;
import com.siams.cv.monitor.viewers.ui.content.DefaultPinHandler;
import com.siams.cv.monitor.viewers.ui.content.IBehavior;
import com.siams.cv.monitor.viewers.ui.content.IViewerContainer;
import com.siams.cv.monitor.viewers.ui.content.SimpleViewerContainer;
import com.siams.cv.monitor.viewers.ui.content.ViewerData;
import com.siams.cv.monitor.viewers.ui.content.ViewerDataSource;
import com.siams.general.Deletable;
import com.siams.preferences.UIPreference;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import org.apache.log4j.Logger;

public abstract class Viewer<T extends ViewerModel>
implements IBehavior,
Deletable,
UIPreference,
ViewerDataSource.ChangeViewerDataListener {
    private static final Logger logger = Logger.getLogger(Viewer.class);
    protected ViewerDataSource viewerDataSource = new BaseViewerDataSource();
    protected EventHandler<ActionEvent> pinHandler = null;
    protected final T viewerModel;

    protected Viewer(T model) {
        this.viewerModel = model;
    }

    public UUID getId() {
        return this.viewerModel.getUuid();
    }

    protected abstract void initializeControls();

    public void registerPinUnpin(Consumer<Boolean> pinConsumer) {
        this.pinHandler = new DefaultPinHandler(pinConsumer);
    }

    protected abstract void render(ViewerData var1);

    public void rerender() {
        this.viewerDataSource.getData().ifPresent(this::render);
    }

    public T getViewerModel() {
        return this.viewerModel;
    }

    public String getTitle() {
        return this.viewerModel.getTitle();
    }

    public void onChangeStageShowingProperty(Boolean showing) {
        if (showing.booleanValue()) {
            this.restorePreference();
            this.viewerDataSource.getData().ifPresent(this::render);
        } else {
            this.release();
        }
    }

    public IViewerContainer show() {
        SimpleViewerContainer container = new SimpleViewerContainer();
        container.setViewer(this);
        this.viewerModel.setShowing(true);
        this.viewerModel.setReleaseCallback(container::release);
        this.viewerModel.setToFrontCallback(() -> {
            container.getWindow().setIconified(false);
            container.getWindow().setAlwaysOnTop(true);
            container.getWindow().setAlwaysOnTop(false);
            container.getWindow().requestFocus();
        });
        this.viewerDataSource.getData().ifPresent(this::render);
        container.show();
        return container;
    }

    public void displayError(Throwable t) {
        logger.error((Object)"Context", t);
    }

    public void setViewerDataSource(ViewerDataSource viewerDataSource) {
        Objects.requireNonNull(viewerDataSource);
        if (this.viewerDataSource != null) {
            this.viewerDataSource.release();
        }
        this.viewerDataSource = viewerDataSource;
        this.viewerDataSource.addListener(this);
    }

    public ViewerDataSource getViewerDataSource() {
        return this.viewerDataSource;
    }

    public void release() {
        this.viewerModel.setShowing(false);
        this.viewerModel.setReleaseCallback(null);
        this.viewerModel.setToFrontCallback(null);
        this.pinHandler = null;
        if (this.viewerDataSource != null) {
            this.viewerDataSource.release();
            this.viewerDataSource = null;
        }
    }

    @Override
    public void onViewerDataReceived(ViewerData viewerData) {
        this.render(viewerData);
    }

    @Override
    public void onViewerDataErrorReceived(Throwable t) {
        this.displayError(t);
    }
}

