/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.viewers.ui.content;

import com.siams.cv.monitor.model.viewer.TriangulationViewerModel;
import com.siams.cv.monitor.viewers.ui.content.BaseImageViewer;
import com.siams.cv.monitor.viewers.ui.content.BaseImageViewerControls;
import com.siams.cv.monitor.viewers.ui.content.TriangulationViewer;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.paint.Color;

class TriangulationViewerControls
extends BaseImageViewerControls<TriangulationViewer> {
    @FXML
    private CheckBox cbHideImage;
    @FXML
    private ColorPicker cpEdgesColor;
    @FXML
    private ColorPicker cpContoursColor;

    TriangulationViewerControls(TriangulationViewer viewer) {
        super(viewer);
    }

    @Override
    public void init() {
        super.init();
        this.enableFeature(BaseImageViewer.Feature.VIEWER_KIND, false);
        this.initializeHideCheckbox();
        this.initializeColorPickers();
    }

    private void initializeHideCheckbox() {
        this.cbHideImage.setSelected(((TriangulationViewerModel)((TriangulationViewer)this.viewer).getViewerModel()).isHideImage());
        this.cbHideImage.selectedProperty().addListener((observable, oldValue, newValue) -> {
            ((TriangulationViewerModel)((TriangulationViewer)this.viewer).getViewerModel()).setHideImage(newValue.booleanValue());
            ((TriangulationViewer)this.viewer).rerender();
            if (((TriangulationViewer)this.viewer).getViewerStateHandler() != null) {
                ((TriangulationViewer)this.viewer).getViewerStateHandler().onViewerStateChanged();
            }
        });
    }

    private void initializeColorPickers() {
        this.cpEdgesColor.setValue((Object)((TriangulationViewer)this.viewer).getEdgesColor());
        this.cpEdgesColor.setOnAction(event -> {
            ((TriangulationViewer)this.viewer).setEdgesColor((Color)this.cpEdgesColor.getValue());
            ((TriangulationViewer)this.viewer).rerender();
            if (((TriangulationViewer)this.viewer).getViewerStateHandler() != null) {
                ((TriangulationViewer)this.viewer).getViewerStateHandler().onViewerStateChanged();
            }
        });
        this.cpContoursColor.setValue((Object)((TriangulationViewer)this.viewer).getContoursColor());
        this.cpContoursColor.setOnAction(event -> {
            ((TriangulationViewer)this.viewer).setContoursColor((Color)this.cpContoursColor.getValue());
            ((TriangulationViewer)this.viewer).rerender();
            if (((TriangulationViewer)this.viewer).getViewerStateHandler() != null) {
                ((TriangulationViewer)this.viewer).getViewerStateHandler().onViewerStateChanged();
            }
        });
    }
}

