/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.viewers.ui.content;

import com.siams.cv.monitor.model.viewer.ViewerModel;
import com.siams.cv.monitor.viewers.ui.content.IViewerContainer;
import com.siams.cv.monitor.viewers.ui.content.Viewer;
import java.util.Objects;
import java.util.function.Consumer;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

class SimpleViewerContainer
implements IViewerContainer {
    private Viewer viewer;
    private Stage window = this.createWindow();
    private Scene scene;
    private AnchorPane viewerPlace;
    private Stage ownerWindow = null;

    SimpleViewerContainer() {
        this.initializeScene();
    }

    private Stage createWindow() {
        Stage window = new Stage();
        window.initModality(Modality.NONE);
        window.setResizable(true);
        window.initStyle(StageStyle.DECORATED);
        window.setOnCloseRequest(event -> this.release());
        return window;
    }

    private void initializeScene() {
        this.viewerPlace = new AnchorPane();
        this.viewerPlace.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.scene = new Scene((Parent)this.viewerPlace, 800.0, 600.0);
        this.scene.getStylesheets().add((Object)"viewer-container.css");
        this.window.setScene(this.scene);
    }

    public Stage getWindow() {
        return this.window;
    }

    @Override
    public void setViewer(Viewer<? extends ViewerModel> viewer) {
        Objects.requireNonNull(viewer, "Viewer required");
        if (this.viewer != null) {
            this.viewer.release();
            this.viewer = null;
        }
        if (this.viewerPlace.getChildren().size() != 0) {
            this.viewerPlace.getChildren().clear();
        }
        this.viewer = viewer;
        this.window.setTitle(viewer.getTitle());
        this.viewer.registerPinUnpin(new Consumer<Boolean>(){

            @Override
            public void accept(Boolean pinned) {
                Stage currentWindow = SimpleViewerContainer.this.window;
                double x = currentWindow.getX();
                double y = currentWindow.getY();
                double width = currentWindow.getWidth();
                double height = currentWindow.getHeight();
                Stage newWindow = SimpleViewerContainer.this.createWindow();
                newWindow.setTitle(currentWindow.getTitle());
                if (pinned.booleanValue() && SimpleViewerContainer.this.ownerWindow != null) {
                    newWindow.initOwner((Window)SimpleViewerContainer.this.ownerWindow);
                }
                newWindow.setX(x);
                newWindow.setY(y);
                newWindow.setWidth(width);
                newWindow.setHeight(height);
                newWindow.setScene(SimpleViewerContainer.this.scene);
                newWindow.show();
                currentWindow.close();
                SimpleViewerContainer.this.window = newWindow;
            }
        });
        this.viewer.embed((Pane)this.viewerPlace);
    }

    @Override
    public void show() {
        this.window.show();
    }

    @Override
    public ReadOnlyBooleanProperty showingProperty() {
        return this.window.showingProperty();
    }

    @Override
    public void setOwnerWindow(Stage ownerWindow) {
        this.ownerWindow = ownerWindow;
    }

    public void release() {
        if (this.viewer != null) {
            this.viewer.release();
        }
        if (this.window.isShowing()) {
            this.window.close();
        }
    }
}

