/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.viewers.ui.content;

import com.siams.cv.monitor.model.viewer.PlainTextViewerModel;
import com.siams.cv.monitor.viewers.ui.content.TextViewer;
import com.siams.cv.monitor.viewers.ui.content.ViewerData;
import com.siams.fx.components.indicator.FxRunIndicator;
import com.siams.fx.components.jsoneditor.JsonEditor;
import com.siams.fx.components.tooltip.StareTooltip;
import com.siams.fxml.loader.CustomFXMLLoader;
import com.siams.javafx.PaneHelper;
import com.siams.javafx.utils.FxPlatform;
import com.siams.notifications.StareNotification;
import java.awt.Dimension;
import java.awt.Font;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.embed.swing.SwingNode;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.scene.web.WebView;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import net.algart.executors.api.data.SScalar;

public class PlainTextViewer
extends TextViewer<PlainTextViewerModel> {
    private static final Logger logger = Logger.getLogger(PlainTextViewer.class.getCanonicalName());
    private static final int MAX_DISPLAY_SIZE = 500000;
    private String text;
    private PlainTextContent root;
    private TextFormat format = TextFormat.TEXT;
    private Optional<Timer> timerOnChangeShowingProperty = Optional.empty();
    private final BooleanProperty enableTextFormatControls = new SimpleBooleanProperty(false);
    private Optional<JsonEditor> editor = Optional.empty();

    public PlainTextViewer(PlainTextViewerModel viewerModel) {
        super(viewerModel);
    }

    public void initialize() {
        this.initializeContent();
        this.initializeControls();
        this.initializeFormatControlsProperty();
        this.restorePreference();
    }

    private void initializeContent() {
        this.root = new PlainTextContent();
        this.root.initializeSwingContent();
    }

    private void initializeFormatControlsProperty() {
        this.enableTextFormatControls.addListener((ob, o, n) -> this.showTextFormatControls((boolean)n));
    }

    @Override
    protected void initializeControls() {
        this.root.btnCopy.getStyleClass().add((Object)"copy");
        this.root.btnCopy.setTooltip((Tooltip)new StareTooltip("Copy viewer content to clipboard"));
        this.root.btnCopy.setOnAction(event -> this.root.runIndicator.progress(this.exportToClipboard(), "Copying to clipboard..."));
        this.root.btnSaveAsFile.getStyleClass().add((Object)"save-as-file");
        this.root.btnSaveAsFile.setTooltip((Tooltip)new StareTooltip("Save viewer content into file"));
        this.root.btnSaveAsFile.setOnAction(event -> this.root.runIndicator.progress(this.exportToFile(), "Copying to file..."));
        this.root.btnDisplayAsJson.setOnAction(e -> {
            this.format = TextFormat.JSON;
            this.viewerDataSource.getData().ifPresent(this::render);
        });
        this.root.btnDisplayAsText.setOnAction(e -> {
            this.format = TextFormat.TEXT;
            this.viewerDataSource.getData().ifPresent(this::render);
        });
    }

    @Override
    public void embed(Pane contentContainer) {
        contentContainer.getChildren().add((Object)this.root);
        PaneHelper.setAnchorZero((Node)this.root);
    }

    @Override
    public Pane provideControls() {
        return null;
    }

    @Override
    public Node provideView() {
        return this.root;
    }

    @Override
    public List<Node> provideTools() {
        return new LinkedList<AnchorPane>(List.of(this.root.btnCopy, this.root.btnSaveAsFile, this.root.btnDisplayAsText, this.root.btnDisplayAsJson, this.root.apIndicatorContainer));
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    public void setJsonText(String text) {
        this.enableTextFormatControlsProperty().set(true);
        this.setText(text);
        this.editor.ifPresent(ed -> ed.setText(text));
        this.format = TextFormat.JSON;
        FxPlatform.RunFxThread(() -> {
            this.root.textPane.getChildren().clear();
            Node textContainer = this.renderJSON(text);
            this.root.textPane.getChildren().add((Object)textContainer);
            PaneHelper.setAnchorZero((Node)textContainer);
        });
    }

    public boolean isEnableTextFormatControls() {
        return this.enableTextFormatControls.get();
    }

    public BooleanProperty enableTextFormatControlsProperty() {
        return this.enableTextFormatControls;
    }

    @Override
    public void onChangeStageShowingProperty(Boolean showing) {
        super.onChangeStageShowingProperty(showing);
        if (showing.booleanValue() && this.format == TextFormat.SWING) {
            this.timerOnChangeShowingProperty.ifPresent(Timer::cancel);
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    PlainTextViewer.this.root.swingContainer.getContent().repaint();
                    PlainTextViewer.this.timerOnChangeShowingProperty.ifPresent(Timer::cancel);
                    PlainTextViewer.this.timerOnChangeShowingProperty = Optional.empty();
                }
            }, 400L);
            this.timerOnChangeShowingProperty = Optional.of(timer);
        }
    }

    @Override
    protected void render(ViewerData viewerData) {
        this.extractDefaultScalar(viewerData).ifPresentOrElse(scalar -> {
            String formatted = scalar.getValue();
            FxPlatform.RunFxThread(() -> {
                Node textContainer;
                if (this.format == TextFormat.JSON) {
                    textContainer = this.renderJSON(formatted);
                } else {
                    this.format = formatted.length() > 500000 ? TextFormat.SWING : TextFormat.TEXT;
                    textContainer = this.format == TextFormat.TEXT ? this.renderPlainText(formatted) : this.renderSwingText(formatted);
                }
                this.root.textPane.getChildren().clear();
                this.root.textPane.getChildren().add((Object)textContainer);
                PaneHelper.setAnchorZero((Node)textContainer);
            });
        }, () -> {
            String error = String.format("PlainTextViewer unsupported viewer data %s", viewerData);
            StareNotification.showInfo((String)error);
            logger.severe(error);
        });
    }

    @Override
    public void displayError(Throwable t) {
        super.displayError(t);
        this.setText(t.getMessage());
        this.format = TextFormat.TEXT;
        FxPlatform.RunFxThread(() -> {
            this.root.textPane.getChildren().clear();
            Node textContainer = this.renderPlainText(t.getMessage());
            this.root.textPane.getChildren().add((Object)textContainer);
            PaneHelper.setAnchorZero((Node)textContainer);
        });
    }

    public void restorePreference() {
    }

    public void savePreference() {
    }

    @Override
    public void release() {
        logger.fine("PlainTextViewer released");
        super.release();
        this.editor.ifPresent(JsonEditor::release);
        this.editor = Optional.empty();
        this.timerOnChangeShowingProperty.ifPresent(Timer::cancel);
    }

    private Optional<SScalar> extractDefaultScalar(ViewerData viewerData) {
        return viewerData.getMeta().getPorts().stream().map(port -> viewerData.get(port.getName(), SScalar.class)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    private Node renderPlainText(String text) {
        this.setText(text);
        Text textFX = new Text(text);
        TextFlow textFlow = new TextFlow(new Node[]{textFX});
        textFlow.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, null, null)}));
        ScrollPane scroller = new ScrollPane((Node)textFlow);
        scroller.layoutBoundsProperty().addListener((ob, o, n) -> {
            textFlow.setPrefWidth(n.getWidth() - 10.0);
            textFlow.setPrefHeight(n.getHeight() - 10.0);
        });
        return scroller;
    }

    private Node renderSwingText(String text) {
        this.setText(text);
        this.root.initializeSwingContent();
        SwingUtilities.invokeLater(() -> {
            this.root.jTextArea.setText(text);
            this.root.jTextArea.setCaretPosition(0);
        });
        return this.root.swingContainer;
    }

    private Node renderJSON(String text) {
        this.setText(text);
        this.editor.ifPresent(JsonEditor::release);
        WebView webView = new WebView();
        try {
            JsonEditor editor = new JsonEditor(text, webView);
            this.editor = Optional.of(editor);
        }
        catch (IOException | URISyntaxException e) {
            StareNotification.showWarn((String)"Fail to create JSON view");
            this.editor = Optional.empty();
        }
        return webView;
    }

    private void showTextFormatControls(boolean show) {
        this.root.btnDisplayAsText.setVisible(show);
        this.root.btnDisplayAsText.setManaged(show);
        this.root.btnDisplayAsJson.setVisible(show);
        this.root.btnDisplayAsJson.setManaged(show);
    }

    private static enum TextFormat {
        TEXT,
        JSON,
        SWING;

    }

    private static class PlainTextContent
    extends VBox {
        @FXML
        private ScrollPane scroller;
        @FXML
        private Text text;
        @FXML
        private TextFlow textFlow;
        @FXML
        private SwingNode swingContainer;
        @FXML
        private Button btnDisplayAsJson;
        @FXML
        private Button btnDisplayAsText;
        @FXML
        private AnchorPane textPane;
        private JTextArea jTextArea;
        private JScrollPane jScrollPane;
        private Button btnCopy;
        private Button btnSaveAsFile;
        private AnchorPane apIndicatorContainer;
        private FxRunIndicator runIndicator;

        private PlainTextContent() {
            try {
                CustomFXMLLoader.loadElement((Object)((Object)this));
                this.initializeToolbar();
                this.initializeRunIndicator();
                this.scroller.layoutBoundsProperty().addListener((ob, o, n) -> {
                    this.textFlow.setPrefWidth(n.getWidth() - 10.0);
                    this.textFlow.setPrefHeight(n.getHeight() - 10.0);
                });
            }
            catch (Throwable t) {
                logger.severe(t.getMessage());
            }
        }

        private void initializeToolbar() {
            this.btnCopy = new Button();
            this.btnCopy.setPrefSize(25.0, 25.0);
            this.btnSaveAsFile = new Button();
            this.btnSaveAsFile.setPrefSize(25.0, 25.0);
            this.btnDisplayAsText = new Button("Text");
            this.btnDisplayAsJson = new Button("JSON");
        }

        private void initializeRunIndicator() {
            this.runIndicator = new FxRunIndicator();
            this.apIndicatorContainer = new AnchorPane(new Node[]{this.runIndicator});
            PaneHelper.setAnchorZero((Node)this.runIndicator);
        }

        private void initializeSwingContent() {
            SwingUtilities.invokeLater(() -> {
                this.jTextArea = new JTextArea();
                this.jTextArea.setFont(new Font("Monospaced", 0, 14));
                this.jScrollPane = new JScrollPane(this.jTextArea);
                this.jScrollPane.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
                this.swingContainer.setContent((JComponent)this.jScrollPane);
                this.boundsInLocalProperty().addListener((observable, oldValue, newValue) -> {
                    this.jScrollPane.revalidate();
                    this.jScrollPane.repaint();
                });
                this.jScrollPane.revalidate();
                this.jScrollPane.repaint();
            });
        }
    }
}

