/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.viewers.ui.content;

import com.siams.cv.monitor.model.viewer.ImageMaskViewerModel;
import com.siams.cv.monitor.viewers.ui.content.BaseImageViewer;
import com.siams.cv.monitor.viewers.ui.content.BaseImageViewerContent;
import com.siams.cv.monitor.viewers.ui.content.BaseImageViewerControls;
import com.siams.cv.monitor.viewers.ui.content.IRasterViewerContent;
import com.siams.cv.monitor.viewers.ui.content.MaskViewerControls;
import com.siams.cv.monitor.viewers.ui.content.ViewerData;
import com.siams.stare.utils.MaskToColor;
import java.util.List;
import java.util.logging.Logger;
import javafx.scene.Node;
import javafx.scene.control.ColorPicker;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import net.algart.executors.api.data.SMat;

public class MaskViewer
extends BaseImageViewer<ImageMaskViewerModel> {
    private static final Logger logger = Logger.getLogger(MaskViewer.class.getCanonicalName());
    private MaskViewerContent root;

    public MaskViewer(ImageMaskViewerModel viewerModel) {
        super(viewerModel);
    }

    @Override
    protected void initializeRoot() {
        this.root = new MaskViewerContent((ImageMaskViewerModel)this.viewerModel);
    }

    @Override
    protected void initializeControls() {
        super.initializeControls();
        this.initializeMaskColor();
    }

    private void initializeMaskColor() {
        this.root.cpMaskColor.setValue((Object)this.getMaskColor());
        this.root.cpMaskColor.setOnAction(event -> {
            this.setMaskColor((Color)((ColorPicker)event.getSource()).getValue());
            this.viewerDataSource.getData().ifPresent(this::render);
            if (this.viewerStateHandler != null) {
                this.viewerStateHandler.onViewerStateChanged();
            }
        });
    }

    @Override
    protected void render(ViewerData viewerData) {
        long t1 = System.currentTimeMillis();
        if (!this.isEnabled()) {
            return;
        }
        if (this.imageViewRect == null) {
            return;
        }
        SMat sMat = this.extractDefaultData(viewerData);
        int viewRectWidth = (int)this.imageViewRect.getImageWidth();
        int viewRectHeight = (int)this.imageViewRect.getImageHeight();
        if (viewRectWidth <= 0 || viewRectHeight <= 0) {
            return;
        }
        WritableImage maskImage = new WritableImage(viewRectWidth, viewRectHeight);
        MaskToColor maskToColor = new MaskToColor(maskImage.getPixelWriter(), sMat, this.imageViewRect.getViewRect());
        maskToColor.setColor(this.getMaskColor());
        maskToColor.process();
        this.setImage((Image)maskImage);
        this.drawImage((Image)maskImage);
        logger.fine(String.format("MaskViewer:renderImage (%d) ms", System.currentTimeMillis() - t1));
    }

    @Override
    protected BaseImageViewerControls createImageViewControls() {
        return new MaskViewerControls(this);
    }

    @Override
    public List<Node> provideTools() {
        List<Node> baseTools = super.provideTools();
        baseTools.add((Node)this.root.cpMaskColor);
        return baseTools;
    }

    public void setMaskColor(Color maskColor) {
        ((ImageMaskViewerModel)this.viewerModel).setMaskColor(maskColor.toString());
    }

    public Color getMaskColor() {
        try {
            return Color.valueOf((String)((ImageMaskViewerModel)this.viewerModel).getMaskColor());
        }
        catch (Throwable ignore) {
            return Color.WHITE;
        }
    }

    @Override
    protected BaseImageViewerContent getBaseContent() {
        return this.root;
    }

    @Override
    protected IRasterViewerContent getRasterViewerContent() {
        return this.root;
    }

    private static class MaskViewerContent
    extends BaseImageViewerContent<ImageMaskViewerModel> {
        private final ColorPicker cpMaskColor = new ColorPicker();

        MaskViewerContent(ImageMaskViewerModel viewerModel) {
            super(viewerModel);
        }

        @Override
        public void center() {
        }
    }
}

