/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.viewers.ui.content;

import com.siams.cv.monitor.model.viewer.ChartViewerModel;
import com.siams.cv.monitor.viewers.ui.content.ChartViewer;
import com.siams.javafx.utils.FxColor;
import io.reactivex.annotations.NonNull;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.chart.AreaChart;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.ScatterChart;
import javafx.scene.chart.ValueAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.util.StringConverter;
import net.algart.executors.api.data.SNumbers;

public class FxChartViewer
extends ChartViewer {
    public FxChartViewer(ChartViewerModel model) {
        super(model);
    }

    @Override
    public void embed(Pane viewerContainer) {
        super.embed(viewerContainer);
        viewerContainer.getStylesheets().add((Object)"chart-viewer.css");
    }

    @Override
    protected Node createScatterChart(SNumbers sNumbers) {
        NumberAxis xAxis = this.numberAxisForRange(this.initialXLowerValue, this.initialXUpperValue);
        xAxis.setLabel(((ChartViewerModel)this.viewerModel).getXAxisTitle());
        NumberAxis yAxis = this.numberAxisForRange(this.initialYLowerValue, this.initialYUpperValue);
        yAxis.setLabel(((ChartViewerModel)this.viewerModel).getYAxisTitle());
        ObservableList<XYChart.Series<Number, Number>> data = this.getLineChartData(sNumbers);
        return new ScatterChart((Axis)xAxis, (Axis)yAxis, data);
    }

    protected XYChart<Number, Number> createLineChart(SNumbers sNumbers) {
        NumberAxis xAxis = this.numberAxisForRange(this.initialXLowerValue, this.initialXUpperValue);
        xAxis.setLabel(((ChartViewerModel)this.viewerModel).getXAxisTitle());
        NumberAxis yAxis = this.numberAxisForRange(this.initialYLowerValue, this.initialYUpperValue);
        yAxis.setLabel(((ChartViewerModel)this.viewerModel).getYAxisTitle());
        ObservableList<XYChart.Series<Number, Number>> data = this.getLineChartData(sNumbers);
        LineChart lineChart = new LineChart((Axis)xAxis, (Axis)yAxis, data);
        lineChart.createSymbolsProperty().bind((ObservableValue)this.hideTicksProperty);
        return lineChart;
    }

    protected XYChart<Number, Number> createAreaChart(SNumbers sNumbers) {
        NumberAxis xAxis = this.numberAxisForRange(this.initialXLowerValue, this.initialXUpperValue);
        xAxis.setLabel(((ChartViewerModel)this.viewerModel).getXAxisTitle());
        NumberAxis yAxis = this.numberAxisForRange(this.initialYLowerValue, this.initialYUpperValue);
        yAxis.setLabel(((ChartViewerModel)this.viewerModel).getYAxisTitle());
        ObservableList<XYChart.Series<Number, Number>> data = this.getLineChartData(sNumbers);
        AreaChart areaChart = new AreaChart((Axis)xAxis, (Axis)yAxis, data);
        areaChart.createSymbolsProperty().bind((ObservableValue)this.hideTicksProperty);
        return areaChart;
    }

    @Override
    protected Node createBarChart(SNumbers sNumbers) {
        return null;
    }

    @Override
    protected void initializeMouseHandler(Node chartNode) {
        NumberAxis xAxis = (NumberAxis)((XYChart)chartNode).getXAxis();
        NumberAxis yAxis = (NumberAxis)((XYChart)chartNode).getYAxis();
        Region plot = (Region)chartNode.lookup(".chart-plot-background");
        chartNode.lookup(".plot-content").setMouseTransparent(true);
        this.mouseHandler = new FxChartMouseHandler(xAxis, yAxis);
        this.initializeMouseActions(plot);
    }

    @Override
    protected Map<String, Double> cacheChartPosition(Node previousChartNode) {
        try {
            XYChart prevChart = (XYChart)previousChartNode;
            ValueAxis xAxis = (ValueAxis)prevChart.getXAxis();
            ValueAxis yAxis = (ValueAxis)prevChart.getYAxis();
            return new HashMap<String, Double>(Map.of("minX", xAxis.getLowerBound(), "maxX", xAxis.getUpperBound(), "minY", yAxis.getLowerBound(), "maxY", yAxis.getUpperBound()));
        }
        catch (ClassCastException unsupportedChartType) {
            logger.log(Level.SEVERE, "Fail to save chart position", unsupportedChartType);
            return null;
        }
    }

    @Override
    protected void restoreChartPosition(@NonNull Map<String, Double> cache, Node chartNode) {
        try {
            XYChart chart = (XYChart)chartNode;
            ValueAxis xAxis = (ValueAxis)chart.getXAxis();
            ValueAxis yAxis = (ValueAxis)chart.getYAxis();
            xAxis.setLowerBound(cache.get("minX").doubleValue());
            xAxis.setUpperBound(cache.get("maxX").doubleValue());
            yAxis.setLowerBound(cache.get("minY").doubleValue());
            yAxis.setUpperBound(cache.get("maxY").doubleValue());
        }
        catch (ClassCastException unsupportedChartType) {
            logger.severe("Fail to restore chart position: " + unsupportedChartType.getMessage());
        }
    }

    private void applyStyleClass(Parent chartNode) {
        AtomicInteger ai = new AtomicInteger(0);
        CharSequence[] styles = (String[])chartNode.lookupAll(".chart-series-line").stream().map(node -> this.toStyleClass(ai.getAndIncrement(), Color.PURPLE)).toArray(String[]::new);
        String styleClass = String.join((CharSequence)"\n", styles);
        try {
            File temp = new File("tempfile.css");
            if (temp.exists()) {
                temp.delete();
                temp.createNewFile();
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(temp));
            bw.write(styleClass);
            bw.close();
            chartNode.getStylesheets().add((Object)temp.toURI().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String toStyleClass(int index, Color color) {
        String webColor = FxColor.toHtml((Color)color, (boolean)true);
        return String.format(".default-color%d.chart-line-symbol { -fx-background-color: %s; }\n.default-color%d.chart-series-line { -fx-stroke: %s; }\n.default-color%d.chart-series-area-fill { -fx-fill: %s; }", index, webColor, index, webColor, index, webColor);
    }

    private NumberAxis numberAxisForRange(double min, double max) {
        double lower = this.floorAxisRange(min);
        double upper = this.ceilAxisRange(max);
        double tickUnit = (upper - lower) / 10.0;
        final NumberAxis axis = new NumberAxis(lower, upper, tickUnit);
        axis.setTickLabelFormatter((StringConverter)new StringConverter<Number>(this){
            private DecimalFormat formatter = new DecimalFormat();

            public String toString(Number number) {
                double lower = axis.getLowerBound();
                double upper = axis.getUpperBound();
                if (upper - lower <= 1.0) {
                    this.formatter.applyPattern("#.##");
                } else if (upper - lower <= 10.0) {
                    this.formatter.applyPattern("#.#");
                } else {
                    this.formatter.applyPattern("#");
                }
                if (Math.abs(number.doubleValue()) >= 1000.0) {
                    return this.formatter.format(number.intValue() / 1000) + "k";
                }
                return this.formatter.format(number);
            }

            public Number fromString(String s) {
                try {
                    return Integer.parseInt(s);
                }
                catch (NumberFormatException ignore) {
                    try {
                        return Double.parseDouble(s);
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            }
        });
        return axis;
    }

    private static class FxChartMouseHandler
    implements ChartViewer.ChartMouseHandler {
        private static final double ZOOM_IN_LIMIT = 0.05;
        private static final double ZOOM_OUT_LIMIT = 2.0;
        private static final double SCALE_FACTOR = 0.8;
        private final NumberAxis xAxis;
        private final NumberAxis yAxis;
        private final double initialXLowerValue;
        private final double initialXUpperValue;
        private final double initialXTickUnit;
        private final double initialYLowerValue;
        private final double initialYUpperValue;
        private final double initialYTickUnit;
        private Point2D startX = Point2D.ZERO;
        private Point2D startY = Point2D.ZERO;

        private FxChartMouseHandler(NumberAxis xAxis, NumberAxis yAxis) {
            this.xAxis = xAxis;
            this.yAxis = yAxis;
            this.initialXLowerValue = xAxis.getLowerBound();
            this.initialXUpperValue = xAxis.getUpperBound();
            this.initialXTickUnit = xAxis.getTickUnit();
            this.initialYLowerValue = yAxis.getLowerBound();
            this.initialYUpperValue = yAxis.getUpperBound();
            this.initialYTickUnit = yAxis.getTickUnit();
        }

        @Override
        public void zoomIn() {
            double maxRange;
            double range = this.xAxis.getUpperBound() - this.xAxis.getLowerBound();
            if (range > (maxRange = (this.initialXUpperValue - this.initialXLowerValue) * 0.05)) {
                this.makeZoom((ValueAxis<?>)this.xAxis, 0.8);
            }
            if ((range = this.yAxis.getUpperBound() - this.yAxis.getLowerBound()) > (maxRange = (this.initialYUpperValue - this.initialYLowerValue) * 0.05)) {
                this.makeZoom((ValueAxis<?>)this.yAxis, 0.8);
            }
        }

        @Override
        public void zoomOut() {
            double maxRange;
            double range = this.xAxis.getUpperBound() - this.xAxis.getLowerBound();
            if (range < (maxRange = (this.initialXUpperValue - this.initialXLowerValue) * 2.0)) {
                this.makeZoom((ValueAxis<?>)this.xAxis, 1.25);
            }
            if ((range = this.yAxis.getUpperBound() - this.yAxis.getLowerBound()) < (maxRange = (this.initialYUpperValue - this.initialYLowerValue) * 2.0)) {
                this.makeZoom((ValueAxis<?>)this.yAxis, 1.25);
            }
        }

        private void makeZoom(ValueAxis<?> axis, double scaleFactor) {
            double oldLower = axis.getLowerBound();
            double oldUpper = axis.getUpperBound();
            double range = oldUpper - oldLower;
            double newRange = range * scaleFactor;
            double cap = (newRange - range) / 2.0;
            axis.setLowerBound(oldLower - cap);
            axis.setUpperBound(oldUpper + cap);
            if (axis instanceof NumberAxis) {
                NumberAxis numAxis = (NumberAxis)axis;
                numAxis.setTickUnit(numAxis.getTickUnit() * scaleFactor);
            }
        }

        @Override
        public void zoomReset() {
            this.xAxis.setLowerBound(this.initialXLowerValue);
            this.xAxis.setUpperBound(this.initialXUpperValue);
            this.xAxis.setTickUnit(this.initialXTickUnit);
            this.yAxis.setLowerBound(this.initialYLowerValue);
            this.yAxis.setUpperBound(this.initialYUpperValue);
            this.yAxis.setTickUnit(this.initialYTickUnit);
        }

        @Override
        public void onScrollStart() {
            this.startX = new Point2D(this.xAxis.getLowerBound(), this.xAxis.getUpperBound());
            this.startY = new Point2D(this.yAxis.getLowerBound(), this.yAxis.getUpperBound());
        }

        @Override
        public void scrollXByFraction(double fraction) {
            double startRange = this.startX.getY() - this.startX.getX();
            double cap = startRange * fraction;
            this.xAxis.setLowerBound(this.startX.getX() - cap);
            this.xAxis.setUpperBound(this.startX.getY() - cap);
        }

        @Override
        public void scrollYByFraction(double fraction) {
            double startRange = this.startY.getY() - this.startY.getX();
            double cap = startRange * fraction;
            this.yAxis.setLowerBound(this.startY.getX() + cap);
            this.yAxis.setUpperBound(this.startY.getY() + cap);
        }

        @Override
        public void zoomByRect(double leftF, double rightF, double botF, double topF) {
            double fullXRange = this.xAxis.getUpperBound() - this.xAxis.getLowerBound();
            double fullYRange = this.yAxis.getUpperBound() - this.yAxis.getLowerBound();
            double leftCap = fullXRange * leftF;
            double rightCap = fullXRange * rightF;
            double bottomCap = fullYRange * botF;
            double topCap = fullYRange * topF;
            this.xAxis.setLowerBound(this.xAxis.getLowerBound() + leftCap);
            this.xAxis.setUpperBound(this.xAxis.getUpperBound() - rightCap);
            this.yAxis.setLowerBound(this.yAxis.getLowerBound() + bottomCap);
            this.yAxis.setUpperBound(this.yAxis.getUpperBound() - topCap);
            double xTickScaleFactor = 1.0 - leftF - rightF;
            double yTickScaleFactor = 1.0 - botF - topF;
            this.xAxis.setTickUnit(this.xAxis.getTickUnit() * xTickScaleFactor);
            this.yAxis.setTickUnit(this.yAxis.getTickUnit() * yTickScaleFactor);
        }
    }

    protected static class LayerStyle {
        protected final int index;
        protected String name = "";
        protected Color color = Color.BLACK;
        protected Symbol symbol = Symbol.SQUARE;
        protected boolean fillSymbol = true;

        public LayerStyle(int index) {
            this.index = index;
        }

        public LayerStyle setName(String name) {
            this.name = name;
            return this;
        }

        public LayerStyle setColor(Color color) {
            this.color = color;
            return this;
        }

        public LayerStyle setName(Symbol symbol) {
            this.symbol = symbol;
            return this;
        }

        public LayerStyle setFillSymbol(boolean fillSymbol) {
            this.fillSymbol = fillSymbol;
            return this;
        }
    }

    public static enum Symbol {
        CIRCLE("circle"),
        SQUARE("square"),
        TRIANGLE("triangle"),
        DIAMOND("diamond"),
        CROSS("cross"),
        TICK("tick");

        private String name;

        private Symbol(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static Symbol from(String name) {
            for (Symbol symbol : Symbol.values()) {
                if (!symbol.name.equalsIgnoreCase(name)) continue;
                return symbol;
            }
            throw new IllegalArgumentException("No Symbol enum constant \"" + name + "\"");
        }

        public String toCSS() {
            switch (this.ordinal()) {
                case 1: {
                    return "M10,0 L10,10 L0,10 L0,0 Z";
                }
                case 2: {
                    return "M5,0 L10,8 L0,8 Z";
                }
                case 3: {
                    return "M5,0 L10,9 L5,18 L0,9 Z";
                }
                case 4: {
                    return "M2,0 L5,4 L8,0 L10,0 L10,2 L6,5 L10,8 L10,10 L8,10 L5,6 L2,10 L0,10 L0,8 L4,5 L0,2 L0,0 Z";
                }
                case 5: {
                    return "M0,5 L3,5 L5,10 L8,0 L10,0 L5,12 Z";
                }
            }
            return "M5,0 A10,10 Z";
        }
    }
}

