/*
 * Decompiled with CFR 0.152.
 */
package net.algart.jep.tests;

import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import jep.JepConfig;
import jep.SharedInterpreter;

public class SimpleJepTest {
    static String pythonRoot() {
        String root = "src/test/resources/python_tests";
        Path path = Path.of("src/test/resources/python_tests", new String[0]).toAbsolutePath();
        System.out.printf("Using Python home: %s%n", path);
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new AssertionError((Object)(String.valueOf(path) + " is not an existing folder!"));
        }
        return "src/test/resources/python_tests";
    }

    static void configurePython(String root) {
        JepConfig config = new JepConfig();
        config.addIncludePaths(new String[]{root});
        config.redirectStdout((OutputStream)System.out);
        config.redirectStdErr((OutputStream)System.err);
        SharedInterpreter.setConfig((JepConfig)config);
    }

    public static void main(String[] args) throws FileNotFoundException {
        String root = SimpleJepTest.pythonRoot();
        SimpleJepTest.configurePython(root);
        try (SharedInterpreter interp = new SharedInterpreter();){
            System.out.println("Interpreter: " + String.valueOf(interp));
            System.out.println();
            interp.exec("from tests import SimpleTest");
            interp.exec("from java.lang import System\n");
            interp.exec("s = 'Hello World'");
            interp.exec("System.out.println(\"(java:) \" + s)");
            interp.exec("print(sys.path)");
            interp.exec("print(s)");
            interp.exec("result = SimpleTest.demo()");
            interp.exec("print(result)");
            interp.exec("System.out.println(\"(java:) \" + result)");
        }
    }
}

