/*
 * Decompiled with CFR 0.152.
 */
package net.algart.graalvm.tests;

import java.util.Objects;
import java.util.function.Supplier;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import net.algart.executors.api.graalvm.js.scriptengine.JavaScriptException;
import net.algart.graalvm.GraalPerformer;
import net.algart.graalvm.GraalValues;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Value;

public class GraalValuesTest {
    private static final ScriptEngine ENGINE = new ScriptEngineManager(GraalValuesTest.class.getClassLoader()).getEngineByName("javascript");
    private static final GraalPerformer PERFORMER = GraalPerformer.newPerformer((Context)Context.create((String[])new String[0]));

    private static void test(String script) {
        Value value;
        System.out.println("**********");
        System.out.printf("Performing \"%s\"...%n", script);
        try {
            value = PERFORMER.performJS((CharSequence)script);
        }
        catch (RuntimeException e) {
            System.out.printf("%s%n%n%n", e);
            return;
        }
        System.out.printf("Result value \"%s\"%n", value);
        System.out.printf("isNull: %s%n", value.isNull());
        System.out.printf("isBoolean: %s%n", value.isBoolean());
        System.out.printf("isNumber: %s%n", value.isNumber());
        System.out.printf("fitsInDouble: %s%n", value.fitsInDouble());
        System.out.printf("fitsInInt: %s%n", value.fitsInInt());
        System.out.printf("hasArrayElements: %s%n", value.hasArrayElements());
        System.out.printf("as(Object.class): %s%n", GraalValuesTest.objectInfo(value.as(Object.class)));
        String smartString = GraalValues.toSmartString((Value)value, (boolean)true);
        System.out.printf("toSmartString(true): \"%s\"%n", smartString);
        System.out.printf("toSmartString(false): \"%s\"%n", GraalValues.toSmartString((Value)value, (boolean)false));
        boolean smartBoolean = GraalValues.toSmartBoolean((Value)value);
        System.out.printf("toSmartBoolean: %s%n", smartBoolean);
        Object smartDouble = GraalValuesTest.wrapException(() -> GraalValues.toSmartDouble((Value)value));
        System.out.printf("toSmartDouble: %s%n", smartDouble);
        System.out.println();
        Object jsResult = GraalValuesTest.perform(script);
        System.out.printf("Result object via ScriptEngine: %s%n", GraalValuesTest.objectInfo(jsResult));
        String calculateStringOrNumber = GraalValuesTest.calculateStringOrNumber(script);
        System.out.printf("calculateStringOrNumber: %s%n", calculateStringOrNumber);
        boolean calculateBoolean = GraalValuesTest.calculateBoolean(script);
        System.out.printf("calculateBoolean: %s%n", calculateBoolean);
        Object calculateDouble = GraalValuesTest.wrapException(() -> GraalValuesTest.calculateDouble(script));
        System.out.printf("calculateDouble: %s%n", calculateDouble);
        if (!Objects.equals(smartString, calculateStringOrNumber)) {
            throw new AssertionError((Object)"toSmartString/calculateStringOrNumber mismatch");
        }
        if (calculateBoolean != smartBoolean) {
            throw new AssertionError((Object)"toSmartBoolean/calculateBoolean mismatch");
        }
        if ((smartDouble instanceof Double || calculateDouble instanceof Double) && !Objects.equals(smartDouble, calculateDouble)) {
            throw new AssertionError((Object)"toSmartDouble/calculateDouble mismatch");
        }
        System.out.println();
        System.out.println();
    }

    private static Object wrapException(Supplier<Object> supplier) {
        try {
            return supplier.get();
        }
        catch (RuntimeException e) {
            return e;
        }
    }

    private static String objectInfo(Object object) {
        return object == null ? "null" : String.format("\"%s\" (%s)", object, object.getClass());
    }

    public static Object perform(String script) {
        try {
            return ENGINE.eval(script);
        }
        catch (ScriptException e) {
            throw JavaScriptException.wrap((ScriptException)e, (String)script);
        }
    }

    public static boolean calculateBoolean(String script) {
        Object result = GraalValuesTest.perform(script);
        if (result == null || result.equals("")) {
            return false;
        }
        return Boolean.parseBoolean(result.toString());
    }

    public static double calculateDouble(String script) {
        Object result = GraalValuesTest.perform(script);
        if (result == null) {
            return Double.NaN;
        }
        return Double.parseDouble(result.toString());
    }

    public static String calculateStringOrNumber(String script) {
        double v;
        Object result = GraalValuesTest.perform(script);
        if (result == null) {
            return null;
        }
        if ((result instanceof Double || result instanceof Float) && (v = ((Number)result).doubleValue()) == (double)((int)v)) {
            result = (int)v;
        }
        return result.toString();
    }

    public static void main(String[] args) throws ScriptException, InterruptedException {
        GraalValuesTest.test(null);
        GraalValuesTest.test("null");
        GraalValuesTest.test("");
        GraalValuesTest.test("''");
        GraalValuesTest.test("' '");
        GraalValuesTest.test("true");
        GraalValuesTest.test("'true'");
        GraalValuesTest.test("'True'");
        GraalValuesTest.test("false");
        GraalValuesTest.test("'false'");
        GraalValuesTest.test("'False'");
        GraalValuesTest.test("3+5");
        GraalValuesTest.test("parseFloat('8.0')");
        GraalValuesTest.test("0.0");
        GraalValuesTest.test("-0");
        GraalValuesTest.test("NaN");
        GraalValuesTest.test("1/0");
        GraalValuesTest.test("-1/0");
        GraalValuesTest.test("3+5.1");
        GraalValuesTest.test("[1,2,3]");
        GraalValuesTest.test("32341235414352345234661.23");
        GraalValuesTest.test("32341235414352345234661");
        GraalValuesTest.test("avc");
        GraalValuesTest.test("Math.abs");
        GraalValuesTest.test("Math.abss");
    }
}

