/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.demo;

import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.Executor;

public final class ExampleWithTaskAfterAll
extends Executor {
    private final FinishHook finishHook = new FinishHook();
    private final FinishHookPreprocess finishHookPreprocess = new FinishHookPreprocess();
    private final FinishHookPostprocess finishHookPostprocess = new FinishHookPostprocess();

    public void process() {
        ExampleWithTaskAfterAll.addOneTimeTaskAfterExecutingAll((Runnable)this.finishHookPreprocess);
        ExampleWithTaskAfterAll.addOneTimeTaskAfterExecutingAll((Runnable)this.finishHook);
        ExampleWithTaskAfterAll.addOneTimeTaskAfterExecutingAll((Runnable)new FinishHookPostprocess());
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Tasks before executing all:%n  %s%n", ExampleWithTaskAfterAll.allTasksBeforeExecutingAll()));
        sb.append(String.format("Tasks after executing all:%n  %s%n", ExampleWithTaskAfterAll.allTasksAfterExecutingAll()));
        sb.append(String.format("One-time tasks after executing all:%n  %s%n", ExampleWithTaskAfterAll.allOneTimeTasksAfterExecutingAll()));
        this.getScalar().setTo(sb.toString());
    }

    public static void main(String[] args) {
        ExampleWithTaskAfterAll.beforeExecutingAll();
        ExampleWithTaskAfterAll.addOneTimeTaskAfterExecutingAll(() -> System.out.println("Hook 1"));
        ExampleWithTaskAfterAll.addOneTimeTaskAfterExecutingAll(() -> System.out.println("Hook 2"));
        ExampleWithTaskAfterAll.addOneTimeTaskAfterExecutingAll(() -> System.out.println("Hook 3"));
        ExampleWithTaskAfterAll.afterExecutingAll();
        ExampleWithTaskAfterAll.afterExecutingAll();
    }

    private class FinishHook
    implements Runnable {
        private FinishHook() {
        }

        @Override
        public void run() {
            System.out.printf("*** Clearing %s%n", new Object[]{ExampleWithTaskAfterAll.this});
        }

        public String toString() {
            return "FinishHook";
        }
    }

    private static class FinishHookPreprocess
    implements Runnable {
        private FinishHookPreprocess() {
        }

        @Override
        public void run() {
            System.out.printf("%n%n*** Previous hook: one-time tasks after executing all:%n  %s%n", ExecutionBlock.allOneTimeTasksAfterExecutingAll());
        }

        public String toString() {
            return "FinishHookPreprocess";
        }
    }

    private static class FinishHookPostprocess
    implements Runnable {
        private FinishHookPostprocess() {
        }

        @Override
        public void run() {
            System.out.printf("*** Next hook: one-time tasks after executing all:%n  %s%n%n", ExecutionBlock.allOneTimeTasksAfterExecutingAll());
        }

        public String toString() {
            return "FinishHookPostprocess";
        }
    }
}

