/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.demo;

import java.nio.ByteBuffer;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.ExecutionVisibleResultsInformation;
import net.algart.executors.api.data.Data;
import net.algart.executors.api.data.DataType;
import net.algart.executors.api.data.Port;
import net.algart.executors.api.data.SMat;

public final class ExampleSMatExecutionBlock
extends ExecutionBlock {
    private static final System.Logger LOG = System.getLogger(ExampleSMatExecutionBlock.class.getName());
    private String operation = "zeros";

    public void execute() {
        Port input = this.getInputPort("image");
        Port output = this.getOutputPort("image");
        if (!input.getDataType().typeName().equals("mat")) {
            throw new IllegalArgumentException("unsupported input data type");
        }
        if (!output.getDataType().typeName().equals("mat")) {
            throw new IllegalArgumentException("unsupported output data type");
        }
        Data inData = input.getData();
        Data outData = output.getData();
        if (inData.type() != DataType.MAT) {
            throw new IllegalArgumentException("Unsupported input data type");
        }
        SMat mat = (SMat)inData;
        ByteBuffer inByteBuffer = mat.getByteBuffer();
        if (inByteBuffer == null) {
            throw new IllegalArgumentException("input byte buffer is null");
        }
        inByteBuffer.rewind();
        ByteBuffer outByteBuffer = ByteBuffer.allocateDirect(mat.getByteBuffer().capacity());
        if (this.operation.equals("copy")) {
            while (inByteBuffer.position() < inByteBuffer.limit()) {
                outByteBuffer.put(inByteBuffer.get());
            }
        }
        SMat outMat = (SMat)outData;
        outMat.setAll(mat.getDimensions(), mat.getDepth(), mat.getNumberOfChannels(), outByteBuffer, false);
        output.setData((Data)outMat);
        LOG.log(System.Logger.Level.INFO, "Operation code: " + this.operation);
    }

    public ExecutionVisibleResultsInformation visibleResultsInformation() {
        return new ExecutionVisibleResultsInformation().setPorts(new Port[]{this.getOutputPort("image")});
    }

    public void onChangeParameter(String name) {
        if (name.equals("operation")) {
            this.operation = this.parameters().getString(name);
        }
    }
}

