/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.demo;

import net.algart.executors.api.Executor;
import net.algart.executors.api.data.Port;
import net.algart.executors.api.data.SMat;

public final class ExampleSMatCreate
extends Executor {
    private int width = 10;
    private int height = 10;
    private int channels = 1;

    public void process() {
        Port output = this.getRequiredOutputPort("output");
        SMat outMat = (SMat)output.getData(SMat.class, true);
        byte[] byteArray = new byte[this.height * this.width * this.channels];
        for (int i = 0; i < byteArray.length; ++i) {
            int c = i % this.channels;
            byteArray[i] = (byte)(i * (c + 1));
        }
        outMat.setAll(new long[]{this.width, this.height}, SMat.Depth.U8, this.channels, byteArray);
        outMat.setInitialized(true);
    }

    public void onChangeParameter(String name) {
        switch (name) {
            case "width": {
                this.width = this.parameters().getInteger(name);
                break;
            }
            case "height": {
                this.height = this.parameters().getInteger(name);
                break;
            }
            case "channels": {
                this.channels = this.parameters().getInteger(name);
            }
        }
    }
}

