/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.demo;

import net.algart.arrays.Array;
import net.algart.arrays.BitArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.TooLargeArrayException;
import net.algart.arrays.UpdatableBitArray;
import net.algart.executors.modules.core.common.matrices.MultiMatrixGenerator;
import net.algart.multimatrix.MultiMatrix;

public final class ExampleMultiMatrixGradients
extends MultiMatrixGenerator {
    private int shift = 0;
    private double multiplierForFP = 1.5;

    public int getShift() {
        return this.shift;
    }

    public ExampleMultiMatrixGradients setShift(int shift) {
        this.shift = shift;
        return this;
    }

    public double getMultiplierForFP() {
        return this.multiplierForFP;
    }

    public ExampleMultiMatrixGradients setMultiplierForFP(double multiplierForFP) {
        this.multiplierForFP = multiplierForFP;
        return this;
    }

    public MultiMatrix create() {
        return this.create(this.getDimX(), this.getDimY(), this.getNumberOfChannels());
    }

    public MultiMatrix create(long dimX, long dimY, int numberOfChannels) {
        return MultiMatrix.ofMerged((Matrix)Matrices.matrix((Array)this.makeSamples(dimX, dimY, numberOfChannels), (long[])new long[]{dimX, dimY, numberOfChannels}));
    }

    private PArray makeSamples(long dimX, long dimY, int numberOfChannels) {
        if (dimX > Integer.MAX_VALUE || dimY > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Matrix sizes " + dimX + "*" + dimY + " > 2^31-1");
        }
        int w = (int)dimX;
        int h = (int)dimY;
        Class elementType = this.getElementType();
        if (elementType == Boolean.TYPE) {
            UpdatableBitArray channels = BitArray.newArray((long)(dimX * dimY * (long)numberOfChannels));
            for (int y = 0; y < h; ++y) {
                ChannelsRange cr = ExampleMultiMatrixGradients.channelsRange(y, numberOfChannels);
                for (long c = (long)cr.c1(); c <= (long)cr.c2(); ++c) {
                    long channelDisp = c * dimX * dimY;
                    long x = 0L;
                    long disp = (long)y * (long)w + channelDisp;
                    while (x < (long)w) {
                        channels.setBitNoSync(disp, ((long)this.shift + x + (long)y & 0xFFL) >= 128L);
                        ++x;
                        ++disp;
                    }
                }
            }
            return channels;
        }
        if (dimX * dimY > (long)(Integer.MAX_VALUE / numberOfChannels)) {
            throw new TooLargeArrayException("Matrix size " + dimX + "*" + dimY + "*" + numberOfChannels + " > 2^31-1");
        }
        int matrixSize = w * h;
        if (elementType == Byte.TYPE) {
            byte[] channels = new byte[matrixSize * numberOfChannels];
            for (int y = 0; y < h; ++y) {
                ChannelsRange cr = ExampleMultiMatrixGradients.channelsRange(y, numberOfChannels);
                for (int c = cr.c1(); c <= cr.c2(); ++c) {
                    int x = 0;
                    int disp = y * w;
                    while (x < w) {
                        channels[disp + c * matrixSize] = (byte)(this.shift + x + y);
                        ++x;
                        ++disp;
                    }
                }
            }
            return SimpleMemoryModel.asUpdatableByteArray((byte[])channels);
        }
        if (elementType == Short.TYPE) {
            short[] channels = new short[matrixSize * numberOfChannels];
            for (int y = 0; y < h; ++y) {
                ChannelsRange cr = ExampleMultiMatrixGradients.channelsRange(y, numberOfChannels);
                for (int c = cr.c1(); c <= cr.c2(); ++c) {
                    int x = 0;
                    int disp = y * w;
                    while (x < w) {
                        channels[disp + c * matrixSize] = (short)(157 * (this.shift + x + y));
                        ++x;
                        ++disp;
                    }
                }
            }
            return SimpleMemoryModel.asUpdatableShortArray((short[])channels);
        }
        if (elementType == Integer.TYPE) {
            int[] channels = new int[matrixSize * numberOfChannels];
            for (int y = 0; y < h; ++y) {
                ChannelsRange cr = ExampleMultiMatrixGradients.channelsRange(y, numberOfChannels);
                for (int c = cr.c1(); c <= cr.c2(); ++c) {
                    int x = 0;
                    int disp = y * w;
                    while (x < w) {
                        channels[disp + c * matrixSize] = 0x9D0000 * (this.shift + x + y);
                        ++x;
                        ++disp;
                    }
                }
            }
            return SimpleMemoryModel.asUpdatableIntArray((int[])channels);
        }
        if (elementType == Float.TYPE) {
            float[] channels = new float[matrixSize * numberOfChannels];
            for (int y = 0; y < h; ++y) {
                ChannelsRange cr = ExampleMultiMatrixGradients.channelsRange(y, numberOfChannels);
                for (int c = cr.c1(); c <= cr.c2(); ++c) {
                    int x = 0;
                    int disp = y * w;
                    while (x < w) {
                        int v = this.shift + x + y & 0xFF;
                        channels[disp + c * matrixSize] = (float)(0.5 + this.multiplierForFP * ((double)v / 256.0 - 0.5));
                        ++x;
                        ++disp;
                    }
                }
            }
            return SimpleMemoryModel.asUpdatableFloatArray((float[])channels);
        }
        if (elementType == Double.TYPE) {
            double[] channels = new double[matrixSize * numberOfChannels];
            for (int y = 0; y < h; ++y) {
                ChannelsRange cr = ExampleMultiMatrixGradients.channelsRange(y, numberOfChannels);
                for (int c = cr.c1(); c <= cr.c2(); ++c) {
                    int x = 0;
                    int disp = y * w;
                    while (x < w) {
                        int v = this.shift + x + y & 0xFF;
                        channels[disp + c * matrixSize] = (float)(0.5 + this.multiplierForFP * ((double)v / 256.0 - 0.5));
                        ++x;
                        ++disp;
                    }
                }
            }
            return SimpleMemoryModel.asUpdatableDoubleArray((double[])channels);
        }
        throw new UnsupportedOperationException("Unsupported sampleType = " + String.valueOf(elementType));
    }

    private static ChannelsRange channelsRange(int y, int numberOfChannels) {
        int c1;
        int c2 = c1 = y / 32 % (numberOfChannels + 1) - 1;
        if (c1 == -1) {
            c1 = 0;
            c2 = numberOfChannels - 1;
        }
        return new ChannelsRange(c1, c2);
    }

    private record ChannelsRange(int c1, int c2) {
    }
}

