/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.common.io.tests;

import java.nio.file.Path;
import java.nio.file.Paths;
import net.algart.executors.api.Executor;
import net.algart.executors.modules.core.common.io.PathPropertyReplacement;
import net.algart.executors.modules.core.system.Gc;

public class PathPropertyReplacementTest {
    public static void main(String[] args) {
        for (String s : new String[]{"1234.dat", "%TEMP%", "$a", "%", "${a}", "$$$", "a${something}", "b${%some%}xxx"}) {
            System.out.printf("%s %s properties, probably %s%n", s, PathPropertyReplacement.hasProperties((String)s) ? "CONTAINS" : "does not contain", PathPropertyReplacement.hasProbableProperties((String)s) ? "CONTAINS" : "does not contain");
        }
        System.out.println();
        Gc e = new Gc();
        e.setContextPath("c:/tmp/chain.json");
        System.out.println(PathPropertyReplacement.translatePathProperties((String)"myPath/${file.name.ext}; myPath/${file.name}/", (Executor)e));
        System.out.println(PathPropertyReplacement.translatePathProperties((String)"myPath/${path.name.ext}; myPath/${path.name}/", (Path)Paths.get("chain.json", new String[0])));
        e.setContextPath("/123.dir");
        System.out.println(PathPropertyReplacement.translateProperties((String)"${java.io.tmpdir}tmp/${file.name.ext}; ${path.name}/123", (Path)Paths.get("/123.dir", new String[0])));
        System.out.println("First path property: " + String.valueOf(PathPropertyReplacement.firstPathProperty((String)"${java.io.tmpdir}tmp/${file.name.ext}; ${path.name}/123")));
        System.out.println();
        String s = "c:/tmp/";
        Path p = Paths.get(s, new String[0]).getFileSystem().getPath("\\aaa", new String[0]);
        System.out.println(Paths.get(s, new String[0]).resolve(p));
        System.out.println(p.isAbsolute() + " - " + String.valueOf(p));
        System.out.println(PathPropertyReplacement.translateTmpDir((String)"%TEMP%\\test.dat"));
        System.out.println(PathPropertyReplacement.translateTmpDir((String)"%TEMP%test.dat"));
        System.out.println(PathPropertyReplacement.translateTmpDir((String)"%TEMP%/test.dat"));
        System.out.println(PathPropertyReplacement.translateTmpDir((String)"%TEMP%//test.dat"));
    }
}

