/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.tests;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.imageio.ImageIO;
import net.algart.arrays.Array;
import net.algart.arrays.BitArray;
import net.algart.arrays.BufferMemoryModel;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MutableBitArray;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatableBitArray;
import net.algart.executors.api.data.SMat;
import net.algart.io.MatrixIO;
import net.algart.math.functions.Func;
import net.algart.math.functions.RectangularFunc;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public class SMatBitTest {
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.printf("Usage: %s source_image%n", SMatBitTest.class);
            return;
        }
        Path sourceFile = Paths.get(args[0], new String[0]);
        MultiMatrix2D multiMatrix = MultiMatrix.of2DRGBA((List)MatrixIO.readImage((Path)sourceFile));
        Matrix intensity = multiMatrix.intensityChannel();
        Matrix bits = Matrices.asFuncMatrix((Func)RectangularFunc.getInstance((double)0.0, (double)(((PArray)intensity.array()).maxPossibleValue(1.0) / 2.0), (double)0.0, (double)1.0), BitArray.class, (Matrix)intensity);
        MutableBitArray container = BufferMemoryModel.getInstance().newBitArray(2L * ((BitArray)bits.array()).length());
        UpdatableBitArray array = container.subArr(((BitArray)bits.array()).length() / 3L, ((BitArray)bits.array()).length());
        array.copy(bits.array());
        bits = Matrices.matrix((Array)array, (long[])bits.dimensions());
        MultiMatrix2D bitsMultiMatrix = MultiMatrix.of2DMono((Matrix)bits);
        System.out.printf("Created MultiMatrix: %s - %s%n", bitsMultiMatrix, bitsMultiMatrix.intensityChannel());
        MatrixIO.writeImage((Path)Paths.get(String.valueOf(sourceFile) + ".aa.bit.png", new String[0]), (List)bitsMultiMatrix.allChannelsInRGBAOrder());
        assert (bitsMultiMatrix.numberOfChannels() == 1);
        SMat mat = new SMat().setTo((MultiMatrix)bitsMultiMatrix);
        System.out.printf("-> mat: %s%n", mat);
        mat.getByteBuffer().limit((int)((((BitArray)bits.array()).length() + 7L) / 8L));
        MultiMatrix2D restoredMultiMatrix = mat.toMultiMatrix2D(true);
        System.out.printf("-> MultiMatrix: %s%n", restoredMultiMatrix);
        MatrixIO.writeImage((Path)Paths.get(String.valueOf(sourceFile) + ".2aa.bit.png", new String[0]), (List)restoredMultiMatrix.allChannelsInRGBAOrder());
        if (!bitsMultiMatrix.intensityChannel().equals((Object)restoredMultiMatrix.intensityChannel())) {
            throw new AssertionError((Object)"Error while restoring multi-matrix");
        }
        BufferedImage bufferedImage = mat.toBufferedImage();
        System.out.printf("-> bufferedImage: %s%n", bufferedImage);
        assert (bufferedImage != null);
        ImageIO.write((RenderedImage)bufferedImage, "png", new File(String.valueOf(sourceFile) + "2bb.bit.png"));
    }
}

