/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.tests;

import java.nio.file.Path;
import java.util.List;
import net.algart.executors.modules.core.common.io.FileOperation;

public class RelativeOSPathTest {
    public static void main(String[] args) {
        String[] paths = new String[]{"", ".", "../.", "../", "/tmp/data.jpg", "some_folder/data.txt", "/some_folder/data.txt"};
        Path current = FileOperation.currentOSPath();
        System.out.printf("Current OS path: %s%n", current);
        for (String s : paths) {
            System.out.printf("%nTesting \"%s\"...%n", s);
            for (Path p : List.of(Path.of(s, new String[0]), Path.of(s, new String[0]).toAbsolutePath(), Path.of(String.valueOf(current) + s, new String[0]))) {
                try {
                    System.out.printf("\"%s\" relative form:%n    \"%s\"%n", p, FileOperation.relativizePathInsideCurrentOrParent((Path)p));
                }
                catch (Exception e) {
                    System.out.printf("\"%s\" path cannot be relativized: %s%n", p, e.getMessage());
                }
            }
        }
    }
}

