/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.tests;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.algart.executors.api.chains.Chain;
import net.algart.executors.api.chains.ChainSpecification;
import net.algart.executors.api.system.ExecutorFactory;

public class ReadWriteChainTest {
    public static void main(String[] args) throws IOException {
        System.setProperty("net.algart.executors.root", "build");
        if (args.length < 2) {
            System.out.printf("Usage: %s chain.chain result_1.chain [result_2.chain]%n", ReadWriteChainTest.class.getName());
            return;
        }
        Path chainFile = Paths.get(args[0], new String[0]);
        Path resultFile1 = Paths.get(args[1], new String[0]);
        Path resultFile2 = args.length >= 3 ? Paths.get(args[2], new String[0]) : null;
        System.out.printf("Reading %s...%n", chainFile);
        ChainSpecification specification = ChainSpecification.read((Path)chainFile);
        System.out.printf("Writing %s...%n", resultFile1);
        specification.rewriteChainSection(resultFile1, new OpenOption[0]);
        System.out.printf("Specification:%n", new Object[0]);
        System.out.println(specification);
        if (resultFile2 != null) {
            specification = ChainSpecification.read((Path)resultFile1);
            specification.rewriteChainSection(resultFile2, new OpenOption[0]);
        }
        long t1 = System.nanoTime();
        Chain chain = Chain.of(null, (ExecutorFactory)ExecutorFactory.newSharedFactory(), (ChainSpecification)specification);
        long t2 = System.nanoTime();
        System.out.printf("%nFull chain created in %.3f ms:%n", (double)(t2 - t1) * 1.0E-6);
        System.out.println(chain.toString(true));
        t1 = System.nanoTime();
        chain = chain.cleanCopy();
        t2 = System.nanoTime();
        System.out.printf("%nClean copy created in %.3f ms:%n", (double)(t2 - t1) * 1.0E-6);
        System.out.println(chain.toString(true));
    }
}

