/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.tests;

import jakarta.json.JsonException;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.chains.Chain;
import net.algart.executors.api.chains.ChainSpecification;
import net.algart.executors.api.system.ExecutorFactory;
import net.algart.executors.api.system.ExecutorSpecificationSet;

public class LoadingChainTest {
    boolean detailed = false;
    boolean initialize = true;
    boolean stopOnError = false;

    private void processChain(Path chainFile, ExecutorFactory executorFactory) throws IOException {
        block13: {
            try {
                System.out.printf("Reading %s... ", chainFile);
                ChainSpecification chainSpecification = ChainSpecification.readIfValid((Path)chainFile);
                if (chainSpecification == null) {
                    System.out.printf("%n%s is not a chain%n", chainFile);
                    return;
                }
                if (this.detailed) {
                    System.out.printf("%nFull chain json:%n", new Object[0]);
                    System.out.println(chainSpecification);
                }
                try (Chain chain = Chain.of(null, (ExecutorFactory)executorFactory, (ChainSpecification)chainSpecification);){
                    if (this.detailed) {
                        System.out.printf("%nFull chain:%n", new Object[0]);
                        System.out.println(chain.toString(true));
                        System.out.println();
                    }
                    if (this.initialize) {
                        chain.reinitializeAll();
                    }
                }
                System.out.println("O'k");
            }
            catch (JsonException e) {
                System.out.printf("%nERROR: %s%n", e.getMessage());
                if (!this.stopOnError) break block13;
                throw e;
            }
        }
    }

    private void processChainsFolder(Path folder, ExecutorFactory executorFactory) throws IOException {
        try (DirectoryStream<Path> files = Files.newDirectoryStream(folder);){
            for (Path file : files) {
                if (Files.isDirectory(file, new LinkOption[0])) {
                    this.processChainsFolder(file, executorFactory);
                    continue;
                }
                if (!ChainSpecification.isChainSpecificationFile((Path)file)) continue;
                this.processChain(file, executorFactory);
            }
        }
    }

    public static void main(String[] args) throws IOException {
        LoadingChainTest test = new LoadingChainTest();
        int startArgIndex = 0;
        if (args.length > startArgIndex && args[startArgIndex].equals("-detailed")) {
            test.detailed = true;
            ++startArgIndex;
        }
        if (args.length > startArgIndex && args[startArgIndex].equals("-onlyLoad")) {
            test.initialize = false;
            ++startArgIndex;
        }
        if (args.length > startArgIndex && args[startArgIndex].equals("-stopOnError")) {
            test.stopOnError = true;
            ++startArgIndex;
        }
        if (args.length < startArgIndex + 2) {
            System.out.printf("Usage: %s [-detailed] [-onlyLoad] [-stopOnError] executors_folder chain.json/folder%n", LoadingChainTest.class.getName());
            return;
        }
        Path specificationFolder = Paths.get(args[startArgIndex], new String[0]);
        Path chainFile = Paths.get(args[startArgIndex + 1], new String[0]);
        System.out.printf("Reading %s...%n", specificationFolder);
        ExecutorSpecificationSet executorSpecificationSet = ExecutorSpecificationSet.newInstance();
        executorSpecificationSet.addFolder(specificationFolder, true);
        ExecutorFactory executorFactory = ExecutionBlock.globalLoaders().newFactory("~~DUMMY", executorSpecificationSet);
        if (Files.isDirectory(chainFile, new LinkOption[0])) {
            test.processChainsFolder(chainFile, executorFactory);
        } else {
            test.processChain(chainFile, executorFactory);
        }
    }
}

