/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.tests;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Locale;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.system.ExecutorSpecification;
import net.algart.executors.api.system.ExecutorSpecificationSet;

public class ExecutorSpecificationSetTest {
    public static void main(String[] args) throws IOException, ClassNotFoundException {
        int test;
        int startArgIndex = 0;
        boolean resolve = false;
        boolean create = false;
        boolean writeDebugFiles = false;
        if (args.length > startArgIndex && args[startArgIndex].equals("--resolve")) {
            resolve = true;
            ++startArgIndex;
        }
        if (args.length > startArgIndex && args[startArgIndex].equals("--create")) {
            create = true;
            ++startArgIndex;
        }
        if (args.length > startArgIndex && args[startArgIndex].equals("--write_debug_files")) {
            writeDebugFiles = true;
            ++startArgIndex;
        }
        if (args.length < startArgIndex + 1) {
            System.out.printf("Usage: %s executors_folder%n", ExecutorSpecificationSet.class.getName());
            return;
        }
        Path executorsFolder = Paths.get(args[startArgIndex], new String[0]);
        Runtime rt = Runtime.getRuntime();
        System.out.printf("Used memory %.2f/%.2f GB%n", (double)(rt.totalMemory() - rt.freeMemory()) * 1.0E-9, (double)rt.maxMemory() * 1.0E-9);
        ExecutorSpecificationSet executorSpecificationSet = null;
        for (test = 1; test <= 5; ++test) {
            System.gc();
            System.out.printf("Test #%d...%n", test);
            System.out.printf("  Reading %s...%n", executorsFolder);
            long t1 = System.nanoTime();
            executorSpecificationSet = ExecutorSpecificationSet.newInstance();
            executorSpecificationSet.addFolder(executorsFolder, false);
            long t2 = System.nanoTime();
            Collection specifications = executorSpecificationSet.all();
            System.out.printf(Locale.US, "  %d specifications loaded in %.3f ms (%.5f mcs/executor); used memory %.2f/%.2f MB%n", specifications.size(), (double)(t2 - t1) * 1.0E-6, (double)(t2 - t1) * 0.001 / (double)specifications.size(), (double)(rt.totalMemory() - rt.freeMemory()) * 1.0E-6, (double)rt.maxMemory() * 1.0E-6);
            if (resolve) {
                t1 = System.nanoTime();
                for (ExecutorSpecification specification : specifications) {
                    if (!specification.isJavaExecutor()) continue;
                    specification.getJava().resolveSupportedExecutor();
                }
                t2 = System.nanoTime();
                System.out.printf(Locale.US, "  Java classes of executors resolved in %.3f ms (%.5f mcs/executor); used memory %.2f/%.2f MB%n", (double)(t2 - t1) * 1.0E-6, (double)(t2 - t1) * 0.001 / (double)specifications.size(), (double)(rt.totalMemory() - rt.freeMemory()) * 1.0E-6, (double)rt.maxMemory() * 1.0E-6);
            }
            System.out.println();
        }
        if (create) {
            for (test = 1; test <= 10; ++test) {
                System.out.printf("Creation test #%d...%n", test);
                Collection specifications = executorSpecificationSet.all();
                long t1 = System.nanoTime();
                for (ExecutorSpecification specification : specifications) {
                    if (!specification.isJavaExecutor()) continue;
                    String javaConfiguration = specification.minimalSpecification();
                    ExecutionBlock.newExecutor(null, (String)javaConfiguration);
                }
                long t2 = System.nanoTime();
                System.out.printf(Locale.US, "  Executors created in %.3f ms (%.5f mcs/model); used memory %.2f/%.2f MB%n", (double)(t2 - t1) * 1.0E-6, (double)(t2 - t1) * 0.001 / (double)specifications.size(), (double)(rt.totalMemory() - rt.freeMemory()) * 1.0E-6, (double)rt.maxMemory() * 1.0E-6);
                System.out.println();
            }
            for (ExecutorSpecification specification : executorSpecificationSet.all()) {
                if (!specification.isJavaExecutor()) continue;
                System.out.printf("Creating executor %s.%s...%n", specification.getCategory(), specification.getName());
                ExecutionBlock executionBlock = ExecutionBlock.newExecutor(null, (String)specification.minimalSpecification());
                System.out.printf("  %s [id=%s]%n", executionBlock, executionBlock.getExecutorId());
            }
        }
        if (writeDebugFiles) {
            System.out.printf("  Writing xxx__specification.json.files...%n", new Object[0]);
            for (ExecutorSpecification specification : executorSpecificationSet.all()) {
                String jsonString = specification.jsonString();
                Path resultFile = Paths.get(String.valueOf(specification.getSpecificationFile()) + "__specification.json", new String[0]);
                Files.writeString(resultFile, (CharSequence)jsonString, new OpenOption[0]);
            }
        }
        System.out.println("Done");
    }
}

