/*
 * Decompiled with CFR 0.152.
 */
package com.siams.stare.utils;

import com.siams.stare.utils.Rect;
import com.siams.stare.utils.SMatUnaryProcess;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.algart.executors.api.data.SMat;

public abstract class SMatIterator {
    protected final SMat sMat;
    protected final Rect viewRect;
    protected SMatUnaryProcess unaryProcess;
    protected ByteBuffer bb;
    protected int startByteIndex;
    protected int endByteIndex;
    protected int byteIndex;
    protected int imageWidth;
    protected int imageHeight;
    protected boolean isAbsolutePosition = true;
    protected int sMatOffsetX = 0;
    protected int sMatOffsetY = 0;
    protected int sMatOffsetZ = 0;

    public SMatIterator(SMat sMat, Rect viewRect, SMatUnaryProcess unaryProcess) {
        this.sMat = sMat;
        this.viewRect = viewRect.copy();
        this.unaryProcess = unaryProcess;
        this.bb = sMat.getByteBuffer().order(ByteOrder.LITTLE_ENDIAN);
        this.imageWidth = (int)sMat.getDimX();
        this.imageHeight = (int)sMat.getDimY();
    }

    public void setSMatOffset(int offsetX, int offsetY) {
        this.sMatOffsetX = offsetX;
        this.sMatOffsetY = offsetY;
        this.isAbsolutePosition = offsetX == 0 && offsetY == 0;
    }

    public void setSMatOffset(int offsetX, int offsetY, int offsetZ) {
        this.sMatOffsetX = offsetX;
        this.sMatOffsetY = offsetY;
        this.sMatOffsetZ = offsetZ;
        this.isAbsolutePosition = offsetX == 0 && offsetY == 0;
    }

    abstract void iterate();

    abstract void iterateOverAbsolutePosition();

    abstract void iterateOverRelativePosition();
}

