/*
 * Decompiled with CFR 0.152.
 */
package com.siams.preferences;

import java.util.prefs.Preferences;

public interface UIPreference {
    default public String createPreferenceName(Class clazz, String key) {
        return String.format("%d.%s", clazz.getName().hashCode(), key);
    }

    default public <T> void putPreference(String key, T value) {
        Class<?> clazz = this.getClass();
        Preferences preferences = Preferences.userNodeForPackage(clazz);
        if (value instanceof byte[]) {
            preferences.putByteArray(key, (byte[])value);
        } else {
            preferences.put(key, String.valueOf(value));
        }
    }

    default public <T> T getPreference(String key, T defaultValue) {
        Class<?> clazz = this.getClass();
        Preferences preferences = Preferences.userNodeForPackage(clazz);
        if (defaultValue instanceof byte[]) {
            return (T)preferences.getByteArray(key, (byte[])defaultValue);
        }
        if (defaultValue instanceof Boolean) {
            return (T)Boolean.valueOf(preferences.getBoolean(key, (Boolean)defaultValue));
        }
        if (defaultValue instanceof Integer) {
            return (T)Integer.valueOf(preferences.getInt(key, (Integer)defaultValue));
        }
        if (defaultValue instanceof Long) {
            return (T)Long.valueOf(preferences.getLong(key, (Long)defaultValue));
        }
        if (defaultValue instanceof Float) {
            return (T)Float.valueOf(preferences.getFloat(key, ((Float)defaultValue).floatValue()));
        }
        if (defaultValue instanceof Double) {
            return (T)Double.valueOf(preferences.getDouble(key, (Double)defaultValue));
        }
        return (T)preferences.get(key, (String)defaultValue);
    }

    default public void putPreferredBoolean(String key, boolean value) {
        try {
            Class<?> clazz = this.getClass();
            Preferences preferences = Preferences.userNodeForPackage(clazz);
            preferences.putBoolean(this.createPreferenceName(clazz, key), value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    default public boolean getPreferredBoolean(String key, boolean defaultValue) {
        Class<?> clazz = this.getClass();
        Preferences preferences = Preferences.userNodeForPackage(clazz);
        return preferences.getBoolean(this.createPreferenceName(clazz, key), defaultValue);
    }

    default public void putPreferredString(String key, String value) {
        Class<?> clazz = this.getClass();
        Preferences preferences = Preferences.userNodeForPackage(clazz);
        preferences.put(this.createPreferenceName(clazz, key), value);
    }

    default public String getPreferredString(String key, String defaultValue) {
        Class<?> clazz = this.getClass();
        Preferences preferences = Preferences.userNodeForPackage(clazz);
        return preferences.get(this.createPreferenceName(clazz, key), defaultValue);
    }

    default public void putPreferredInt(String key, int value) {
        Class<?> clazz = this.getClass();
        Preferences preferences = Preferences.userNodeForPackage(clazz);
        preferences.putInt(this.createPreferenceName(clazz, key), value);
    }

    default public int getPreferredInt(String key, int defaultValue) {
        Class<?> clazz = this.getClass();
        Preferences preferences = Preferences.userNodeForPackage(clazz);
        try {
            return preferences.getInt(this.createPreferenceName(clazz, key), defaultValue);
        }
        catch (NumberFormatException ignore) {
            return defaultValue;
        }
    }

    default public void putPreferredLong(String key, long value) {
        Class<?> clazz = this.getClass();
        Preferences preferences = Preferences.userNodeForPackage(clazz);
        preferences.putLong(this.createPreferenceName(clazz, key), value);
    }

    default public long getPreferredLong(String key, long defaultValue) {
        Class<?> clazz = this.getClass();
        Preferences preferences = Preferences.userNodeForPackage(clazz);
        try {
            return preferences.getLong(this.createPreferenceName(clazz, key), defaultValue);
        }
        catch (NumberFormatException ignore) {
            return defaultValue;
        }
    }

    default public void putPreferredDouble(String key, double value) {
        Class<?> clazz = this.getClass();
        Preferences preferences = Preferences.userNodeForPackage(clazz);
        preferences.putDouble(this.createPreferenceName(clazz, key), value);
    }

    default public double getPreferredDouble(String key, double defaultValue) {
        Class<?> clazz = this.getClass();
        Preferences preferences = Preferences.userNodeForPackage(clazz);
        try {
            return preferences.getDouble(this.createPreferenceName(clazz, key), defaultValue);
        }
        catch (NumberFormatException ignore) {
            return defaultValue;
        }
    }

    default public void restorePreference() {
    }

    default public void savePreference() {
    }
}

