/*
 * Decompiled with CFR 0.152.
 */
package com.siams.notifications;

import com.siams.javafx.utils.FxPlatform;
import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Pos;
import javafx.util.Duration;
import org.controlsfx.control.Notifications;

public class StareNotification {
    private static final int LINE_LENGTH_LIMIT = 150;
    private static final int MAX_LINE_COUNT = 20;

    private static String cropMessage(String message) {
        ArrayList<String> lines = new ArrayList<String>();
        for (String line : message.split("\n", 20)) {
            StareNotification.wrapLongString(lines, line, 150);
        }
        if (lines.size() > 20) {
            lines = new ArrayList(lines.subList(0, 20));
            lines.add("...");
        }
        return String.join((CharSequence)"\n", lines);
    }

    private static void wrapLongString(List<String> result, String line, int limit) {
        line = line.trim();
        while (line.length() > limit) {
            int p = line.lastIndexOf(32, limit - 1);
            assert (p != 0) : "cannot find a space at position 0 after trim()";
            if (p == -1) {
                p = limit;
            }
            result.add(line.substring(0, p));
            line = line.substring(p).trim();
        }
        result.add(line);
    }

    private static Notifications show(String title, String message) {
        return Notifications.create().title(title).text(StareNotification.cropMessage(message)).position(Pos.CENTER).onAction(event -> {}).hideAfter(Duration.millis((double)1000.0));
    }

    public static void showInfo(String title, String message, Duration duration) {
        FxPlatform.RunFxThread(() -> StareNotification.show(title, message).hideAfter(duration).showInformation());
    }

    public static void showInfo(String message) {
        StareNotification.showInfo("Information", message, Duration.millis((double)1000.0));
    }

    public static void showWarn(String message) {
        StareNotification.showWarn("Warning", message);
    }

    public static void showWarn(String title, Throwable throwable) {
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        StareNotification.showWarn(title, throwable.getMessage());
    }

    public static void showWarn(String title, String message) {
        FxPlatform.RunFxThread(() -> StareNotification.show(title, message).hideAfter(Duration.INDEFINITE).showWarning());
    }
}

