/*
 * Decompiled with CFR 0.152.
 */
package com.siams.javafx.utils.property;

import com.siams.javafx.utils.property.converter.Converter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import javafx.beans.property.ObjectPropertyBase;

public class PathProperty<Mt, Pt>
extends ObjectPropertyBase<Pt> {
    private final String fieldPath;
    private final Object bean;
    private final PropertyMethodHandles propMethodHandles;
    private Class<Pt> propertyType;
    private Converter<Mt, Pt> converter;

    public String getFieldPath() {
        return this.fieldPath;
    }

    public PathProperty(Object bean, String fieldPath, Converter<Mt, Pt> converter) {
        this.bean = bean;
        this.fieldPath = fieldPath;
        this.propertyType = null;
        this.converter = converter;
        try {
            this.propMethodHandles = PropertyMethodHandles.build(this.getBean(), this.getName());
        }
        catch (Throwable t) {
            throw new RuntimeException(String.format("Unable to instantiate expression %1$s on %2$s", this.getBean(), this.getName()), t);
        }
    }

    public PathProperty(Object bean, String fieldPath, Class<Pt> type) {
        this.bean = bean;
        this.fieldPath = fieldPath;
        this.propertyType = type;
        this.converter = null;
        try {
            this.propMethodHandles = PropertyMethodHandles.build(this.getBean(), this.getName());
        }
        catch (Throwable t) {
            throw new RuntimeException(String.format("Unable to instantiate expression %1$s on %2$s", this.getBean(), this.getName()), t);
        }
    }

    public void setValue(Pt v) {
        super.setValue(v);
    }

    public Object getBean() {
        return this.bean;
    }

    public String getName() {
        return this.fieldPath;
    }

    public void set(Pt v) {
        try {
            Object converted = null;
            if (this.converter != null) {
                converted = this.converter.toModel(v);
            } else if (this.propertyType != null && v != null) {
                converted = this.convertTo(v, this.propertyType);
            }
            this.propMethodHandles.getSetter().invoke(converted);
            super.set(v);
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to set value: " + String.valueOf(v), t);
        }
    }

    protected Object convertTo(Object value, Class type) {
        Class<?> actualType = value.getClass();
        if (!actualType.equals(type)) {
            if (type.isAssignableFrom(actualType)) {
                return type.cast(value);
            }
            if (type.equals(String.class)) {
                if (Double.TYPE.equals(actualType) || Double.class.equals(actualType) || Integer.TYPE.equals(actualType) || Integer.class.equals(actualType) || Long.TYPE.equals(actualType) || Long.class.equals(actualType) || Short.TYPE.equals(actualType) || Short.class.equals(actualType) || Byte.TYPE.equals(actualType) || Byte.class.equals(actualType)) {
                    return String.valueOf(value);
                }
            } else if (type.equals(Double.class) || type.equals(Double.TYPE)) {
                if (Double.TYPE.equals(actualType) || Double.class.equals(actualType) || Integer.TYPE.equals(actualType) || Integer.class.equals(actualType) || Long.TYPE.equals(actualType) || Long.class.equals(actualType) || Short.TYPE.equals(actualType) || Short.class.equals(actualType) || Byte.TYPE.equals(actualType) || Byte.class.equals(actualType)) {
                    return ((Number)value).doubleValue();
                }
                if (String.class.isAssignableFrom(actualType)) {
                    return Double.parseDouble(value.toString());
                }
            }
        } else {
            return value;
        }
        throw new ClassCastException(String.format("Can't cast path property, field: '%s'", this.fieldPath));
    }

    public Pt get() {
        try {
            Object actualValue = this.propMethodHandles.getAccessor().invoke();
            Object converted = null;
            if (this.converter != null) {
                converted = this.converter.toTarget(actualValue);
            } else if (this.propertyType != null && actualValue != null) {
                converted = this.convertTo(actualValue, this.propertyType);
            }
            Object val = super.get();
            if (val == null || !val.equals(converted)) {
                super.set(converted);
            }
            return (Pt)converted;
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to get value", t);
        }
    }

    public static class PropertyMethodHandles {
        private final String fieldName;
        private final MethodHandle accessor;
        private final MethodHandle setter;
        private Object setterArgument;

        protected PropertyMethodHandles(Object target, String fieldName, boolean insertSetterArgument) throws NoSuchMethodException {
            this.fieldName = fieldName;
            this.accessor = this.buildGetter(target, fieldName);
            this.setter = this.buildSetter(this.getAccessor(), target, fieldName, insertSetterArgument);
        }

        public static PropertyMethodHandles build(Object initialTarget, String expString) throws NoSuchMethodException, IllegalStateException {
            String[] expStr = expString.split("\\.");
            Object target = initialTarget;
            PropertyMethodHandles pmh = null;
            for (int i = 0; i < expStr.length; ++i) {
                pmh = new PropertyMethodHandles(target, expStr[i], i < expStr.length - 1);
                target = pmh.getSetterArgument();
            }
            return pmh;
        }

        protected MethodHandle buildGetter(Object target, String fieldName) throws NoSuchMethodException {
            MethodHandle mh = PropertyMethodHandles.buildAccessor(target, fieldName, "get", "is", "has");
            if (mh == null) {
                throw new NoSuchMethodException(fieldName);
            }
            return mh;
        }

        protected MethodHandle buildSetter(MethodHandle accessor, Object target, String fieldName, boolean insertSetterArgument) {
            if (insertSetterArgument) {
                try {
                    this.setterArgument = accessor.invoke();
                }
                catch (Throwable t) {
                    this.setterArgument = null;
                }
                if (this.getSetterArgument() == null) {
                    try {
                        this.setterArgument = ((Class)accessor.type().returnType()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(String.format("Unable to build setter expression for %1$s using %2$s.", fieldName, accessor.type().returnType()));
                    }
                }
            }
            try {
                MethodHandle mh1 = MethodHandles.lookup().findVirtual(target.getClass(), PropertyMethodHandles.buildMethodName("set", fieldName), MethodType.methodType(Void.TYPE, accessor.type().returnType())).bindTo(target);
                if (this.getSetterArgument() != null) {
                    mh1.invoke(this.getSetterArgument());
                }
                return mh1;
            }
            catch (Throwable t) {
                throw new IllegalArgumentException("Unable to resolve setter " + fieldName, t);
            }
        }

        protected static MethodHandle buildAccessor(Object target, String fieldName, String ... fieldNamePrefix) {
            String accessorName = PropertyMethodHandles.buildMethodName(fieldNamePrefix[0], fieldName);
            try {
                return MethodHandles.lookup().findVirtual(target.getClass(), accessorName, MethodType.methodType(target.getClass().getMethod(accessorName, new Class[0]).getReturnType())).bindTo(target);
            }
            catch (NoSuchMethodException e) {
                return PropertyMethodHandles.buildAccessor(target, fieldName, Arrays.copyOfRange(fieldNamePrefix, 1, fieldNamePrefix.length));
            }
            catch (Throwable t) {
                throw new IllegalArgumentException("Unable to resolve accessor " + accessorName, t);
            }
        }

        protected static String buildMethodName(String prefix, String fieldName) {
            return fieldName.startsWith(prefix) ? fieldName : prefix + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public MethodHandle getAccessor() {
            return this.accessor;
        }

        public MethodHandle getSetter() {
            return this.setter;
        }

        public Object getSetterArgument() {
            return this.setterArgument;
        }
    }
}

