/*
 * Decompiled with CFR 0.152.
 */
package com.siams.javafx.utils;

import java.util.StringJoiner;
import javafx.scene.paint.Color;

public class FxColor {
    public static java.awt.Color toAwtColor(String color) {
        if (color.startsWith("(") || color.startsWith("[")) {
            color = FxColor.parseAlgArtColor(color);
        }
        int r = 0;
        int g = 0;
        int b = 0;
        if (color.startsWith("#")) {
            r = Integer.parseInt(color.substring(1, 3), 16);
            g = Integer.parseInt(color.substring(3, 5), 16);
            b = Integer.parseInt(color.substring(5, 7), 16);
        } else if (color.startsWith("0x")) {
            r = Integer.parseInt(color.substring(2, 4), 16);
            g = Integer.parseInt(color.substring(4, 6), 16);
            b = Integer.parseInt(color.substring(6, 8), 16);
        }
        return new java.awt.Color(r, g, b);
    }

    public static Color toFxColor(String color) {
        if (color.startsWith("(") || color.startsWith("[")) {
            return Color.valueOf((String)FxColor.parseAlgArtColor(color));
        }
        return Color.valueOf((String)color);
    }

    public static java.awt.Color toAwtColor(Color fxColor) {
        return new java.awt.Color((int)(255.0 * fxColor.getRed()), (int)(255.0 * fxColor.getGreen()), (int)(255.0 * fxColor.getBlue()));
    }

    public static Color toFxColor(java.awt.Color awtColor) {
        return new Color((double)awtColor.getRed() / 255.0, (double)awtColor.getGreen() / 255.0, (double)awtColor.getBlue() / 255.0, (double)awtColor.getTransparency() / 255.0);
    }

    private static String toHexString(Color fxColor, boolean appendAlpha) {
        if (appendAlpha) {
            return String.format("%02X%02X%02X%02X", (int)Math.round(fxColor.getRed() * 255.0), (int)Math.round(fxColor.getGreen() * 255.0), (int)Math.round(fxColor.getBlue() * 255.0), (int)Math.round(fxColor.getOpacity() * 255.0));
        }
        return String.format("%02X%02X%02X", (int)Math.round(fxColor.getRed() * 255.0), (int)Math.round(fxColor.getGreen() * 255.0), (int)Math.round(fxColor.getBlue() * 255.0));
    }

    public static String toHexString(java.awt.Color awtColor, boolean appendAlpha) {
        if (appendAlpha) {
            return String.format("%02X%02X%02X%02X", awtColor.getRed(), awtColor.getGreen(), awtColor.getBlue(), awtColor.getAlpha());
        }
        return String.format("%02X%02X%02X", awtColor.getRed(), awtColor.getGreen(), awtColor.getBlue());
    }

    public static String toHtml(Color fxColor, boolean appendAlpha) {
        return String.format("#%s", FxColor.toHexString(fxColor, appendAlpha));
    }

    public static String toHtml(java.awt.Color awtColor, boolean appendAlpha) {
        return String.format("#%s", FxColor.toHexString(awtColor, appendAlpha));
    }

    public static String toHex(Color fxColor, boolean appendAlpha) {
        return String.format("0x%s", FxColor.toHexString(fxColor, appendAlpha));
    }

    public static String toHex(java.awt.Color awtColor, boolean appendAlpha) {
        return String.format("0x%s", FxColor.toHexString(awtColor, appendAlpha));
    }

    private static String parseAlgArtColor(String channelsVector) {
        if (!(channelsVector.startsWith("[") && channelsVector.endsWith("]") || channelsVector.startsWith("(") && channelsVector.endsWith(")"))) {
            throw new IllegalArgumentException("Unsupported AlgArtColor format");
        }
        String[] channels = channelsVector.substring(1, channelsVector.length() - 1).split(",");
        if (channels.length != 3 && channels.length != 4) {
            throw new IllegalArgumentException("Unsupported AlgArtColor format");
        }
        double[] values = new double[channels.length];
        boolean isInteger = false;
        for (int i = 0; i < channels.length; ++i) {
            values[i] = Double.parseDouble(channels[i]);
            if (!(values[i] > 1.0)) continue;
            isInteger = true;
        }
        StringJoiner sj = new StringJoiner("");
        sj.add("0x");
        for (double value : values) {
            int intValue = isInteger ? (int)value : (int)Math.round(value * 255.0);
            sj.add(String.format("%02X", intValue));
        }
        return sj.toString();
    }
}

