/*
 * Decompiled with CFR 0.152.
 */
package com.siams.dialogs;

import java.util.List;
import java.util.Optional;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.VBox;

public class DialogManager {
    public static Optional<ButtonType> showInfo(String text) {
        return DialogManager.showInfo(text, "Information");
    }

    public static Optional<ButtonType> showInfo(String text, String caption) {
        Alert dialog = new Alert(Alert.AlertType.INFORMATION);
        dialog.setHeaderText(null);
        dialog.setGraphic(null);
        dialog.setTitle(caption);
        dialog.setContentText(text);
        return dialog.showAndWait();
    }

    public static Optional<ButtonType> showQuery(String query) {
        return DialogManager.showQuery(query, "Query");
    }

    public static Optional<ButtonType> showQuery(String query, String caption) {
        Alert dialog = new Alert(Alert.AlertType.CONFIRMATION);
        dialog.setHeaderText(null);
        dialog.setGraphic(null);
        dialog.setTitle(caption);
        dialog.setContentText(query);
        dialog.getDialogPane().getButtonTypes().clear();
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.YES, ButtonType.NO});
        dialog.setResultConverter(pressed -> {
            ButtonBar.ButtonData data = pressed == null ? null : pressed.getButtonData();
            return data == ButtonBar.ButtonData.OK_DONE || data == ButtonBar.ButtonData.YES ? ButtonType.OK : null;
        });
        return dialog.showAndWait();
    }

    public static Optional<ButtonType> showYesNoQuery(String query, String caption) {
        Alert dialog = new Alert(Alert.AlertType.CONFIRMATION);
        dialog.setDialogPane((DialogPane)new NoButtonOrderDialog());
        dialog.setHeaderText(null);
        dialog.setGraphic(null);
        dialog.setTitle(caption);
        dialog.setContentText(query);
        dialog.getDialogPane().getButtonTypes().clear();
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.YES, ButtonType.NO});
        return dialog.showAndWait();
    }

    public static Optional<ButtonType> showQuery(String query, String caption, ButtonType ... buttonType) {
        Alert dialog = new Alert(Alert.AlertType.CONFIRMATION);
        dialog.setDialogPane((DialogPane)new NoButtonOrderDialog());
        dialog.setHeaderText(null);
        dialog.setGraphic(null);
        dialog.setTitle(caption);
        dialog.setContentText(query);
        dialog.getDialogPane().getButtonTypes().clear();
        dialog.getDialogPane().getButtonTypes().addAll((Object[])buttonType);
        return dialog.showAndWait();
    }

    public static Optional<String> showTextInput(String text, String defaultValue) {
        return DialogManager.showTextInput(text, defaultValue, "Enter the value");
    }

    public static Optional<String> showTextInput(String text, String defaultValue, String caption) {
        Dialog dialog = new Dialog();
        DialogPane dialogPane = new DialogPane();
        dialogPane.setMinWidth(300.0);
        Label label = new Label(text);
        TextField textField = new TextField(defaultValue);
        VBox container = new VBox(new Node[]{label, textField});
        container.setSpacing(5.0);
        dialogPane.setContent((Node)container);
        dialogPane.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        dialog.setTitle(caption);
        dialog.setDialogPane(dialogPane);
        dialog.setResultConverter(pressed -> {
            ButtonBar.ButtonData data = pressed == null ? null : pressed.getButtonData();
            return data == ButtonBar.ButtonData.OK_DONE ? textField.getText() : null;
        });
        Platform.runLater(() -> ((TextField)textField).requestFocus());
        return dialog.showAndWait();
    }

    public static Optional<String> showWideText(String text, String defaultValue) {
        return DialogManager.showWideText(text, defaultValue, "Enter the value");
    }

    public static Optional<String> showWideText(String text, String defaultValue, String caption) {
        Dialog dialog = new Dialog();
        DialogPane dialogPane = new DialogPane();
        Label label = new Label(text);
        TextArea textArea = new TextArea(defaultValue);
        textArea.setWrapText(true);
        VBox container = new VBox(new Node[]{label, textArea});
        container.setSpacing(5.0);
        dialogPane.setContent((Node)container);
        dialogPane.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        dialog.setTitle(caption);
        dialog.setDialogPane(dialogPane);
        dialog.setResultConverter(pressed -> {
            ButtonBar.ButtonData data = pressed == null ? null : pressed.getButtonData();
            return data == ButtonBar.ButtonData.OK_DONE ? textArea.getText() : null;
        });
        Platform.runLater(() -> ((TextArea)textArea).requestFocus());
        return dialog.showAndWait();
    }

    public static <T> Optional<T> showSelector(String text, List<T> values) {
        return DialogManager.showSelector(text, "Choose one preferred item", values);
    }

    public static <T> Optional<T> showSelector(String text, String caption, List<T> values) {
        Dialog dialog = new Dialog();
        DialogPane dialogPane = new DialogPane();
        Label label = new Label(text);
        ObservableList observableValues = FXCollections.observableArrayList(values);
        ListView table = new ListView(observableValues);
        table.getSelectionModel().selectFirst();
        int fixedRowSize = 25;
        table.setFixedCellSize((double)fixedRowSize);
        table.setPrefHeight((double)Math.min(values.size() * fixedRowSize + 30, 150));
        table.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                dialog.setResult(table.getSelectionModel().getSelectedItem());
            }
        });
        table.setOnKeyReleased(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                dialog.setResult(table.getSelectionModel().getSelectedItem());
            }
        });
        VBox container = new VBox(new Node[]{label, table});
        container.setSpacing(5.0);
        dialogPane.setContent((Node)container);
        dialogPane.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        dialog.setTitle(caption);
        dialog.setDialogPane(dialogPane);
        dialog.setResultConverter(pressed -> {
            ButtonBar.ButtonData data = pressed == null ? null : pressed.getButtonData();
            return data == ButtonBar.ButtonData.OK_DONE ? table.getSelectionModel().getSelectedItem() : null;
        });
        Platform.runLater(() -> ((ListView)table).requestFocus());
        return dialog.showAndWait();
    }

    public static <T> Optional<List<T>> showMultiplySelector(String text, List<T> values) {
        return DialogManager.showMultiplySelector(text, "Choose preferred items", values);
    }

    public static <T> Optional<List<T>> showMultiplySelector(String text, String caption, List<T> values) {
        Dialog dialog = new Dialog();
        DialogPane dialogPane = new DialogPane();
        Label label = new Label(text);
        ObservableList observableValues = FXCollections.observableArrayList(values);
        ListView table = new ListView(observableValues);
        table.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        table.getSelectionModel().selectFirst();
        int fixedRowSize = 25;
        table.setFixedCellSize((double)fixedRowSize);
        table.setPrefHeight((double)Math.min(values.size() * fixedRowSize + 30, 150));
        table.setOnKeyReleased(event -> {
            if (event.isControlDown() && event.getCode() == KeyCode.ENTER) {
                dialog.setResult((Object)table.getSelectionModel().getSelectedItems());
            }
        });
        VBox container = new VBox(new Node[]{label, table});
        container.setSpacing(5.0);
        dialogPane.setContent((Node)container);
        dialogPane.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        dialog.setTitle(caption);
        dialog.setDialogPane(dialogPane);
        dialog.setResultConverter(pressed -> {
            ButtonBar.ButtonData data = pressed == null ? null : pressed.getButtonData();
            return data == ButtonBar.ButtonData.OK_DONE ? table.getSelectionModel().getSelectedItems() : null;
        });
        Platform.runLater(() -> ((ListView)table).requestFocus());
        return dialog.showAndWait();
    }

    private static class NoButtonOrderDialog
    extends DialogPane {
        private NoButtonOrderDialog() {
        }

        protected Node createButtonBar() {
            ButtonBar node = (ButtonBar)super.createButtonBar();
            node.setButtonOrder("");
            return node;
        }
    }
}

