/*
 * Decompiled with CFR 0.152.
 */
package com.siams.controls.autobox;

import com.siams.controls.autobox.AutoBoxConverter;
import com.siams.controls.autobox.AutoBoxFilterPredicateBuilder;
import com.siams.controls.autobox.AutoBoxItemNodeBuilder;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import io.reactivex.subjects.PublishSubject;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;

public class AutoBox<T>
extends TextField {
    protected ContextMenu entriesPopup;
    protected ObservableList<T> items;
    protected FilteredList<T> filtered;
    protected int maxVisibleResults = 10;
    protected AutoBoxItemNodeBuilder<T> nodeBuilder;
    protected List<Consumer<T>> itemSelectListeners;
    protected AutoBoxFilterPredicateBuilder<T> filterPredicateBuilder;
    protected AutoBoxConverter<T> modelConverter;
    protected final PublishSubject<String> querySubject = PublishSubject.create();
    protected Disposable queryDisposable;
    protected QueryChangeListener queryChangeListener;
    private io.reactivex.functions.Consumer<String> queryConsumer = query -> {
        if (this.nodeBuilder == null) {
            return;
        }
        Platform.runLater(() -> this.displayResult(this.filter((String)query)));
    };

    public AutoBox() {
        this.itemSelectListeners = new ArrayList<Consumer<T>>();
        this.items = FXCollections.observableArrayList();
        this.filtered = new FilteredList(this.items);
        this.entriesPopup = new ContextMenu();
        this.queryChangeListener = new QueryChangeListener();
        this.textProperty().addListener((ChangeListener)this.queryChangeListener);
        this.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            switch (event.getCode()) {
                case DOWN: {
                    String query = this.getText();
                    if (query.isEmpty()) break;
                    this.displayResult(this.filter(query));
                }
            }
        });
        this.focusedProperty().addListener((observableValue, oldValue, newValue) -> this.entriesPopup.hide());
        this.setThrottle(250, TimeUnit.MILLISECONDS);
    }

    protected void displayResult(List<T> result) {
        if (this.nodeBuilder == null) {
            return;
        }
        if (result.size() > 0) {
            this.populatePopup(result);
            if (!this.entriesPopup.isShowing()) {
                this.entriesPopup.show((Node)this, Side.BOTTOM, 0.0, 0.0);
            }
        } else {
            this.entriesPopup.hide();
        }
    }

    protected List<T> filter(String query) {
        this.filtered.setPredicate(this.filterPredicateBuilder.build(query));
        return this.filtered;
    }

    protected void populatePopup(List<T> result) {
        LinkedList<CustomMenuItem> menuItems = new LinkedList<CustomMenuItem>();
        int count = Math.min(result.size(), this.maxVisibleResults);
        for (int i = 0; i < count; ++i) {
            T model = result.get(i);
            Node node = this.nodeBuilder.build(model);
            CustomMenuItem menuItem = new CustomMenuItem(node, true);
            menuItem.setOnAction(event -> {
                String text = this.modelConverter.modelToString(model);
                this.textProperty().removeListener((ChangeListener)this.queryChangeListener);
                this.setText(text);
                this.textProperty().addListener((ChangeListener)this.queryChangeListener);
                this.positionCaret(text.length());
                this.entriesPopup.hide();
                this.notifyItemChangeListeners(model);
            });
            menuItems.add(menuItem);
        }
        this.entriesPopup.getItems().clear();
        this.entriesPopup.getItems().addAll(menuItems);
    }

    public int getMaxVisibleResults() {
        return this.maxVisibleResults;
    }

    public void setMaxVisibleResults(int maxVisibleResults) {
        this.maxVisibleResults = maxVisibleResults;
    }

    public void setNodeBuilder(AutoBoxItemNodeBuilder<T> nodeBuilder) {
        this.nodeBuilder = nodeBuilder;
    }

    public void addItemChangeListener(Consumer<T> listener) {
        this.itemSelectListeners.add(listener);
    }

    public void removeItemChangeListener(Consumer<T> listener) {
        this.itemSelectListeners.remove(listener);
    }

    public void notifyItemChangeListeners(T model) {
        for (Consumer<T> listener : this.itemSelectListeners) {
            listener.accept(model);
        }
    }

    public void setFilteredPredicate(AutoBoxFilterPredicateBuilder<T> filteredPredicate) {
        this.filterPredicateBuilder = filteredPredicate;
    }

    public void setModelConverter(AutoBoxConverter<T> modelConverter) {
        this.modelConverter = modelConverter;
    }

    public ObservableList<T> getItems() {
        return this.items;
    }

    public void setThrottle(int throttle, TimeUnit timeUnit) {
        Observable observable = this.querySubject.throttleWithTimeout((long)throttle, timeUnit);
        if (this.queryDisposable != null) {
            this.queryDisposable.dispose();
            this.queryDisposable = null;
        }
        this.queryDisposable = observable.subscribe(this.queryConsumer);
    }

    public void setDebounce(int debounce, TimeUnit timeUnit) {
        Observable observable = this.querySubject.debounce((long)debounce, timeUnit);
        if (this.queryDisposable != null) {
            this.queryDisposable.dispose();
            this.queryDisposable = null;
        }
        this.queryDisposable = observable.subscribe(this.queryConsumer);
    }

    protected class QueryChangeListener
    implements ChangeListener<String> {
        protected QueryChangeListener() {
        }

        public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
            AutoBox.this.entriesPopup.hide();
            if (!newValue.isEmpty()) {
                AutoBox.this.querySubject.onNext((Object)newValue);
            }
        }
    }
}

