/*
 * Decompiled with CFR 0.152.
 */
package com.siams.stare.plugin.vp.control;

import com.siams.cv.monitor.application.App;
import com.siams.cv.monitor.message.NodeIntrospected;
import com.siams.cv.monitor.message.StareMonitorClosing;
import com.siams.cv.monitor.message.StareProjectLoaded;
import com.siams.cv.monitor.model.IIdentifiable;
import com.siams.cv.monitor.model.node.UIBlockModel;
import com.siams.cv.monitor.model.storage.IIDStorage;
import com.siams.cv.monitor.model.worker.EKind;
import com.siams.cv.monitor.model.worker.WorkerType;
import com.siams.cv.monitor.plugin.vp.model.VPPluginModel;
import com.siams.cv.monitor.ui.factory.Deletable;
import com.siams.data.vpjson.project.filter.Filter;
import com.siams.data.vpjson.project.filter.Segmentation;
import com.siams.data.vpjson.project.filter.plugin.StarePlugin;
import com.siams.data.vpjson.project.filter.plugin.stare.Control;
import com.siams.data.vpjson.project.filter.plugin.stare.ControlBuilder;
import com.siams.data.vpjson.project.filter.plugin.stare.Settings;
import com.siams.data.vpjson.project.filter.plugin.stare.StareControl;
import com.siams.data.vpjson.project.filter.segment.Segment;
import com.siams.dialogs.DialogManager;
import com.siams.fxml.loader.CustomFXMLLoader;
import com.siams.javafx.GUIUtils;
import com.siams.javafx.PaneHelper;
import com.siams.notifications.StareNotification;
import com.siams.stare.plugin.vp.control.UIControlBuilder;
import com.siams.stare.plugin.vp.control.UIVPControl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import org.apache.log4j.Logger;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class VPControlIntrospection
extends AnchorPane
implements Deletable {
    private IIdentifiable selected;
    private static final Logger logger = Logger.getLogger(VPControlIntrospection.class);
    @Deprecated
    private static final String SYSTEM_PROPERTY_NAME = "$__system.name";
    private static final App app = App.getInstance();
    @FXML
    CheckBox cbVideoPanoramaInput;
    @FXML
    CheckBox cbVideoPanoramaOutput;
    @FXML
    Button btnUpdateSegments;
    @FXML
    TextArea txtSegments;
    @FXML
    VBox vbIntrospection;
    @FXML
    Button btnCreate;
    @FXML
    Button btnDelete;
    @FXML
    AnchorPane anchorPaneRoot;
    @FXML
    AnchorPane anchorPaneSettings;
    @FXML
    ComboBox<String> cmbControlType;
    private StareControl stareControl = null;
    private Control control = null;
    private List<String> predefinedColors;

    public void initialize(Node root) throws IOException {
        CustomFXMLLoader.loadElement((Object)this);
        EventBus.getDefault().register((Object)this);
        this.initializeAnchorPaneRoot();
        this.initializeControlType();
        this.initializeButtonCreate();
        this.initializeButtonDelete();
        this.initializeCheckBoxesInputOutputVideoPanorama();
        this.initializeButtonUpdateSegments();
        this.initializePredefinedColor();
        TabPane tabPane = (TabPane)GUIUtils.lookup((Parent)((Parent)root), (String)"#tabPaneObjectIntrospection");
        if (tabPane != null) {
            Tab tabVPControlIntrospection = new Tab();
            tabVPControlIntrospection.setText("VideoPanorama");
            tabVPControlIntrospection.setContent((Node)this);
            tabPane.getTabs().add((Object)tabVPControlIntrospection);
        }
    }

    private String ColorToVideoPanoramaColor(Color color) {
        return String.format("%d,%d,%d", (int)(255.0 * color.getRed()), (int)(255.0 * color.getGreen()), (int)(255.0 * color.getBlue()));
    }

    private void initializePredefinedColor() {
        this.predefinedColors = new ArrayList<String>();
        this.predefinedColors.add("230,25,75");
        this.predefinedColors.add("60,180,75");
        this.predefinedColors.add("255,225,25");
        this.predefinedColors.add("0,130,200");
        this.predefinedColors.add("245,130,48");
        this.predefinedColors.add("145,30,180");
        this.predefinedColors.add("70,240,240");
        this.predefinedColors.add("240,50,230");
        this.predefinedColors.add("250,190,190");
        this.predefinedColors.add("0,128,128");
        this.predefinedColors.add("230,190,255");
        this.predefinedColors.add("170,110,40");
        this.predefinedColors.add("255,250,200");
        this.predefinedColors.add("128,0,0");
        this.predefinedColors.add("128,128,0");
        this.predefinedColors.add("0,0,128");
        this.predefinedColors.add("255,215,180");
        this.predefinedColors.add("128,128,128");
        this.predefinedColors.add("255,255,255");
        this.predefinedColors.add("0,0,0");
    }

    private Segment createSegment(int phaseId, int r, int g, int b, boolean predefineColor) {
        Segment segment = new Segment();
        segment.setParentId(String.format("phase%d", phaseId));
        segment.setTitle(String.format("Phase %d", phaseId));
        segment.setEditable(false);
        segment.setVisible(false);
        String selColor = String.format("%d,%d,%d", r, g, b);
        segment.setSelColor(selColor);
        if (predefineColor) {
            String color = this.predefinedColors.get(phaseId % this.predefinedColors.size());
            segment.setColor(color);
        } else {
            String color = String.format("%d,%d,%d", r, g, b);
            segment.setColor(color);
        }
        segment.setMin1(Integer.valueOf(r));
        segment.setMax1(Integer.valueOf(r));
        segment.setMin2(Integer.valueOf(g));
        segment.setMax2(Integer.valueOf(g));
        segment.setMin3(Integer.valueOf(b));
        segment.setMax3(Integer.valueOf(b));
        return segment;
    }

    private void initializeButtonUpdateSegments() {
        this.btnUpdateSegments.setOnAction(event -> app.rqGetObjectPropertyIfExist(this.selected, "value", "").thenAccept(value -> {
            try {
                String segments;
                String dataType;
                String trimmed = value.trim().toLowerCase();
                if (trimmed.startsWith("range")) {
                    dataType = "range";
                    segments = trimmed.substring(dataType.length()).trim();
                } else if (trimmed.startsWith("rgb")) {
                    dataType = "rgb";
                    segments = trimmed.substring(dataType.length()).trim();
                } else {
                    dataType = "rgb";
                    segments = trimmed;
                }
                Segmentation segmentation = new Segmentation();
                segmentation.setVisible(false);
                if (dataType.equals("range")) {
                    Pattern patter = Pattern.compile("(\\d+)\\.\\.(\\d+)");
                    Matcher m = patter.matcher(segments);
                    if (!m.find() || m.groupCount() != 2) throw new IllegalArgumentException("segmentation range format incorrect, example: (1..10)");
                    int start = Integer.parseInt(m.group(1));
                    int end = Integer.parseInt(m.group(2));
                    if (start < 0 || end < 0) {
                        throw new IllegalArgumentException("segmentation range format incorrect, example: (1..10)");
                    }
                    int phaseId = 0;
                    int i = start;
                    while (i <= end) {
                        int r = i >> 16 & 0xFF;
                        int g = i >> 8 & 0xFF;
                        int b = i & 0xFF;
                        segmentation.addSegment(this.createSegment(phaseId, r, g, b, true));
                        ++i;
                        ++phaseId;
                    }
                } else {
                    int i;
                    if (!dataType.equals("rgb")) throw new IllegalArgumentException("Unsupported data type segmentation expected 'range', 'rgb'");
                    String[] values = segments.split("([,;\t\n]\\s*)");
                    boolean isFloatFormat = true;
                    for (i = 0; i < values.length; ++i) {
                        String v = values[i];
                        double dv = Double.parseDouble(v);
                        if (!(dv > 1.0)) continue;
                        isFloatFormat = false;
                        break;
                    }
                    for (i = 0; i < values.length; i += 3) {
                        int b;
                        int g;
                        int r;
                        int phaseId = i / 3;
                        if (isFloatFormat) {
                            r = (int)(Double.parseDouble(values[i]) * 255.0);
                            g = (int)(Double.parseDouble(values[i + 1]) * 255.0);
                            b = (int)(Double.parseDouble(values[i + 2]) * 255.0);
                        } else {
                            r = Integer.parseInt(values[i]);
                            g = Integer.parseInt(values[i + 1]);
                            b = Integer.parseInt(values[i + 2]);
                        }
                        segmentation.addSegment(this.createSegment(phaseId, r, g, b, false));
                    }
                }
                app.getProject().findPlugin("VPPluginModel", VPPluginModel.class).ifPresent(plugin -> {
                    Filter old = plugin.getVpjson().getProject().replaceFilter(Filter.Type.SEGMENTATION, (Filter)segmentation);
                    if (old == null) {
                        plugin.getVpjson().getProject().addFilter((Filter)segmentation);
                    }
                });
                this.updateVideoPanoramaSegments();
                return;
            }
            catch (Throwable t) {
                logger.error((Object)t.getMessage(), t);
            }
        }));
    }

    private void initializeCheckBoxesInputOutputVideoPanorama() {
        EventHandler handler = event -> {
            boolean markAsVideoPanorama = ((CheckBox)event.getSource()).isSelected();
            String systemName = markAsVideoPanorama ? "VideoPanorama" : "";
            app.rqSetObjectProperty(this.selected, SYSTEM_PROPERTY_NAME, systemName);
        };
        this.cbVideoPanoramaInput.setOnAction(event -> {
            IIDStorage iidStorage = IIDStorage.getInstance();
            iidStorage.findFirst(this.selected, UIBlockModel.class).ifPresent(blockModel -> iidStorage.findFirst(blockModel.getWorkerType(), WorkerType.class).ifPresent(model -> {
                if (model.getStructure().getKind() != EKind.INPUT) {
                    StareNotification.showWarn((String)"Only 'Input/read image' support this property");
                } else {
                    handler.handle(event);
                }
            }));
        });
        this.cbVideoPanoramaOutput.setOnAction(event -> {
            IIDStorage iidStorage = IIDStorage.getInstance();
            iidStorage.findFirst(this.selected, UIBlockModel.class).ifPresent(blockModel -> iidStorage.findFirst(blockModel.getWorkerType(), WorkerType.class).ifPresent(model -> {
                if (model.getStructure().getKind() != EKind.OUTPUT) {
                    StareNotification.showWarn((String)"Only 'Output/copy image' support this property");
                } else {
                    handler.handle(event);
                }
            }));
        });
    }

    private void initializeAnchorPaneRoot() {
        this.showVPIntrospectionPanel(false);
        this.showVPControlIntrospection(false);
    }

    private void showVPIntrospectionPanel(boolean show) {
        this.anchorPaneRoot.setVisible(show);
    }

    private void initializeButtonDelete() {
        this.btnDelete.setOnAction(event -> {
            if (this.stareControl == null || this.control == null) {
                return;
            }
            StarePlugin starePlugin = this.getStarePlugin();
            if (starePlugin != null) {
                DialogManager.showQuery((String)"Delete VideoPanorama control?", (String)"Delete").ifPresent(btn -> {
                    this.deleteVideoPanoramaControl(this.stareControl, this.control, starePlugin);
                    this.showVPControlIntrospection(false);
                });
            }
        });
    }

    private void initializeButtonCreate() {
        this.btnCreate.setOnAction(event -> {
            StarePlugin starePlugin;
            if (this.stareControl != null && this.control != null) {
                String msg = "Current VideoPanorama control will be overridden, continue?";
                boolean proceed = DialogManager.showQuery((String)"Current VideoPanorama control will be overridden, continue?", (String)"Override").isPresent();
                if (!proceed) {
                    return;
                }
            }
            if ((starePlugin = this.getStarePlugin()) != null) {
                this.replaceStareControl("edit", starePlugin);
                this.buildAndDisplayUIControl(this.stareControl, this.control);
                this.showVPControlIntrospection(true);
            }
        });
    }

    private void initializeControlType() {
        this.cmbControlType.getItems().clear();
        this.cmbControlType.getItems().addAll((Object[])new String[]{"edit", "combobox", "edit_slider", "range_sel"});
        this.cmbControlType.valueProperty().addListener((observable, oldType, controlType) -> {
            if (this.control == null) {
                return;
            }
            if (this.control.getType().equals(controlType)) {
                return;
            }
            StarePlugin starePlugin = this.getStarePlugin();
            if (starePlugin != null) {
                this.replaceStareControl((String)controlType, starePlugin);
                this.buildAndDisplayUIControl(this.stareControl, this.control);
            }
        });
    }

    @Subscribe
    public void onStareProjectLoaded(StareProjectLoaded project) {
        this.showVPIntrospectionPanel(false);
        this.updateVideoPanoramaSegments();
    }

    @Subscribe
    public void onNodeIntrospected(NodeIntrospected event) {
        this.selected = event.getObject();
        if (this.selected == null) {
            this.showVPIntrospectionPanel(false);
            return;
        }
        this.showVPIntrospectionPanel(true);
        this.showVPControlIntrospection(false);
        this.updateVideoPanoramaInputOutputCheckBoxes();
        StarePlugin starePlugin = this.getStarePlugin();
        this.initializeCurrentStareControls(starePlugin);
        if (starePlugin == null) {
            logger.error((Object)"Stare plugin not found");
            this.showVPControlIntrospection(false);
        } else {
            this.showVPControlIntrospection(this.stareControl != null && this.control != null);
        }
    }

    private StarePlugin getStarePlugin() {
        Optional optStarePlugin;
        StarePlugin starePlugin = null;
        Optional<VPPluginModel> optVPPlugin = app.getProject().findPlugin("VPPluginModel", VPPluginModel.class);
        if (optVPPlugin.isPresent() && (optStarePlugin = optVPPlugin.get().getVpjson().getProject().findStarePlugin()).isPresent()) {
            starePlugin = (StarePlugin)optStarePlugin.get();
        }
        if (starePlugin == null) {
            logger.error((Object)"Stare plugin not found");
        }
        return starePlugin;
    }

    private void updateVideoPanoramaSegments() {
        this.txtSegments.setText("");
        app.getProject().findPlugin("VPPluginModel", VPPluginModel.class).ifPresent(plugin -> plugin.getVpjson().getProject().findSegmentationFilter().ifPresent(segmentation -> {
            CharSequence[] colors = new String[segmentation.getSegments().size()];
            for (int i = 0; i < colors.length; ++i) {
                Segment segment = (Segment)segmentation.getSegments().get(i);
                String color1 = String.format("0x%02X%02X%02X", segment.getMin1(), segment.getMin2(), segment.getMin3());
                String color2 = String.format("0x%02X%02X%02X", segment.getMax1(), segment.getMax2(), segment.getMax3());
                colors[i] = String.format("pid: '%s', min: %s, max: %s", segment.getParentId(), color1, color2);
            }
            this.txtSegments.setText(String.join((CharSequence)"\n", colors));
        }));
    }

    private void initializeCurrentStareControls(StarePlugin starePlugin) {
        this.stareControl = null;
        this.control = null;
        Settings settings = starePlugin.getSettings();
        this.stareControl = settings.findFirstStareControl(this.selected.getUuid()).orElse(null);
        if (this.stareControl != null) {
            this.control = settings.findFirstControl(this.stareControl.getControlName()).orElse(null);
            if (this.control != null) {
                this.buildAndDisplayUIControl(this.stareControl, this.control);
            } else {
                logger.error((Object)"Control not found but stare control exist");
            }
        }
    }

    private void updateVideoPanoramaInputOutputCheckBoxes() {
        this.cbVideoPanoramaInput.setSelected(false);
        this.cbVideoPanoramaOutput.setSelected(false);
        app.rqGetObjectPropertyIfExist(this.selected, SYSTEM_PROPERTY_NAME, "").thenAccept(name -> {
            if (name.equals("VideoPanorama")) {
                IIDStorage iidStorage = IIDStorage.getInstance();
                iidStorage.findFirst(this.selected, UIBlockModel.class).ifPresent(blockModel -> {
                    WorkerType model = iidStorage.findFirst(blockModel.getWorkerType(), WorkerType.class).get();
                    EKind kind = model.getStructure().getKind();
                    if (kind == null) {
                        return;
                    }
                    switch (kind) {
                        case INPUT: {
                            Platform.runLater(() -> this.cbVideoPanoramaInput.setSelected(true));
                            break;
                        }
                        case OUTPUT: {
                            Platform.runLater(() -> this.cbVideoPanoramaOutput.setSelected(true));
                        }
                    }
                });
            }
        });
    }

    @Subscribe
    public void onStareMonitorClosing(StareMonitorClosing event) {
        this.release();
    }

    private StareControl replaceStareControl(String controlType, StarePlugin starePlugin) {
        Control replacedControl = this.control;
        int insertIndex = -1;
        if (this.stareControl != null && this.control != null) {
            insertIndex = starePlugin.getSettings().findFirstControlIndex(this.control.getName());
            this.deleteVideoPanoramaControl(this.stareControl, this.control, starePlugin);
        }
        this.control = ControlBuilder.build((String)controlType);
        if (this.control == null) {
            logger.error((Object)String.format("Control can't created, control type: '%s'", controlType));
        }
        if (replacedControl != null) {
            this.control.copy(replacedControl);
        } else {
            this.control.setName(this.selected.getUuid().toString());
        }
        this.stareControl = this.createStareControl(insertIndex, this.control, starePlugin);
        return this.stareControl;
    }

    private StareControl createStareControl(Control control, StarePlugin starePlugin) {
        int insertIndex = starePlugin.getSettings().getControls().size();
        return this.createStareControl(insertIndex, control, starePlugin);
    }

    private StareControl createStareControl(int insertIndex, Control control, StarePlugin starePlugin) {
        if (insertIndex == -1) {
            return this.createStareControl(control, starePlugin);
        }
        StareControl stareControl = new StareControl();
        stareControl.setId(this.selected.getUuid());
        stareControl.setPropertyName("value");
        stareControl.setControlName(control.getName());
        Settings settings = starePlugin.getSettings();
        settings.addStareControl(stareControl);
        settings.addControl(insertIndex, control);
        return stareControl;
    }

    private void deleteVideoPanoramaControl(StareControl stareControl, Control control, StarePlugin starePlugin) {
        Settings settings = starePlugin.getSettings();
        if (stareControl.getDataProcessUuid() != null) {
            UUID uid = UUID.fromString(stareControl.getDataProcessUuid());
            settings.removeStareControl(uid);
        }
        if (control.getName() != null) {
            settings.removeControl(control.getName());
        }
    }

    private void buildAndDisplayUIControl(StareControl stareControl, Control control) {
        UIVPControl uiControl = UIControlBuilder.build(control.getType());
        if (uiControl == null) {
            return;
        }
        try {
            uiControl.initialize(stareControl, control);
            this.cmbControlType.setValue((Object)control.getType());
            this.anchorPaneSettings.getChildren().clear();
            this.anchorPaneSettings.getChildren().add((Object)uiControl);
            PaneHelper.setAnchorZero((Node)uiControl);
        }
        catch (Throwable t) {
            logger.error((Object)t.getMessage(), t);
        }
    }

    @Override
    public void release() {
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
    }

    private void showVPControlIntrospection(boolean show) {
        this.vbIntrospection.setVisible(show);
    }
}

