/*
 * Decompiled with CFR 0.152.
 */
package com.siams.stare.plugin.vp;

import com.siams.cv.monitor.application.App;
import com.siams.cv.monitor.message.NodeRemoved;
import com.siams.cv.monitor.message.StareProjectLoaded;
import com.siams.cv.monitor.message.StareProjectSaved;
import com.siams.cv.monitor.model.app.Project;
import com.siams.cv.monitor.plugin.vp.model.VPPluginModel;
import com.siams.data.vpjson.project.filter.plugin.stare.Settings;
import com.siams.javafx.PaneHelper;
import com.siams.stare.plugin.StareFxClientPlugin;
import com.siams.stare.plugin.vp.MainMenu;
import com.siams.stare.plugin.vp.control.VPControlIntrospection;
import java.io.IOException;
import javafx.scene.Node;
import org.apache.log4j.Logger;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class VideoPanoramaPlugin
implements StareFxClientPlugin {
    private static Logger logger = Logger.getLogger(VideoPanoramaPlugin.class);
    private MainMenu mainMenu = new MainMenu();
    private VPControlIntrospection controlIntrospection = new VPControlIntrospection();

    public void initializePlugin(Node root) {
        try {
            this.mainMenu.initialize(root);
            this.controlIntrospection.initialize(root);
            PaneHelper.setAnchorZero((Node)this.controlIntrospection);
            this.subscribe();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void subscribe() {
        EventBus.getDefault().register((Object)this);
    }

    public void release() {
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
    }

    @Subscribe
    public void onStareProjectLoaded(StareProjectLoaded event) {
        Project project = event.getProject();
        if (!project.hasPlugin("VPPluginModel")) {
            VPPluginModel plugin = new VPPluginModel();
            project.addPlugin(plugin);
        }
    }

    @Subscribe
    public void onNodeRemoved(NodeRemoved event) {
        App.getInstance().getProject().findPlugin("VPPluginModel", VPPluginModel.class).ifPresent(plugin -> plugin.getVpjson().getProject().findStarePlugin().ifPresent(starePlugin -> {
            Settings settings = starePlugin.getSettings();
            settings.removeStareControl(event.getUuid());
        }));
    }

    @Subscribe
    public void onStareProjectSaved(StareProjectSaved event) {
        Project project = event.getProject();
        project.findPlugin("VPPluginModel", VPPluginModel.class).ifPresent(plugin -> plugin.getVpjson().getProject().findStarePlugin().ifPresent(starePlugin -> starePlugin.getSettings().setStareProjectFile(project.getProjectFile().getName())));
    }
}

