/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.utils;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableView;

public class TreeTableViewWalker<T> {
    private Deque<Tuple<TreeItem<T>, Integer>> stack = new ArrayDeque<Tuple<TreeItem<T>, Integer>>();

    public TreeTableViewWalker(TreeTableView<T> tree) {
        if (tree.getRoot() != null) {
            this.stack.push(new Tuple<TreeItem, Integer>(tree.getRoot(), -1));
        }
    }

    public boolean hasNext() {
        return !this.stack.isEmpty();
    }

    public TreeItem<T> next() {
        if (!this.hasNext()) {
            throw new IllegalStateException("");
        }
        TreeItem<T> nxt = this.stack.peek().getFirst();
        this.move();
        return nxt;
    }

    private void move() {
        Tuple<TreeItem<T>, Integer> n = this.stack.pop();
        ObservableList ch = n.getFirst().getChildren();
        int idx = n.getSecond() + 1;
        if (ch.size() <= idx) {
            if (this.stack.isEmpty()) {
                return;
            }
            this.move();
        } else {
            this.stack.push(n.setSecond(idx));
            this.stack.push(new Tuple<TreeItem, Integer>((TreeItem)ch.get(idx), -1));
        }
    }

    public Stream<TreeItem<T>> stream() {
        return StreamSupport.stream(new Spliterator<TreeItem<T>>(){

            @Override
            public int characteristics() {
                return 0;
            }

            @Override
            public long estimateSize() {
                return Long.MAX_VALUE;
            }

            @Override
            public boolean tryAdvance(Consumer<? super TreeItem<T>> action) {
                if (TreeTableViewWalker.this.hasNext()) {
                    action.accept(TreeTableViewWalker.this.next());
                    return true;
                }
                return false;
            }

            @Override
            public Spliterator<TreeItem<T>> trySplit() {
                return null;
            }
        }, false);
    }

    public static <T> void visit(TreeTableView<T> tree, Consumer<TreeItem<T>> visitor) {
        TreeTableViewWalker<T> tw = new TreeTableViewWalker<T>(tree);
        while (tw.hasNext()) {
            visitor.accept(tw.next());
        }
    }

    public static <T> void visitItems(TreeTableView<T> tree, Consumer<T> visitor) {
        TreeTableViewWalker<T> tw = new TreeTableViewWalker<T>(tree);
        while (tw.hasNext()) {
            visitor.accept(tw.next().getValue());
        }
    }

    public class Tuple<E, F> {
        E first;
        F second;

        public Tuple(E first, F second) {
            this.first = first;
            this.second = second;
        }

        public E getFirst() {
            return this.first;
        }

        public Tuple<E, F> setFirst(E first) {
            return new Tuple<E, F>(first, this.second);
        }

        public F getSecond() {
            return this.second;
        }

        public Tuple<E, F> setSecond(F second) {
            return new Tuple<E, F>(this.first, second);
        }

        public String toString() {
            return "Tuple [first=" + String.valueOf(this.first) + ", second=" + String.valueOf(this.second) + "]";
        }
    }
}

