/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.factory;

import com.siams.cv.monitor.application.App;
import com.siams.cv.monitor.entity.StareNode;
import com.siams.cv.monitor.message.NodeRemoved;
import com.siams.cv.monitor.message.NodeSelected;
import com.siams.cv.monitor.message.StareMonitorClosing;
import com.siams.cv.monitor.model.node.AnchorType;
import com.siams.cv.monitor.model.node.UILinkModel;
import com.siams.cv.monitor.model.storage.NodeStorage;
import com.siams.cv.monitor.ui.DefaultNodeClickHandler;
import com.siams.cv.monitor.ui.DetachHandler;
import com.siams.cv.monitor.ui.factory.Connection;
import com.siams.cv.monitor.ui.factory.Deletable;
import com.siams.javafx.utils.FxPlatform;
import java.util.Objects;
import java.util.UUID;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class UILink
extends Connection
implements Deletable {
    private final UILinkModel model;
    private UILinkClickHandler clickHandler;
    private Runnable srcAnchorPositionListener = new Runnable(){

        @Override
        public void run() {
            UILink.this.render();
        }
    };
    private Runnable destAnchorPositionListener = new Runnable(){

        @Override
        public void run() {
            UILink.this.render();
        }
    };

    public UILink(UILinkModel model) {
        Objects.requireNonNull(model, "Valid model required");
        this.model = model;
        this.initialize();
    }

    @Override
    protected void initialize() {
        this.initializeStyle();
        this.initializeAnchors();
        this.initializeMouseEvents();
        this.subscribe();
    }

    @Override
    protected void initializeAnchors() {
        this.getSrcAnchor();
        this.getDestAnchor();
    }

    private void initializeMouseEvents() {
        this.clickHandler = new UILinkClickHandler((Node)this, this);
        this.setOnMouseDragged(Event::consume);
    }

    private void subscribe() {
        EventBus.getDefault().register((Object)this);
    }

    @Subscribe
    public void onNodeSelected(NodeSelected event) {
        FxPlatform.RunFxThread(() -> {
            UUID uuid = this.getUuid();
            this.setSelection(event.getSelected().stream().anyMatch(iid -> iid.getUuid().equals(uuid)));
        });
    }

    @Subscribe
    public void onNodeRemoved(NodeRemoved event) {
        if (event.getUuid().equals(this.model.getSrcPortUuid())) {
            DetachHandler.detach(this, App.getInstance().addUiLinkAnchor(AnchorType.SRC));
        } else if (event.getUuid().equals(this.model.getDestPortUuid())) {
            DetachHandler.detach(this, App.getInstance().addUiLinkAnchor(AnchorType.DEST));
        }
    }

    @Subscribe
    public void onStareMonitorClosing(StareMonitorClosing event) {
        this.release();
    }

    public UUID getUuid() {
        return this.model.getUuid();
    }

    @Override
    public Node getNode() {
        return this;
    }

    public UILinkModel getNodeModel() {
        return this.model;
    }

    @Override
    public void release() {
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
        if (this.srcAnchor != null && this.srcAnchorPositionListener != null) {
            UUID srcAnchorId = this.srcAnchor.getNodeModel().getUuid();
            assert (srcAnchorId != null);
            NodeStorage.getInstance().findFirst(srcAnchorId, StareNode.class).ifPresent(stateNode -> stateNode.removeChangePositionListener(this.srcAnchorPositionListener));
            this.srcAnchorPositionListener = null;
        }
        if (this.destAnchor != null && this.destAnchorPositionListener != null) {
            UUID destAnchorId = this.destAnchor.getNodeModel().getUuid();
            assert (destAnchorId != null);
            NodeStorage.getInstance().findFirst(destAnchorId, StareNode.class).ifPresent(stareNode -> stareNode.removeChangePositionListener(this.destAnchorPositionListener));
            this.destAnchorPositionListener = null;
        }
        if (this.clickHandler != null) {
            this.clickHandler.release();
        }
    }

    @Override
    public StareNode getSrcAnchor() {
        if (this.srcAnchor == null) {
            NodeStorage.getInstance().findFirst(this.model.getSrcPortUuid(), StareNode.class).ifPresent(this::setSrcAnchor);
        }
        return this.srcAnchor;
    }

    @Override
    public StareNode getDestAnchor() {
        if (this.destAnchor == null) {
            NodeStorage.getInstance().findFirst(this.model.getDestPortUuid(), StareNode.class).ifPresent(this::setDestAnchor);
        }
        return this.destAnchor;
    }

    private void setSelection(boolean isSelected) {
        this.getStyleClass().removeAll((Object[])new String[]{"selected"});
        if (isSelected) {
            this.getStyleClass().add((Object)"selected");
        }
    }

    @Override
    public void setSrcAnchor(StareNode srcAnchor) {
        if (this.srcAnchor != null && this.srcAnchorPositionListener != null) {
            this.srcAnchor.removeChangePositionListener(this.srcAnchorPositionListener);
        }
        super.setSrcAnchor(srcAnchor);
        if (srcAnchor != null) {
            srcAnchor.addChangePositionListener(this.srcAnchorPositionListener);
        }
    }

    @Override
    public void setDestAnchor(StareNode destAnchor) {
        if (this.destAnchor != null && this.destAnchorPositionListener != null) {
            this.destAnchor.removeChangePositionListener(this.destAnchorPositionListener);
        }
        super.setDestAnchor(destAnchor);
        if (destAnchor != null) {
            destAnchor.addChangePositionListener(this.destAnchorPositionListener);
        }
    }

    public String getRelUrl() {
        return String.format("/link:%s", this.getUuid());
    }

    private static class UILinkClickHandler
    extends DefaultNodeClickHandler {
        private UILinkClickHandler(Node eventConsumer, StareNode eventTarget) {
            super(eventConsumer, eventTarget);
        }

        @Override
        protected void onClick(MouseEvent event) {
            super.onClick(event);
        }
    }
}

