/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.factory;

import com.siams.cv.monitor.application.App;
import com.siams.cv.monitor.application.StareClipboard;
import com.siams.cv.monitor.application.UserAction;
import com.siams.cv.monitor.model.storage.IIDStorage;
import com.siams.cv.monitor.model.worker.WorkerType;
import com.siams.cv.monitor.ui.content.container.FunctionsList;
import com.siams.cv.monitor.ui.content.container.RootPane;
import com.siams.cv.monitor.ui.factory.PortVisibilityManagementDialog;
import com.siams.cv.monitor.ui.factory.UIBlock;
import com.siams.javafx.utils.FxPlatform;
import com.siams.notifications.StareNotification;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import net.algart.executors.api.system.ExecutorSpecification;
import org.apache.log4j.Logger;

class UIBlockContextMenu
extends ContextMenu {
    private Logger logger = Logger.getLogger(UIBlockContextMenu.class);
    private UIBlock uiBlock;
    private final App app = App.getInstance();
    private MenuItem menuItemEnableDisable;
    private MenuItem menuItemEnableDisableAutoContrastVisibleResult;
    private MenuItem menuItemSpecificationFolder;
    private MenuItem menuItemModuleFolder;
    private MenuItem menuItemSubChain;
    private CheckMenuItem menuItemExecutionStageRunTime;
    private CheckMenuItem menuItemExecutionStageLoadingTime;
    private final String enableDisableHotKey = "CTRL+D/CTRL+SHIFT+D";

    UIBlockContextMenu(UIBlock uiBlock) {
        this.uiBlock = uiBlock;
        this.setAutoHide(true);
        this.initializeMenuItems();
    }

    private void initializeMenuItems() {
        this.menuItemEnableDisable = new MenuItem(String.format("Disable %s", "CTRL+D/CTRL+SHIFT+D"));
        this.menuItemEnableDisable.setOnAction(this::onEnableDisable);
        this.menuItemEnableDisableAutoContrastVisibleResult = new MenuItem("Enable auto contrast");
        this.menuItemEnableDisableAutoContrastVisibleResult.setOnAction(this::onEnableDisableAutoContrastVisibleResult);
        MenuItem menuItemExecute = new MenuItem("Run (CTRL+SHIFT+F5)");
        menuItemExecute.setOnAction(this::onExecute);
        MenuItem menuItemQuickHelp = new MenuItem("Quick help (CTRL+Q)");
        menuItemQuickHelp.setOnAction(this::onQuickHelp);
        MenuItem menuItemDeleteBlock = new MenuItem("Delete block (DEL)");
        menuItemDeleteBlock.setOnAction(this::onDeleteBlock);
        MenuItem menuItemScrollToFunction = new MenuItem("Scroll to function (F7)");
        menuItemScrollToFunction.setOnAction(this::onScrollToFunction);
        MenuItem miScrollToStatistic = new MenuItem("Scroll to statistic (F8)");
        miScrollToStatistic.setOnAction(this::onScrollToStatistic);
        MenuItem menuItemEditCaption = new MenuItem("Edit caption (F2)");
        menuItemEditCaption.setOnAction(this::onRenameBlock);
        MenuItem menuItemEditComment = new MenuItem("Edit comment");
        menuItemEditComment.setOnAction(this::onEditComment);
        MenuItem menuItemEditSystemName = new MenuItem("Edit system name");
        menuItemEditSystemName.setOnAction(this::onEditSystemName);
        Menu menuViewers = this.createViewersMenu();
        this.menuItemSpecificationFolder = new MenuItem("Open executor specification location");
        this.menuItemSpecificationFolder.setOnAction(this::onOpenSpecificationFolder);
        this.menuItemSpecificationFolder.setVisible(false);
        this.menuItemModuleFolder = new MenuItem("(must be replaced)");
        this.menuItemModuleFolder.setOnAction(this::onOpenModuleFolder);
        this.menuItemModuleFolder.setVisible(false);
        this.menuItemSubChain = new MenuItem("Open sub-chain in a new window");
        this.menuItemSubChain.setOnAction(this::onOpenSubChain);
        this.menuItemSubChain.setVisible(false);
        MenuItem menuItemCut = new MenuItem("Cut (CTRL+X)");
        menuItemCut.setOnAction(this::onCut);
        MenuItem menuItemCopy = new MenuItem("Copy (CTRL+C)");
        menuItemCopy.setOnAction(this::onCopy);
        this.menuItemExecutionStageRunTime = new CheckMenuItem("Run time");
        this.menuItemExecutionStageRunTime.setOnAction(this::onChangeExecutionStageToRunTime);
        this.menuItemExecutionStageLoadingTime = new CheckMenuItem("Loading time");
        this.menuItemExecutionStageLoadingTime.setOnAction(this::onChangeExecutionStageToLoadingTime);
        MenuItem menuItemPorts = new MenuItem("Enable/disable ports");
        menuItemPorts.setOnAction(this::onManagePortsVisibility);
        MenuItem menuItemShowModel = new MenuItem("Show executor JSON specification");
        menuItemShowModel.setOnAction(this::onShowModel);
        this.getItems().addAll((Object[])new MenuItem[]{menuItemExecute, this.menuItemEnableDisable, this.menuItemEnableDisableAutoContrastVisibleResult, menuItemScrollToFunction, miScrollToStatistic, menuItemQuickHelp, menuItemEditCaption, menuItemEditComment, menuItemDeleteBlock, new SeparatorMenuItem(), menuViewers, this.menuItemSpecificationFolder, this.menuItemModuleFolder, this.menuItemSubChain, new SeparatorMenuItem(), menuItemCut, menuItemCopy, new SeparatorMenuItem(), menuItemEditSystemName, menuItemPorts, menuItemShowModel});
    }

    private void onShowModel(ActionEvent action) {
        UUID modelId = this.uiBlock.getNodeModel().getWorkerType();
        UserAction.showSpecification(modelId);
    }

    private CompletableFuture<String> analyseModel(Consumer<ExecutorSpecification> consumer) {
        UUID modelId = this.uiBlock.getNodeModel().getWorkerType();
        return this.app.rqGetData(String.format("P/model:%s", modelId), String.class).whenComplete((text, t) -> {
            if (t == null) {
                try {
                    ExecutorSpecification specification = ExecutorSpecification.of((String)text);
                    consumer.accept(specification);
                }
                catch (Exception e) {
                    t = e;
                }
            }
            if (t != null) {
                String error = String.format("Failed analysing executor: %s", t.getMessage());
                this.logger.warn((Object)error, t);
                StareNotification.showWarn((String)error);
            }
        });
    }

    private void onContextMenuRequested() {
        this.app.rqGetObjectPropertyIfExist(this.uiBlock, "__tmp.execution_stage", ExecutionStage.RUN_TIME.getId()).thenAccept(stage -> {
            if (stage.intValue() == ExecutionStage.LOADING_TIME.getId()) {
                this.menuItemExecutionStageLoadingTime.setSelected(true);
                this.menuItemExecutionStageRunTime.setSelected(false);
            } else if (stage.intValue() == ExecutionStage.RUN_TIME.getId()) {
                this.menuItemExecutionStageLoadingTime.setSelected(false);
                this.menuItemExecutionStageRunTime.setSelected(true);
            } else {
                this.menuItemExecutionStageLoadingTime.setSelected(false);
                this.menuItemExecutionStageRunTime.setSelected(false);
            }
        });
        this.updateEnableDisableMenuItemCaption();
        this.updateOpenSourceMenuItems();
    }

    private void onQuickHelp(ActionEvent event) {
        UserAction.showHelpSelectedObject();
    }

    private void onExecute(ActionEvent event) {
        UserAction.executeWorker(this.uiBlock.getUuid());
    }

    private void onDeleteBlock(ActionEvent event) {
        UserAction.deleteObject(this.uiBlock, true);
    }

    private void onScrollToFunction(ActionEvent event) {
        UserAction.clearRegisteredComponentsFilter();
        IIDStorage iidStorage = IIDStorage.getInstance();
        iidStorage.findFirst(this.uiBlock.getNodeModel().getWorkerType(), WorkerType.class).ifPresent(UserAction::scrollToModel);
    }

    private void onScrollToStatistic(ActionEvent event) {
        FunctionsList.getInstance().scrollToItem(this.uiBlock.getNodeModel().getUuid());
    }

    private void onRenameBlock(ActionEvent event) {
        UserAction.editUiBlockModelCaption(this.uiBlock.getNodeModel());
    }

    private void onEditComment(ActionEvent event) {
        UserAction.editUiBlockModelComment(this.uiBlock.getNodeModel());
    }

    private void onEditSystemName(ActionEvent event) {
        UserAction.editUiBlockModelSystemName(this.uiBlock.getNodeModel());
    }

    private Menu createViewersMenu() {
        Menu menuViewers = new Menu("Open viewer");
        MenuItem miSimpleViewer = new MenuItem("Simple viewer (F3)");
        miSimpleViewer.setOnAction(this::onOpenViewer);
        MenuItem miBlockTuner = new MenuItem("Block tuner (F4)");
        miBlockTuner.setOnAction(this::onOpenBlockTuner);
        MenuItem miCompareViewer = new MenuItem("Add to compare");
        miCompareViewer.setOnAction(this::onAddViewerToCompare);
        menuViewers.getItems().addAll((Object[])new MenuItem[]{miSimpleViewer, miBlockTuner, miCompareViewer});
        return menuViewers;
    }

    private void onOpenViewer(ActionEvent event) {
        this.uiBlock.callViewer();
    }

    private void onOpenBlockTuner(ActionEvent event) {
        UserAction.openBlockTuner(this.uiBlock.getNodeModel());
    }

    private void onOpenSpecificationFolder(ActionEvent event) {
        this.analyseModel(model -> UserAction.openSourceSpecificationFolder(model.getSourceInfo(), model.getName()));
    }

    private void onOpenModuleFolder(ActionEvent event) {
        this.analyseModel(model -> UserAction.openSourceModuleFolder(model.getSourceInfo(), model.getName()));
    }

    private void onOpenSubChain(ActionEvent event) {
        this.analyseModel(model -> UserAction.openSubChainInNewWindow(model.getSourceInfo(), model.getName()));
    }

    private void onCut(ActionEvent event) {
        UserAction.unselectedNodes();
        UserAction.selectNode(this.uiBlock);
        String processStatus = "Cut";
        RootPane.showProcessIsRunning("Cut");
        StareClipboard.cutSelectedObjects().whenComplete((v, t) -> {
            if (t != null) {
                String error = String.format("Failed cut objects: %s", t.getMessage());
                this.logger.error((Object)error, t);
                StareNotification.showWarn((String)error);
            }
            RootPane.hideProcessIsRunning("Cut");
        });
    }

    private void onCopy(ActionEvent event) {
        UserAction.unselectedNodes();
        UserAction.selectNode(this.uiBlock);
        String processStatus = "Copy";
        RootPane.showProcessIsRunning("Copy");
        StareClipboard.copySelectedObjects().whenComplete((v, t) -> {
            if (t != null) {
                String error = String.format("Failed copy objects: %s", t.getMessage());
                this.logger.warn((Object)error, t);
                StareNotification.showWarn((String)error);
            }
            RootPane.hideProcessIsRunning("Copy");
        });
    }

    private void onChangeExecutionStageToRunTime(ActionEvent event) {
        this.app.rqSetObjectProperty(this.uiBlock, "__tmp.execution_stage", ExecutionStage.RUN_TIME.getId());
    }

    private void onChangeExecutionStageToLoadingTime(ActionEvent event) {
        this.app.rqSetObjectProperty(this.uiBlock, "__tmp.execution_stage", ExecutionStage.LOADING_TIME.getId());
    }

    private void onAddViewerToCompare(ActionEvent event) {
        UserAction.addViewerToCompare(this.uiBlock.getUuid());
    }

    private void updateEnableDisableMenuItemCaption() {
        this.app.rqIsEnabled(this.uiBlock.getNodeModel()).thenAccept(enabled -> Platform.runLater(() -> {
            this.menuItemEnableDisable.setText(enabled != false ? String.format("Disable %s", "CTRL+D/CTRL+SHIFT+D") : String.format("Enable %s", "CTRL+D/CTRL+SHIFT+D"));
            this.uiBlock.setEnabled((Boolean)enabled);
        }));
    }

    private void updateOpenSourceMenuItems() {
        this.analyseModel(specification -> Platform.runLater(() -> {
            ExecutorSpecification.SourceInfo sourceInfo = specification.getSourceInfo();
            String languageName = sourceInfo == null ? null : sourceInfo.getLanguageName();
            boolean sourceModelAvailable = UserAction.isSourceModelAvailable(sourceInfo);
            boolean sourceModuleAvailable = UserAction.isSourceModuleAvailable(sourceInfo);
            boolean subChain = UserAction.isSubChain(sourceInfo);
            this.menuItemSpecificationFolder.setVisible(sourceModelAvailable);
            this.menuItemModuleFolder.setText("Open " + (String)(subChain ? "sub-chain " : (languageName == null ? "executor source " : "executor source " + languageName + " ")) + "location");
            this.menuItemModuleFolder.setVisible(sourceModuleAvailable);
            this.menuItemSubChain.setVisible(sourceModuleAvailable && subChain);
        }));
    }

    private void onEnableDisable(ActionEvent actionEvent) {
        this.app.rqIsEnabled(this.uiBlock.getNodeModel()).thenAccept(enabled -> this.app.rqSetEnabled(this.uiBlock, enabled == false).whenComplete((dRsObjectProperty, t) -> {
            if (t == null) {
                this.updateEnableDisableMenuItemCaption();
            } else {
                String error = String.format("Failed enable/disable block. %s", t.getMessage());
                this.logger.error((Object)error, t);
                StareNotification.showWarn((String)error);
            }
        }));
    }

    private void onEnableDisableAutoContrastVisibleResult(ActionEvent actionEvent) {
        this.app.rqGetAutoContrastVisibleResult(this.uiBlock.getNodeModel()).thenAccept(enabled -> ((CompletableFuture)this.app.rqSetAutoContrastVisibleResult(this.uiBlock.getNodeModel(), enabled == false).thenCompose(v -> this.app.rqBuildPreview(this.uiBlock.getUuid()))).whenComplete((rs, t) -> {
            if (t == null) {
                this.updateEnableDisableAutoContrastVisibleResultMenuItemCaption();
            } else {
                String error = String.format("Failed enable/disable auto contrast visible result. %s", t.getMessage());
                this.logger.error((Object)error, t);
                StareNotification.showWarn((String)error);
            }
        }));
    }

    private void updateEnableDisableAutoContrastVisibleResultMenuItemCaption() {
        this.app.rqGetAutoContrastVisibleResult(this.uiBlock.getNodeModel()).thenAccept(enabled -> FxPlatform.RunFxThread(() -> this.menuItemEnableDisableAutoContrastVisibleResult.setText(enabled != false ? "Disable auto contrast" : "Enable auto contrast")));
    }

    private void onManagePortsVisibility(ActionEvent actionEvent) {
        PortVisibilityManagementDialog dialog = new PortVisibilityManagementDialog(this.uiBlock);
        dialog.showAndWait().ifPresent(dialog::handleChanges);
    }

    public void show(Node anchor, double screenX, double screenY) {
        this.onContextMenuRequested();
        super.show(anchor, screenX, screenY);
    }

    public void hide() {
        super.hide();
    }

    private static enum ExecutionStage {
        UNKNOWN(0, "unknown"),
        LOADING_TIME(1, "loading_time"),
        RUN_TIME(2, "run_time");

        private int id;
        private String name;

        private ExecutionStage(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }
    }
}

