/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.factory;

import com.siams.cv.monitor.application.App;
import com.siams.cv.monitor.model.PortType;
import com.siams.cv.monitor.model.node.UIBlockModel;
import com.siams.cv.monitor.model.node.UIPortModel;
import com.siams.cv.monitor.ui.factory.UIBlock;
import com.siams.dialogs.DialogManager;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxTreeCell;
import javafx.util.StringConverter;
import org.controlsfx.control.CheckTreeView;

public class PortVisibilityManagementDialog
extends Dialog<List<UIPortTreeItem>> {
    private final UIBlock uiBlock;

    public PortVisibilityManagementDialog(UIBlock uiBlock) {
        this.uiBlock = uiBlock;
        PortVisibilityManagementPane dialogPane = new PortVisibilityManagementPane(uiBlock.getNodeModel());
        dialogPane.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.setTitle("Select ports to enable");
        this.setDialogPane(dialogPane);
        this.setResizable(true);
        this.setResultConverter(pressed -> {
            ButtonBar.ButtonData data = pressed == null ? null : pressed.getButtonData();
            return data == ButtonBar.ButtonData.OK_DONE ? dialogPane.getVisibilityState() : null;
        });
    }

    public void handleChanges(List<UIPortTreeItem> selectedPorts) {
        boolean showQuery = true;
        boolean queryAnswer = true;
        for (UIPortTreeItem portTreeItem : selectedPorts) {
            Optional optPortModel = this.uiBlock.getNodeModel().findPort(portTreeItem.getType(), portTreeItem.getName());
            if (!optPortModel.isPresent()) continue;
            UIPortModel portModel = (UIPortModel)optPortModel.get();
            if (!portTreeItem.isEnabled() && App.hasConnection(portModel)) {
                if (showQuery) {
                    showQuery = false;
                    queryAnswer = DialogManager.showQuery((String)"Delete existing links?", (String)"Confirm").isPresent();
                }
                if (!queryAnswer) continue;
                App.findConnectedLinks(portModel).forEach(App::rqRemoveObject);
            }
            portModel.setVisible(portTreeItem.isEnabled());
            this.uiBlock.updatePortVisibility(portModel);
        }
    }

    private static class PortVisibilityManagementPane
    extends DialogPane {
        private TreeView<UIPortTreeItem> inputsTree;
        private TreeView<UIPortTreeItem> outputsTree;

        private PortVisibilityManagementPane(UIBlockModel blockModel) {
            Node content = this.initializeContent(blockModel);
            this.setContent(content);
        }

        private Node initializeContent(UIBlockModel blockModel) {
            CheckBoxTreeItem allInputs = new CheckBoxTreeItem((Object)new UIPortTreeItem(PortType.INPUT, "All", false));
            allInputs.setExpanded(true);
            blockModel.getPorts(PortType.INPUT).forEach(inputPortModel -> {
                CheckBoxTreeItem item = new CheckBoxTreeItem((Object)new UIPortTreeItem((UIPortModel)inputPortModel));
                item.selectedProperty().bindBidirectional((Property)((UIPortTreeItem)item.getValue()).enabledProperty());
                allInputs.getChildren().add((Object)item);
            });
            CheckBoxTreeItem inputControls = new CheckBoxTreeItem((Object)new UIPortTreeItem(PortType.INPUT_CONTROL, "Controls", false));
            inputControls.setExpanded(true);
            blockModel.getPorts(PortType.INPUT_CONTROL).forEach(inputControlPortModel -> {
                CheckBoxTreeItem item = new CheckBoxTreeItem((Object)new UIPortTreeItem((UIPortModel)inputControlPortModel));
                item.selectedProperty().bindBidirectional((Property)((UIPortTreeItem)item.getValue()).enabledProperty());
                inputControls.getChildren().add((Object)item);
            });
            allInputs.getChildren().add((Object)inputControls);
            this.inputsTree = new CheckTreeView(allInputs);
            this.inputsTree.setEditable(false);
            this.inputsTree.setCellFactory(param -> {
                CheckBoxTreeCell cell = new CheckBoxTreeCell();
                cell.setConverter((StringConverter)new UIPortStringConverter());
                return cell;
            });
            Tab inputPorts = new Tab("Input");
            inputPorts.setClosable(false);
            inputPorts.setContent(this.inputsTree);
            CheckBoxTreeItem allOutputs = new CheckBoxTreeItem((Object)new UIPortTreeItem(PortType.OUTPUT, "All", false));
            allOutputs.setExpanded(true);
            blockModel.getPorts(PortType.OUTPUT).forEach(outputPortModel -> {
                CheckBoxTreeItem item = new CheckBoxTreeItem((Object)new UIPortTreeItem((UIPortModel)outputPortModel));
                item.selectedProperty().bindBidirectional((Property)((UIPortTreeItem)item.getValue()).enabledProperty());
                allOutputs.getChildren().add((Object)item);
            });
            CheckBoxTreeItem outputControls = new CheckBoxTreeItem((Object)new UIPortTreeItem(PortType.OUTPUT_CONTROL, "Controls", false));
            outputControls.setExpanded(true);
            blockModel.getPorts(PortType.OUTPUT_CONTROL).forEach(outputControlPortModel -> {
                CheckBoxTreeItem item = new CheckBoxTreeItem((Object)new UIPortTreeItem((UIPortModel)outputControlPortModel));
                item.selectedProperty().bindBidirectional((Property)((UIPortTreeItem)item.getValue()).enabledProperty());
                outputControls.getChildren().add((Object)item);
            });
            allOutputs.getChildren().add((Object)outputControls);
            this.outputsTree = new CheckTreeView(allOutputs);
            this.outputsTree.setEditable(false);
            this.outputsTree.setCellFactory(param -> {
                CheckBoxTreeCell cell = new CheckBoxTreeCell();
                cell.setConverter((StringConverter)new UIPortStringConverter());
                return cell;
            });
            Tab outputPorts = new Tab("Output");
            outputPorts.setClosable(false);
            outputPorts.setContent(this.outputsTree);
            return new TabPane(new Tab[]{inputPorts, outputPorts});
        }

        private List<UIPortTreeItem> getVisibilityState() {
            int i;
            LinkedList<UIPortTreeItem> state = new LinkedList<UIPortTreeItem>();
            int treeSize = this.inputsTree.getExpandedItemCount();
            for (i = 0; i < treeSize; ++i) {
                state.add((UIPortTreeItem)this.inputsTree.getTreeItem(i).getValue());
            }
            treeSize = this.outputsTree.getExpandedItemCount();
            for (i = 0; i < treeSize; ++i) {
                state.add((UIPortTreeItem)this.outputsTree.getTreeItem(i).getValue());
            }
            return state;
        }
    }

    static class UIPortTreeItem {
        private PortType type;
        private String name;
        private BooleanProperty enabled;

        private UIPortTreeItem(UIPortModel portModel) {
            this.type = portModel.getPortType();
            this.name = portModel.getName();
            this.enabled = new SimpleBooleanProperty(portModel.isVisible());
        }

        private UIPortTreeItem(PortType type, String name, boolean enabled) {
            this.type = type;
            this.name = name;
            this.enabled = new SimpleBooleanProperty(enabled);
        }

        private PortType getType() {
            return this.type;
        }

        private String getName() {
            return this.name;
        }

        private boolean isEnabled() {
            return this.enabled.get();
        }

        private BooleanProperty enabledProperty() {
            return this.enabled;
        }
    }

    private static class UIPortStringConverter
    extends StringConverter<TreeItem<UIPortTreeItem>> {
        private UIPortStringConverter() {
        }

        public String toString(TreeItem<UIPortTreeItem> object) {
            return ((UIPortTreeItem)object.getValue()).getName();
        }

        public TreeItem<UIPortTreeItem> fromString(String string) {
            return null;
        }
    }
}

