/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.content.settings.block;

import com.siams.cv.monitor.application.App;
import com.siams.cv.monitor.model.SimplePrimitive;
import com.siams.cv.monitor.model.node.UIBlockModel;
import com.siams.cv.monitor.model.worker.WorkerStructure;
import com.siams.cv.monitor.model.worker.control.SCEItem;
import com.siams.cv.monitor.model.worker.control.SCEnum;
import com.siams.cv.monitor.model.worker.control.SControl;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.cell.ComboBoxListCell;
import javafx.scene.layout.AnchorPane;
import org.apache.log4j.Logger;

@Deprecated
public abstract class BlockSettings {
    private final Logger logger = Logger.getLogger(BlockSettings.class);
    private static final App app = App.getInstance();
    protected WorkerStructure structure;
    protected UIBlockModel uiBlockModel;

    public void setProperties(UIBlockModel blockModel, List<SimplePrimitive> primitives) {
        this.uiBlockModel = blockModel;
    }

    public abstract AnchorPane getSettings();

    public void updateControls(Control[] controls) {
    }

    public void updateValues(List<SimplePrimitive> properties, Control[] controls) {
        for (Control control : controls) {
            if (control == null) {
                this.logger.error((Object)"Control is null, in control list");
                continue;
            }
            String name = control.getId();
            if (name == null) {
                this.logger.error((Object)"Forgot to create element id?");
                continue;
            }
            try {
                SimplePrimitive property = properties.stream().filter(p -> p.getName().equals(name)).findFirst().get();
                SControl structureControl = (SControl)this.structure.findControl(name).get();
                if (control instanceof ComboBox) {
                    ComboBox comboBox = (ComboBox)control;
                    if (structureControl.getEditionType() == SControl.EditionType.ENUM) {
                        SCEnum scEnum = (SCEnum)structureControl;
                        String propertyValue = String.valueOf(property.getVal());
                        Optional optItem = scEnum.findItem(propertyValue);
                        if (optItem.isPresent()) {
                            comboBox.getSelectionModel().select((Object)((SCEItem)optItem.get()));
                            continue;
                        }
                        this.logger.error((Object)String.format("SCEItem can't be found for value: %s", propertyValue));
                        continue;
                    }
                    this.logger.error((Object)String.format("Unsupported pair structure control and javafx control, name: %s", name));
                    continue;
                }
                if (control instanceof TextField) {
                    TextField textField = (TextField)control;
                    if (structureControl.getEditionType() != SControl.EditionType.VALUE && structureControl.getEditionType() != SControl.EditionType.TEXT && structureControl.getEditionType() != SControl.EditionType.FILE && structureControl.getEditionType() != SControl.EditionType.FILE_TO_SAVE && structureControl.getEditionType() != SControl.EditionType.FOLDER) continue;
                    if (property.getType() != SimplePrimitive.PRIMITIVE_TYPE.UNKNOWN) {
                        textField.setText(property.getVal().toString());
                        continue;
                    }
                    this.logger.error((Object)("Unknown primitive type for property: " + name));
                    continue;
                }
                if (control instanceof CheckBox) {
                    CheckBox checkBox = (CheckBox)control;
                    if (structureControl.getEditionType() != SControl.EditionType.VALUE) continue;
                    if (property.getType() == SimplePrimitive.PRIMITIVE_TYPE.BOOL) {
                        checkBox.setSelected(((Boolean)property.getVal()).booleanValue());
                        continue;
                    }
                    this.logger.error((Object)("Expected bool type for property: " + name));
                    continue;
                }
                if (!(control instanceof TextArea)) continue;
                TextArea textArea = (TextArea)control;
                if (structureControl.getEditionType() != SControl.EditionType.VALUE && structureControl.getEditionType() != SControl.EditionType.TEXT) continue;
                if (property.getType() != SimplePrimitive.PRIMITIVE_TYPE.UNKNOWN) {
                    textArea.setText(property.getVal().toString());
                    continue;
                }
                this.logger.error((Object)("Unknown primitive type for property: " + name));
            }
            catch (NoSuchElementException ignore) {
                System.out.println(String.format("WARNING, property control element not found: %s", name));
                this.logger.error((Object)String.format("Property control element not found: %s", name));
            }
        }
    }

    private void onChangeValueComboBox(ComboBox comboBox) {
        String name = comboBox.getId();
        Object value = comboBox.getValue();
        try {
            SControl structureControl = (SControl)this.structure.findControl(name).get();
            if (value instanceof SCEItem) {
                SCEItem item = (SCEItem)value;
                String itemValue = item.getValue();
                switch (structureControl.getValueType()) {
                    case INT: {
                        app.rqSetWorkerProperty(this.uiBlockModel.getUuid(), name, Integer.parseInt(itemValue));
                        break;
                    }
                    case LONG: {
                        app.rqSetWorkerProperty(this.uiBlockModel.getUuid(), name, Long.parseLong(itemValue));
                        break;
                    }
                    case STRING: 
                    case SCALAR: 
                    case SETTINGS: {
                        app.rqSetWorkerProperty(this.uiBlockModel.getUuid(), name, itemValue);
                        break;
                    }
                    default: {
                        this.logger.warn((Object)"Unsupported structure control type");
                    }
                }
            }
        }
        catch (NoSuchElementException e) {
            this.logger.error((Object)("control element not found, name: " + name), (Throwable)e);
        }
    }

    private Optional<Integer> stringAsInt32(SControl structureControl, String value) {
        try {
            return Optional.of(Integer.valueOf(value));
        }
        catch (NumberFormatException e) {
            this.logger.error((Object)("integer number format exception: " + e.getMessage()), (Throwable)e);
            return Optional.empty();
        }
    }

    private Optional<Double> stringAsDouble(SControl structureControl, String value) {
        try {
            return Optional.of(Double.valueOf(value));
        }
        catch (NumberFormatException e) {
            this.logger.error((Object)("double number format exception: " + e.getMessage()), (Throwable)e);
            return Optional.empty();
        }
    }

    private Optional<String> stringAsString(SControl structureControl, String value) {
        return Optional.of(value);
    }

    private Optional<Long> stringAsLong(SControl structureControl, String value) {
        try {
            return Optional.of(Long.valueOf(value));
        }
        catch (NumberFormatException e) {
            this.logger.error((Object)("double number format exception: " + e.getMessage()), (Throwable)e);
            return Optional.empty();
        }
    }

    private void onChangeStringValue(SControl structureControl, String value) {
        String name = structureControl.getName();
        switch (structureControl.getValueType()) {
            case INT: {
                this.stringAsInt32(structureControl, value).ifPresent(val -> app.rqSetWorkerProperty(this.uiBlockModel.getUuid(), name, val));
                break;
            }
            case DOUBLE: 
            case FLOAT: {
                this.stringAsDouble(structureControl, value).ifPresent(val -> app.rqSetWorkerProperty(this.uiBlockModel.getUuid(), name, val));
                break;
            }
            case STRING: 
            case SCALAR: 
            case SETTINGS: {
                this.stringAsString(structureControl, value).ifPresent(val -> app.rqSetWorkerProperty(this.uiBlockModel.getUuid(), name, val));
                break;
            }
            case LONG: {
                this.stringAsLong(structureControl, value).ifPresent(val -> app.rqSetWorkerProperty(this.uiBlockModel.getUuid(), name, val));
                break;
            }
            default: {
                String message = String.format("Unsupported string value control, name: %s", structureControl.getName());
                this.logger.error((Object)message);
            }
        }
    }

    private void onChangeValueTextInputControl(TextInputControl textInputControl) {
        String name = textInputControl.getId();
        try {
            SControl structureControl = (SControl)this.structure.findControl(name).get();
            SControl.EditionType editionType = structureControl.getEditionType();
            switch (editionType) {
                case VALUE: 
                case FILE: 
                case FILE_TO_SAVE: 
                case FOLDER: 
                case TEXT: {
                    this.onChangeStringValue(structureControl, textInputControl.getText());
                    break;
                }
                default: {
                    this.logger.warn((Object)String.format("Unsupported structure control type %s", editionType));
                    break;
                }
            }
        }
        catch (NoSuchElementException ignore) {
            String message = String.format("Cannot found structure control, name: %", name);
            this.logger.error((Object)message);
            System.out.println(message);
        }
    }

    public void onChangeValue(Control control) {
        String name = control.getId();
        if (name.isEmpty()) {
            this.logger.error((Object)"combo box control does not have id");
            return;
        }
        if (this.structure == null) {
            return;
        }
        Class<?> controlClass = control.getClass();
        if (ComboBox.class.isAssignableFrom(controlClass)) {
            this.onChangeValueComboBox((ComboBox)control);
        } else if (TextInputControl.class.isAssignableFrom(controlClass)) {
            this.onChangeValueTextInputControl((TextInputControl)control);
        } else if (CheckBox.class.isAssignableFrom(controlClass)) {
            this.onChangeValueCheckBox((CheckBox)control);
        }
    }

    private void onChangeValueCheckBox(CheckBox checkBox) {
        String name = checkBox.getId();
        try {
            SControl structureControl = (SControl)this.structure.findControl(name).get();
            SControl.EditionType editionType = structureControl.getEditionType();
            SControl.ValueType valueType = structureControl.getValueType();
            if (editionType != SControl.EditionType.VALUE) {
                String message = String.format("Unsupported control edition type, name: %s, edition type: %s", name, editionType);
                this.logger.error((Object)message);
                System.out.println(message);
                return;
            }
            if (valueType != SControl.ValueType.BOOLEAN) {
                String message = String.format("Unsupported control value type, name: %s, value type: %s", name, valueType);
                this.logger.error((Object)message);
                System.out.println(message);
                return;
            }
            Boolean val = checkBox.isSelected();
            app.rqSetWorkerProperty(this.uiBlockModel.getUuid(), name, val);
        }
        catch (NoSuchElementException e) {
            String message = String.format("Cannot found structure control, name: %s", name);
            this.logger.error((Object)message);
            System.out.println(message);
        }
    }

    public void setStructure(WorkerStructure workerStructure) {
        this.structure = workerStructure;
    }

    protected final class CellFactory
    extends ComboBoxListCell {
        protected CellFactory(BlockSettings this$0) {
        }

        public void updateItem(Object item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
            } else if (item instanceof SCEItem) {
                SCEItem enumItem = (SCEItem)item;
                this.setText(enumItem.getCaption().isEmpty() ? enumItem.getValue() : enumItem.getCaption());
            } else {
                this.setText(item.toString());
            }
        }
    }
}

