/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.content.settings.block;

import com.siams.cv.monitor.model.SimplePrimitive;
import com.siams.cv.monitor.model.node.UIBlockModel;
import com.siams.cv.monitor.model.worker.WorkerStructure;
import com.siams.cv.monitor.model.worker.control.SCEnum;
import com.siams.cv.monitor.model.worker.control.SCValue;
import com.siams.cv.monitor.model.worker.control.SControl;
import com.siams.cv.monitor.ui.content.settings.block.BlockSettings;
import com.siams.fx.components.tooltip.StareTooltip;
import com.siams.javafx.PaneHelper;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.prefs.Preferences;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import org.apache.log4j.Logger;

@Deprecated
public class AutoBlockSettings
extends BlockSettings {
    private final Logger logger = Logger.getLogger(AutoBlockSettings.class);
    private Map<String, Control> controls = new HashMap<String, Control>();
    private AnchorPane container;
    private State state = State.IDLE;

    public AutoBlockSettings(WorkerStructure structure) {
        this.structure = structure;
        this.createLayout();
    }

    private void createLayout() {
        VBox controlList = new VBox();
        controlList.getChildren().add((Object)new Button("Advanced"));
        controlList.setSpacing(10.0);
        this.createControls(controlList);
        this.container = new AnchorPane(new Node[]{controlList});
        PaneHelper.setAnchorZero((Node)controlList);
    }

    @Override
    public AnchorPane getSettings() {
        Control[] ctrls = new Control[this.controls.size()];
        this.updateControls(this.controls.values().toArray(ctrls));
        return this.container;
    }

    private void createControls(VBox controlsWrapper) {
        for (SControl structureControl : this.structure.getControls()) {
            Control control = null;
            SControl.EditionType editionType = structureControl.getEditionType();
            if (editionType != null) {
                switch (structureControl.getEditionType()) {
                    case VALUE: {
                        control = this.createValueControl((SCValue)structureControl, controlsWrapper);
                        break;
                    }
                    case TEXT: {
                        control = this.createTextControl(structureControl, controlsWrapper);
                        break;
                    }
                    case ENUM: {
                        control = this.createEnumControl((SCEnum)structureControl, controlsWrapper);
                        break;
                    }
                    case FILE: 
                    case FILE_TO_SAVE: {
                        control = this.createFileControl(structureControl, controlsWrapper);
                        break;
                    }
                    case FOLDER: {
                        control = this.createFolderControl(structureControl, controlsWrapper);
                        break;
                    }
                    case COLOR: {
                        control = this.createColorControl(structureControl, controlsWrapper);
                        break;
                    }
                    default: {
                        StringBuilder sb = new StringBuilder();
                        CharSequence[] types = new String[SControl.EditionType.values().length];
                        int index = 0;
                        for (SControl.EditionType type : SControl.EditionType.values()) {
                            types[index] = type.toString();
                            ++index;
                        }
                        this.logger.error((Object)String.format("Unknown structure control edition type, allowed: [%s]", String.join((CharSequence)",", types)));
                        break;
                    }
                }
            } else {
                this.logger.error((Object)"Structure control edition type is null, verify structure control json format");
            }
            if (control == null) continue;
            this.controls.put(control.getId(), control);
        }
    }

    private Control createColorControl(SControl structureControl, VBox controlsWrapper) {
        String caption = structureControl.getCaption();
        if (caption.isEmpty()) {
            caption = structureControl.getName();
        }
        ColorPicker colorControl = new ColorPicker();
        colorControl.setId(structureControl.getName());
        colorControl.setStyle(String.format("-fx-color-label-visible: false; %s", colorControl.getStyle()));
        colorControl.valueProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.equals(oldValue)) {
                return;
            }
            if (this.state != State.IDLE) {
                return;
            }
            this.onChangeValue((Control)colorControl);
        });
        TextField textControl = new TextField();
        textControl.textProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.equals(oldValue)) {
                return;
            }
            if (this.state != State.IDLE) {
                return;
            }
            this.onChangeValue((Control)colorControl);
        });
        HBox layoutContainer = new HBox(5.0, new Node[]{textControl, colorControl});
        HBox.setHgrow((Node)textControl, (Priority)Priority.ALWAYS);
        Label labelCaption = new Label(caption);
        VBox controlContainer = new VBox(5.0, new Node[]{labelCaption, layoutContainer});
        controlsWrapper.getChildren().add((Object)controlContainer);
        return colorControl;
    }

    private Control createFolderControl(SControl structureControl, VBox controlsWrapper) {
        String captionText = structureControl.getCaption();
        if (captionText.isEmpty()) {
            captionText = structureControl.getName();
        }
        Label caption = new Label(captionText);
        TextField control = new TextField();
        control.setId(structureControl.getName());
        control.textProperty().addListener((observable, old, val) -> {
            if (this.state != State.IDLE) {
                return;
            }
            if (old.equals(val)) {
                return;
            }
            this.onChangeValue((Control)control);
        });
        Button button = new Button("...");
        button.setOnAction(event -> {
            File file;
            String folder = "";
            DirectoryChooser chooser = new DirectoryChooser();
            UUID uuid = this.structure.getUuid();
            if (uuid != null) {
                try {
                    Preferences preferences = Preferences.userNodeForPackage(AutoBlockSettings.class);
                    folder = preferences.get(uuid.toString() + ".folder", "");
                    if (!folder.isEmpty() && new File(folder).exists()) {
                        chooser.setInitialDirectory(new File(folder));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((file = chooser.showDialog(null)) != null) {
                control.setText(file.getAbsolutePath());
                this.onChangeValue((Control)control);
                if (uuid != null) {
                    try {
                        Preferences preferences = Preferences.userNodeForPackage(AutoBlockSettings.class);
                        preferences.put(uuid.toString() + ".folder", file.getParentFile().getAbsolutePath());
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        HBox controlWrapper = new HBox(new Node[]{control, button});
        controlWrapper.setSpacing(5.0);
        HBox.setHgrow((Node)control, (Priority)Priority.ALWAYS);
        VBox container = new VBox(new Node[]{caption, controlWrapper});
        controlsWrapper.getChildren().add((Object)container);
        return control;
    }

    private Control createFileControl(SControl structureControl, VBox controlsWrapper) {
        String captionText = structureControl.getCaption();
        if (captionText.isEmpty()) {
            captionText = structureControl.getName();
        }
        Label caption = new Label(captionText);
        TextField control = new TextField();
        control.setId(structureControl.getName());
        control.textProperty().addListener((observable, old, val) -> {
            if (this.state != State.IDLE) {
                return;
            }
            if (old.equals(val)) {
                return;
            }
            this.onChangeValue((Control)control);
        });
        Button button = new Button("...");
        button.setOnAction(event -> {
            File file;
            String folder = "";
            FileChooser chooser = new FileChooser();
            UUID uuid = this.structure.getUuid();
            if (uuid != null) {
                try {
                    Preferences preferences = Preferences.userNodeForPackage(AutoBlockSettings.class);
                    folder = preferences.get(uuid.toString() + ".folder", "");
                    if (!folder.isEmpty() && new File(folder).exists()) {
                        chooser.setInitialDirectory(new File(folder));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((file = chooser.showOpenDialog(null)) != null) {
                control.setText(file.getAbsolutePath());
                this.onChangeValue((Control)control);
                if (uuid != null) {
                    try {
                        Preferences preferences = Preferences.userNodeForPackage(AutoBlockSettings.class);
                        preferences.put(uuid.toString() + ".folder", file.getParentFile().getAbsolutePath());
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        HBox controlWrapper = new HBox(new Node[]{control, button});
        controlWrapper.setSpacing(5.0);
        HBox.setHgrow((Node)control, (Priority)Priority.ALWAYS);
        VBox container = new VBox(new Node[]{caption, controlWrapper});
        controlsWrapper.getChildren().add((Object)container);
        return control;
    }

    private Control createEnumControl(SCEnum structureControl, VBox controlsWrapper) {
        ComboBox control = new ComboBox();
        control.setId(structureControl.getName());
        control.setPrefWidth(-1.0);
        if (!structureControl.getSmartHint().isEmpty()) {
            control.setTooltip((Tooltip)new StareTooltip(structureControl.getSmartHint()));
        }
        control.setVisibleRowCount(16);
        control.setOnAction(event -> {
            if (this.state != State.IDLE) {
                return;
            }
            this.onChangeValue((Control)event.getSource());
        });
        control.getItems().addAll((Collection)structureControl.getItems());
        HBox controlWrapper = new HBox(new Node[]{control});
        controlsWrapper.setFillWidth(true);
        HBox.setHgrow((Node)control, (Priority)Priority.ALWAYS);
        VBox container = new VBox(new Node[]{this.createCaptionLayout((SControl)structureControl, (Control)control), controlWrapper});
        controlsWrapper.getChildren().add((Object)container);
        return control;
    }

    private Control createTextControl(SControl structureControl, VBox controlsWrapper) {
        switch (structureControl.getValueType()) {
            case STRING: 
            case SCALAR: 
            case SETTINGS: {
                return this.createTextValueControl(structureControl, controlsWrapper);
            }
        }
        return null;
    }

    private Control createValueControl(SCValue structureControl, VBox controlsWrapper) {
        switch (structureControl.getValueType()) {
            case INT: 
            case DOUBLE: {
                return this.createNumericalValueControl((SControl)structureControl, controlsWrapper);
            }
            case STRING: 
            case SCALAR: 
            case SETTINGS: {
                return this.createStringValueControl(structureControl, controlsWrapper);
            }
            case BOOLEAN: {
                return this.createBooleanValueControl((SControl)structureControl, controlsWrapper);
            }
        }
        return null;
    }

    private HBox createCaptionLayout(SControl structureControl, Control control) {
        String captionText = structureControl.getCaption();
        if (captionText.isEmpty()) {
            captionText = structureControl.getName();
        }
        Label caption = new Label(captionText);
        caption.setWrapText(true);
        HBox hCaption = new HBox(new Node[]{caption});
        HBox.setHgrow((Node)caption, (Priority)Priority.ALWAYS);
        if (!structureControl.getSmartHint().isEmpty()) {
            caption.setTooltip((Tooltip)new StareTooltip(structureControl.getSmartHint()));
        }
        return hCaption;
    }

    private VBox createControlContainer(SControl structureControl, Control control) {
        HBox controlWrapper = new HBox(new Node[]{control});
        HBox.setHgrow((Node)control, (Priority)Priority.ALWAYS);
        if (!structureControl.getSmartHint().isEmpty()) {
            try {
                control.setTooltip((Tooltip)new StareTooltip(structureControl.getSmartHint()));
            }
            catch (Throwable t) {
                this.logger.error((Object)"Catch exception and find out what is it", t);
            }
        }
        VBox controlContainer = new VBox();
        if (structureControl.getValueType() == SControl.ValueType.BOOLEAN) {
            controlContainer.getChildren().add((Object)controlWrapper);
        } else {
            controlContainer.getChildren().addAll((Object[])new Node[]{this.createCaptionLayout(structureControl, control), controlWrapper});
        }
        return controlContainer;
    }

    private Control createNumericalValueControl(SControl structureControl, VBox controlsWrapper) {
        TextField control = new TextField();
        control.setId(structureControl.getName());
        control.textProperty().addListener((observable, old, val) -> {
            if (this.state != State.IDLE) {
                return;
            }
            if (old.equals(val)) {
                return;
            }
            this.onChangeValue((Control)control);
        });
        controlsWrapper.getChildren().add((Object)this.createControlContainer(structureControl, (Control)control));
        return control;
    }

    private Control createTextValueControl(SControl structureControl, VBox controlsWrapper) {
        TextArea control = new TextArea();
        control.setPrefRowCount(5);
        control.setId(structureControl.getName());
        control.textProperty().addListener((observable, old, val) -> {
            if (this.state != State.IDLE) {
                return;
            }
            if (old.equals(val)) {
                return;
            }
            this.onChangeValue((Control)control);
        });
        controlsWrapper.getChildren().add((Object)this.createControlContainer(structureControl, (Control)control));
        return control;
    }

    private Control createStringValueControl(SCValue structureControl, VBox controlsWrapper) {
        TextArea control;
        if (structureControl.isMultiline()) {
            control = new TextArea();
            control.setPrefRowCount(5);
        } else {
            control = new TextField();
        }
        control.textProperty().addListener((arg_0, arg_1, arg_2) -> this.lambda$createStringValueControl$9((TextInputControl)control, arg_0, arg_1, arg_2));
        control.setId(structureControl.getName());
        controlsWrapper.getChildren().add((Object)this.createControlContainer((SControl)structureControl, (Control)control));
        return control;
    }

    private Control createBooleanValueControl(SControl structureControl, VBox controlsWrapper) {
        String caption = structureControl.getCaption();
        if (caption.isEmpty()) {
            caption = structureControl.getName();
        }
        CheckBox control = new CheckBox(caption);
        control.setId(structureControl.getName());
        control.setWrapText(true);
        control.setMnemonicParsing(false);
        control.setOnAction(event -> {
            if (this.state != State.IDLE) {
                return;
            }
            this.onChangeValue((Control)event.getSource());
        });
        controlsWrapper.getChildren().add((Object)this.createControlContainer(structureControl, (Control)control));
        return control;
    }

    @Override
    public void setProperties(UIBlockModel blockModel, List<SimplePrimitive> primitives) {
        this.state = State.UPDATE_PROPERTIES;
        super.setProperties(blockModel, primitives);
        Control[] ctrls = new Control[this.controls.size()];
        this.controls.values().toArray(ctrls);
        this.updateValues(primitives, ctrls);
        this.state = State.IDLE;
    }

    private /* synthetic */ void lambda$createStringValueControl$9(TextInputControl control, ObservableValue observable, String old, String val) {
        if (this.state != State.IDLE) {
            return;
        }
        if (old.equals(val)) {
            return;
        }
        this.onChangeValue((Control)control);
    }

    private static enum State {
        IDLE,
        UPDATE_PROPERTIES;

    }
}

