/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.content.container;

import com.siams.cv.monitor.application.App;
import com.siams.cv.monitor.application.UserAction;
import com.siams.cv.monitor.message.DataProcessModelsLoaded;
import com.siams.cv.monitor.message.NodeIntrospected;
import com.siams.cv.monitor.message.NodeRemoved;
import com.siams.cv.monitor.message.StareChainConfigLoaded;
import com.siams.cv.monitor.message.StareMonitorClosing;
import com.siams.cv.monitor.message.StareServerConnected;
import com.siams.cv.monitor.model.IIdentifiable;
import com.siams.cv.monitor.model.SimplePrimitive;
import com.siams.cv.monitor.model.storage.IIDStorage;
import com.siams.cv.monitor.model.storage.NodeStorage;
import com.siams.cv.monitor.model.worker.WorkerStructure;
import com.siams.cv.monitor.model.worker.WorkerType;
import com.siams.cv.monitor.ui.content.container.UILibraryFilter;
import com.siams.cv.monitor.ui.content.container.UIObjectProperties;
import com.siams.cv.monitor.ui.factory.Deletable;
import com.siams.cv.monitor.ui.factory.SmartLink;
import com.siams.cv.monitor.ui.factory.UIBlock;
import com.siams.cv.monitor.ui.factory.UILink;
import com.siams.cv.monitor.ui.factory.UIPort;
import com.siams.fx.components.tooltip.StareTooltip;
import com.siams.fxml.loader.CustomFXMLLoader;
import com.siams.javafx.PaneHelper;
import com.siams.javafx.utils.FxPlatform;
import com.siams.preferences.UIPreference;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.util.Pair;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class ObjectIntrospection
extends AnchorPane
implements Deletable,
UIPreference {
    private final Logger logger = Logger.getLogger(ObjectIntrospection.class.getCanonicalName());
    private static final App app = App.getInstance();
    private static final NodeStorage nodeStorage = NodeStorage.getInstance();
    private static ObjectIntrospection instance;
    private IIdentifiable selected = null;
    @FXML
    private HBox hBoxContainer;
    @FXML
    private Label labelSystemName;
    @FXML
    private Label labelObjectName;
    @FXML
    private VBox vBoxSmartLinkPanel;
    @FXML
    private AnchorPane anchorPaneModelFilterHolder;
    @FXML
    private ScrollPane scroller;
    private UILibraryFilter modelFilter = null;
    @FXML
    private Button buttonConvertToSimpleLink;
    @FXML
    private AnchorPane anchorPaneSettings;

    private ObjectIntrospection() {
        this.initialize();
    }

    public static ObjectIntrospection getInstance() {
        if (instance == null) {
            instance = new ObjectIntrospection();
        }
        return instance;
    }

    private void initialize() {
        this.initializeRoot();
        this.initializeSmartLinkPanel();
        this.subscribe();
    }

    private void initializeRoot() {
        try {
            URL url = this.getClass().getResource("/com/siams/cv/monitor/ui/content/container/ObjectIntrospection.fxml");
            CustomFXMLLoader.loadElement((Object)this, (URL)url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initializeSmartLinkPanel() {
        this.modelFilter = new UILibraryFilter();
        this.modelFilter.setModelSelectedListener(this::onSmartLinkLogicChanged);
        this.anchorPaneModelFilterHolder.getChildren().add((Object)this.modelFilter);
        PaneHelper.setAnchorZero((Node)this.modelFilter);
        this.showSmartLinkPanel(false);
    }

    private void subscribe() {
        EventBus.getDefault().register((Object)this);
    }

    @Subscribe
    public void onStareServerConnected(StareServerConnected event) {
        this.clearIntrospection();
    }

    @Subscribe
    public void onNodeRemoved(NodeRemoved event) {
        if (this.selected == null) {
            return;
        }
        if (this.selected.getUuid().equals(event.getUuid())) {
            this.clearIntrospection();
        }
    }

    @Subscribe
    public void onDataProcessModelsLoaded(DataProcessModelsLoaded event) {
        FxPlatform.RunFxThread(() -> {
            if (this.modelFilter == null) {
                this.initializeSmartLinkPanel();
            }
            Predicate<WorkerType> filterAppropriate = model -> {
                List inPorts = model.getStructure().getInPorts();
                List outPorts = model.getStructure().getOutPorts();
                return inPorts != null && inPorts.size() == 1 && outPorts != null && outPorts.size() == 1;
            };
            this.modelFilter.setDataProcessModels(event.getModels().stream().filter(filterAppropriate).collect(Collectors.toList()));
        });
    }

    @Subscribe
    public void onNodeIntrospected(NodeIntrospected event) {
        if (this.selected != null) {
            this.saveScrollerPosition();
        }
        this.selected = event.getObject();
        if (this.selected == null) {
            this.clearIntrospection();
            return;
        }
        Function<Throwable, Void> exceptionHandler = throwable -> {
            this.displayError("Failed display property: " + throwable.getMessage());
            return null;
        };
        nodeStorage.findFirst(this.selected.getUuid()).ifPresent(node -> {
            if (UIBlock.class.isAssignableFrom(node.getClass())) {
                UIBlock uiBlock = (UIBlock)node;
                ((CompletableFuture)app.rqGetObjectProperties(uiBlock).thenAccept(dRsObjectProperties -> FxPlatform.RunFxThread(() -> {
                    this.clearIntrospection();
                    this.showUIBlockProperties(uiBlock, dRsObjectProperties.getProperties());
                    this.restoreScrollerPosition();
                }))).exceptionally(exceptionHandler);
            } else {
                this.logger.severe(String.format("Unknown object type to display properties: %s", node.getClass()));
            }
        });
    }

    @Subscribe
    public void onStareChainConfigLoaded(StareChainConfigLoaded event) {
        if (this.selected != null) {
            nodeStorage.findFirst(this.selected.getUuid()).ifPresent(node -> {
                if (node instanceof UIBlock) {
                    UIBlock uiBlock = (UIBlock)node;
                    ((CompletableFuture)app.rqGetObjectProperties(uiBlock).thenAccept(dRsObjectProperties -> FxPlatform.RunFxThread(() -> {
                        this.clearIntrospection();
                        this.showUIBlockProperties(uiBlock, dRsObjectProperties.getProperties());
                    }))).exceptionally(throwable -> {
                        this.displayError("Failed display property: " + throwable.getMessage());
                        return null;
                    });
                }
            });
        }
    }

    @Subscribe
    public void onStareMonitorClosing(StareMonitorClosing event) {
        this.release();
    }

    public void restorePreference() {
        this.restoreScrollerPosition();
    }

    private void restoreScrollerPosition() {
        FxPlatform.RunFxThread(() -> {
            if (!this.scroller.isDisable()) {
                double prevPosition = this.getPreferredDouble("Scroller position", 0.0);
                this.scroller.setVvalue(prevPosition);
            }
        });
    }

    public void savePreference() {
        this.saveScrollerPosition();
    }

    private void saveScrollerPosition() {
        this.putPreferredDouble("Scroller position", this.scroller.getVvalue());
    }

    @Override
    public void release() {
        this.savePreference();
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
    }

    private void clearIntrospection() {
        FxPlatform.RunFxThread(() -> {
            this.labelSystemName.setManaged(false);
            this.labelSystemName.setVisible(false);
            this.labelObjectName.setVisible(false);
            this.hBoxContainer.getChildren().removeIf(node -> node instanceof ToggleButton);
            this.showSmartLinkPanel(false);
            this.anchorPaneSettings.getChildren().clear();
        });
    }

    private void displayError(String error) {
        FxPlatform.RunFxThread(() -> {
            this.labelSystemName.setManaged(true);
            this.labelSystemName.setVisible(true);
            this.labelSystemName.setText(error);
        });
    }

    private void showSmartLinkPanel(boolean isShowing) {
        this.vBoxSmartLinkPanel.setVisible(isShowing);
        this.vBoxSmartLinkPanel.setManaged(isShowing);
    }

    private void onSmartLinkLogicChanged(WorkerType model) {
        this.labelObjectName.setText(model.getStructure().getName());
    }

    @FXML
    private void onConvertToSimpleLink(ActionEvent event) {
        if (SmartLink.class.isAssignableFrom(this.selected.getClass())) {
            SmartLink smartLink = (SmartLink)this.selected;
            UUID srcPortUuid = smartLink.getNodeModel().getSrcPortUuid();
            UUID destPortUuid = smartLink.getNodeModel().getDestPortUuid();
            UserAction.deleteSelectedObjects(false);
            App.getInstance().rqCreateNewLink(srcPortUuid, destPortUuid);
        }
    }

    private void showUIBlockProperties(UIBlock uiBlock, List<SimplePrimitive> properties) {
        IIDStorage iidStorage = IIDStorage.getInstance();
        iidStorage.findFirst(uiBlock.getNodeModel().getWorkerType(), WorkerType.class).ifPresent(workerType -> {
            this.updateLabelObjectName(uiBlock.getUuid(), (WorkerType)workerType);
            WorkerStructure workerStructure = workerType.getStructure();
            List structureControls = workerStructure.getControls();
            UIObjectProperties uiObjectProperties = new UIObjectProperties(uiBlock);
            this.hBoxContainer.getChildren().add(1, (Object)uiObjectProperties.getToggleAdvanced());
            uiObjectProperties.setControls(structureControls);
            this.anchorPaneSettings.getChildren().add((Object)uiObjectProperties);
            this.showSmartLinkPanel(false);
            PaneHelper.setAnchorZero((Node)uiObjectProperties);
            uiObjectProperties.setProperties(properties);
            uiObjectProperties.setEventHandler((control, value) -> {
                if (control != null && uiBlock != null) {
                    App.getInstance().rqSetWorkerProperty(uiBlock.getUuid(), control.getName(), value).thenAccept(v -> UserAction.executeWorkerIfInstanceMode(uiBlock.getUuid()));
                }
            });
        });
    }

    private void showSmartLinkProperties(SmartLink smartLink, List<SimplePrimitive> properties) {
        IIDStorage iidStorage = IIDStorage.getInstance();
        WorkerType workerType = iidStorage.findFirst(smartLink.getNodeModel().getModelType(), WorkerType.class).get();
        this.updateLabelObjectName(smartLink.getUuid(), workerType);
        WorkerStructure workerStructure = workerType.getStructure();
        List structureControls = workerStructure.getControls();
        UIObjectProperties uiObjectProperties = new UIObjectProperties(smartLink);
        uiObjectProperties.setControls(structureControls);
        this.anchorPaneSettings.getChildren().add((Object)uiObjectProperties);
        this.showSmartLinkPanel(true);
        PaneHelper.setAnchorZero((Node)uiObjectProperties);
        uiObjectProperties.setProperties(properties);
        uiObjectProperties.setEventHandler((control, value) -> {
            if (control != null && smartLink != null) {
                App.getInstance().rqSetWorkerProperty(smartLink.getUuid(), control.getName(), value).thenAccept(v -> UserAction.executeWorkerIfInstanceMode(smartLink.getUuid()));
            }
        });
    }

    private Pair<UIPort, UIPort> figurePorts() {
        NodeStorage storage = NodeStorage.getInstance();
        if (SmartLink.class.isAssignableFrom(this.selected.getClass())) {
            SmartLink smartLink = (SmartLink)this.selected;
            UIPort srcPort = storage.findFirst(smartLink.getNodeModel().getSrcPortUuid(), UIPort.class).get();
            UIPort destPort = storage.findFirst(smartLink.getNodeModel().getDestPortUuid(), UIPort.class).get();
            return new Pair((Object)srcPort, (Object)destPort);
        }
        if (UILink.class.isAssignableFrom(this.selected.getClass())) {
            UILink link = (UILink)this.selected;
            UIPort srcPort = storage.findFirst(link.getNodeModel().getSrcPortUuid(), UIPort.class).get();
            UIPort destPort = storage.findFirst(link.getNodeModel().getDestPortUuid(), UIPort.class).get();
            return new Pair((Object)srcPort, (Object)destPort);
        }
        this.logger.severe(String.format("Can't figure ports from %s", this.selected.getClass().toString()));
        return null;
    }

    private void updateLabelObjectName(UUID uuid, WorkerType model) {
        WorkerStructure structure = model.getStructure();
        if (structure != null) {
            this.labelSystemName.setManaged(false);
            this.labelSystemName.setVisible(false);
            this.labelObjectName.setVisible(true);
            this.labelObjectName.setText(model.getStructure().getName());
            this.labelObjectName.setWrapText(true);
            app.rqGetDataIfExist(String.format("P/worker:%s/system:%s", uuid, "name"), "").thenAccept(systemName -> {
                if (!systemName.isEmpty()) {
                    Platform.runLater(() -> {
                        this.labelSystemName.setManaged(true);
                        this.labelSystemName.setVisible(true);
                        this.labelSystemName.setText("[" + systemName + "]");
                        this.labelSystemName.setTooltip((Tooltip)new StareTooltip(ObjectIntrospection.executorDescription(structure, uuid) + "System name of this block: \"" + systemName + "\"\n"));
                    });
                }
            });
            StareTooltip tooltipDataProcess = new StareTooltip(ObjectIntrospection.executorDescription(structure, uuid));
            this.labelObjectName.setTooltip((Tooltip)tooltipDataProcess);
        }
    }

    private static String executorDescription(WorkerStructure structure, UUID blockUuid) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Name of executor: \"%s\"\n", structure.getName()));
        sb.append(String.format("Category of executor: \"%s\"\n", structure.getCategory()));
        if (structure.getJava() != null) {
            sb.append(String.format("Java class: %s\n", structure.getJava().getCanonicalName()));
        }
        sb.append(String.format("UUID: %s\n", blockUuid));
        sb.append(String.format("Executor ID: %s\n", structure.getUuid()));
        if (!structure.getAuthors().isEmpty()) {
            sb.append(String.format("Authors: %s\n", structure.getAuthors()));
        }
        return sb.toString();
    }
}

