/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.content.container;

import com.siams.cv.monitor.model.storage.IIDStorage;
import com.siams.fxml.loader.CustomFXMLLoader;
import java.io.IOException;
import java.net.URL;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.AnchorPane;
import javafx.util.Callback;

class IIDStorageLog
extends AnchorPane {
    private static IIDStorageLog instance;
    private final IIDStorage iidStorage = IIDStorage.getInstance();
    private ObservableList<IIDItem> data = FXCollections.observableArrayList();
    private FilteredList<IIDItem> filteredData = new FilteredList(this.data, s -> true);
    @FXML
    private TableView<IIDItem> tableView;
    @FXML
    private TableColumn<IIDItem, String> columnValue;
    @FXML
    private Button buttonUpdate;
    @FXML
    private TextField textFieldFilter;

    @FXML
    void onButtonUpdateClick(ActionEvent event) {
        this.data.clear();
        this.iidStorage.getAll().forEach(iid -> {
            IIDItem item = new IIDItem(this);
            item.setName(String.format("%s, %s", iid.getClass(), iid.toString()));
            this.data.add((Object)item);
        });
    }

    @FXML
    void onFilterChange(ActionEvent event) {
        this.filteredData.setPredicate(item -> item.getName().toLowerCase().contains(this.textFieldFilter.getText().toLowerCase()));
    }

    private IIDStorageLog() {
        this.initialize();
    }

    private void initialize() {
        try {
            URL url = ((Object)((Object)this)).getClass().getResource("/com/siams/cv/monitor/ui/content/container/IIDStorageLog.fxml");
            CustomFXMLLoader.loadElement((Object)((Object)this), (URL)url);
            this.initializeTable();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static IIDStorageLog getInstance() {
        if (instance == null) {
            instance = new IIDStorageLog();
        }
        return instance;
    }

    private void initializeTable() {
        this.tableView.setItems(this.filteredData);
        this.columnValue.setCellValueFactory((Callback)new PropertyValueFactory("name"));
    }

    public class IIDItem {
        private StringProperty name = new SimpleStringProperty((Object)this, "");

        public void setName(String value) {
            this.nameProperty().set((Object)value);
        }

        public String getName() {
            return (String)this.nameProperty().get();
        }

        IIDItem(IIDStorageLog this$0) {
        }

        public StringProperty nameProperty() {
            return this.name;
        }
    }
}

