/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.content.container;

import com.siams.cv.monitor.message.NewLogMessageAdded;
import com.siams.cv.monitor.message.StareMonitorClosing;
import com.siams.cv.monitor.ui.Initializable;
import com.siams.cv.monitor.ui.UISync;
import com.siams.cv.monitor.ui.factory.Deletable;
import com.siams.fxml.loader.CustomFXMLLoader;
import java.io.IOException;
import java.net.URL;
import java.util.prefs.Preferences;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class ApplicationLog
extends AnchorPane
implements Initializable,
Deletable {
    private static ApplicationLog instance;
    private UISync uiSync = UISync.getInstance();
    private ObservableList<String> data = FXCollections.observableArrayList();
    private FilteredList<String> filteredList = new FilteredList(this.data, s -> true);
    private int duplicateMessageCounter = 1;
    private String prevMessage = null;
    @FXML
    private ComboBox<LogLevelItem> comboBoxLogLevel;
    @FXML
    private Button buttonClear;
    @FXML
    private TextField textFieldFilter;
    @FXML
    private ListView<String> listViewApplicationLog;

    public static ApplicationLog getInstance() {
        if (instance == null) {
            instance = new ApplicationLog();
        }
        return instance;
    }

    @Override
    public void release() {
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
    }

    @FXML
    void onButtonClearClick(ActionEvent event) {
        this.data.clear();
    }

    @FXML
    void onButtonBottomClick(ActionEvent event) {
        this.listViewApplicationLog.scrollTo(this.data.size());
    }

    private ApplicationLog() {
        try {
            URL url = this.getClass().getResource("/com/siams/cv/monitor/ui/content/container/ApplicationLog.fxml");
            CustomFXMLLoader.loadElement((Object)this, (URL)url);
            this.initializeComboBoxLogLevel();
            this.initializeTextFieldFilter();
            this.initializeListViewApplicationLog();
            this.subscribe();
            this.restorePreference();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void restorePreference() {
        try {
            Preferences preferences = Preferences.userNodeForPackage(ApplicationLog.class);
            String logLevel = preferences.get("logLevel", LogLevelItem.ALL.toString());
            try {
                this.comboBoxLogLevel.setValue((Object)LogLevelItem.valueOf(logLevel));
            }
            catch (IllegalArgumentException ignore) {
                this.comboBoxLogLevel.setValue((Object)LogLevelItem.ALL);
            }
            this.updateFilteredDataPredicate(this.textFieldFilter.getText(), (LogLevelItem)((Object)this.comboBoxLogLevel.getValue()));
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    private void savePreference() {
        try {
            Preferences preferences = Preferences.userNodeForPackage(ApplicationLog.class);
            preferences.put("logLevel", ((LogLevelItem)((Object)this.comboBoxLogLevel.getValue())).toString());
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    private void initializeListViewApplicationLog() {
        this.listViewApplicationLog.setItems(this.filteredList);
    }

    private void updateFilteredDataPredicate(String substring, LogLevelItem logLevel) {
        if (substring.length() == 0 && logLevel == LogLevelItem.ALL) {
            this.filteredList.setPredicate(s -> true);
        } else if (logLevel != LogLevelItem.ALL) {
            this.filteredList.setPredicate(s -> s.toLowerCase().contains(logLevel.toString().toLowerCase()) && s.toLowerCase().contains(substring.toLowerCase()));
        } else {
            this.filteredList.setPredicate(s -> s.toLowerCase().contains(substring.toLowerCase()));
        }
    }

    private void initializeTextFieldFilter() {
        this.textFieldFilter.textProperty().addListener((observable, oldValue, newValue) -> this.updateFilteredDataPredicate((String)newValue, (LogLevelItem)((Object)((Object)this.comboBoxLogLevel.getValue()))));
    }

    private void initializeComboBoxLogLevel() {
        this.comboBoxLogLevel.getItems().addAll((Object[])LogLevelItem.values());
        this.comboBoxLogLevel.setOnAction(v -> this.updateFilteredDataPredicate(this.textFieldFilter.getText(), (LogLevelItem)((Object)((Object)this.comboBoxLogLevel.getValue()))));
        this.comboBoxLogLevel.setValue((Object)LogLevelItem.ALL);
    }

    private void subscribe() {
        EventBus.getDefault().register((Object)this);
    }

    @Subscribe
    public void onStareMonitorClosing(StareMonitorClosing event) {
        this.savePreference();
        this.release();
    }

    @Subscribe
    public void onNewLogMessageAdded(NewLogMessageAdded event) {
        this.uiSync.update(() -> {
            String msg = event.getMessage();
            if (this.listViewApplicationLog.getItems().size() > 0) {
                int lastIndex = this.data.size() - 1;
                if (msg.equals(this.prevMessage)) {
                    ++this.duplicateMessageCounter;
                    String newLast = String.format("%d x %s", this.duplicateMessageCounter, msg);
                    this.data.set(lastIndex, (Object)newLast);
                    return;
                }
                this.duplicateMessageCounter = 1;
                this.prevMessage = msg;
            } else {
                this.prevMessage = msg;
            }
            this.data.add((Object)msg);
        });
    }

    static enum LogLevelItem {
        TRACE,
        DEBUG,
        INFO,
        ERROR,
        ALL,
        PROFILER;

    }
}

