/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui;

import com.siams.cv.monitor.application.App;
import com.siams.cv.monitor.entity.StareNode;
import com.siams.cv.monitor.ui.NodeActionHandler;
import com.siams.cv.monitor.ui.NodeDragHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;

public class DefaultNodeDragHandler
extends NodeDragHandler {
    public DefaultNodeDragHandler(Node eventConsumer, StareNode eventTarget) {
        super(eventConsumer, eventTarget);
    }

    public DefaultNodeDragHandler(Node eventConsumer, StareNode eventTarget, NodeActionHandler.EventConsumptionMode consumptionMode) {
        super(eventConsumer, eventTarget, consumptionMode);
    }

    @Override
    protected void onPress(MouseEvent event) {
        super.onPress(event);
        event.consume();
    }

    @Override
    protected void onDrag(MouseEvent event) {
        super.onDrag(event);
        event.consume();
        switch (this.dragMode) {
            case LAYOUT: {
                double x = this.eventConsumer.getLayoutX() + event.getX() - this.eventStart.getX();
                double y = this.eventConsumer.getLayoutY() + event.getY() - this.eventStart.getY();
                this.eventConsumer.setLayoutX(x);
                this.eventConsumer.setLayoutY(y);
                break;
            }
            case TRANSLATE: {
                this.eventConsumer.setTranslateX(this.dragInfoLocal.distanceX);
                this.eventConsumer.setTranslateY(this.dragInfoLocal.distanceY);
                break;
            }
        }
    }

    @Override
    protected void onRelease(MouseEvent event) {
        super.onRelease(event);
        if (App.getInstance().getProject().getRoot().getGridAdjust()) {
            int gridSize = App.getInstance().getProject().getRoot().getGridSize();
            double x = Math.floor(this.eventConsumer.getLayoutX() / (double)gridSize + 0.5) * (double)gridSize;
            double y = Math.floor(this.eventConsumer.getLayoutY() / (double)gridSize + 0.5) * (double)gridSize;
            this.eventConsumer.setLayoutX(x);
            this.eventConsumer.setLayoutY(y);
        }
        event.consume();
    }
}

