/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.transport;

import com.siams.cv.monitor.application.App;
import com.siams.cv.monitor.message.StatisticResultReady;
import com.siams.cv.monitor.model.node.UIBlockModel;
import com.siams.cv.monitor.model.statistic.Statistic;
import com.siams.cv.monitor.viewers.ui.content.ViewerData;
import com.siams.cv.monitor.viewers.ui.content.ViewerDataSource;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class BlockBasedDataSource
implements ViewerDataSource {
    private final UUID blockId;
    private final List<ViewerDataSource.ChangeViewerDataListener> viewerDataListeners = new LinkedList<ViewerDataSource.ChangeViewerDataListener>();
    private ViewerData viewerData = null;

    public BlockBasedDataSource(UUID blockId) {
        this.blockId = blockId;
        this.subscribe();
    }

    private void subscribe() {
        EventBus.getDefault().register((Object)this);
    }

    @Subscribe
    public void onStatisticResultReady(StatisticResultReady event) {
        Statistic statistic = event.getStatistic();
        if (!this.blockId.equals(statistic.getObjectUuid())) {
            return;
        }
        if (!statistic.hasError()) {
            this.rqViewerData();
        } else {
            this.notifyListenersErrorReceived(new RuntimeException(statistic.getStackTrace()));
        }
    }

    public CompletableFuture<Void> rqViewerData() {
        App app = App.getInstance();
        Optional<UIBlockModel> optModel = app.getProject().findModel(this.blockId, UIBlockModel.class);
        CompletableFuture<Void> dataResult = new CompletableFuture<Void>();
        if (optModel.isPresent()) {
            return ((CompletableFuture)app.rqViewerData(optModel.get()).thenAccept(this::notifyListenersViewerDataReceived)).exceptionally(t -> {
                this.notifyListenersErrorReceived((Throwable)t);
                throw new CompletionException(new Throwable(t.getMessage()));
            });
        }
        dataResult.completeExceptionally(new Throwable("UIBlockModel " + this.blockId.toString() + " not found"));
        return dataResult;
    }

    public void addListener(ViewerDataSource.ChangeViewerDataListener listener) {
        this.viewerDataListeners.add(listener);
    }

    public void removeDataListener(ViewerDataSource.ChangeViewerDataListener listener) {
        this.viewerDataListeners.remove(listener);
    }

    public void setData(ViewerData viewerData) {
        this.viewerData = viewerData;
    }

    public Optional<ViewerData> getData() {
        return Optional.ofNullable(this.viewerData);
    }

    public void release() {
        this.viewerDataListeners.clear();
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
        if (this.viewerData != null) {
            this.viewerData.release();
        }
    }

    protected void notifyListenersViewerDataReceived(ViewerData viewerData) {
        this.viewerData = viewerData;
        this.viewerDataListeners.forEach(listener -> listener.onViewerDataReceived(viewerData));
    }

    protected void notifyListenersErrorReceived(Throwable t) {
        this.viewerDataListeners.forEach(listener -> listener.onViewerDataErrorReceived(t));
    }
}

