/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.plugin.poke.model;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.siams.cv.monitor.plugin.poke.model.StarePokePlugin;
import com.siams.cv.monitor.plugin.poke.model.UserMarker;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FileUserMarkers {
    @JsonProperty(value="base_file")
    private String baseFileName;
    @JsonProperty(value="labeled_file")
    private String labeledFileName;
    @JsonProperty(value="user_markers")
    private List<UserMarker> userMarkers = new ArrayList<UserMarker>();

    @JsonGetter(value="base_file")
    public String getBaseFileName() {
        if (this.baseFileName != null && !this.baseFileName.isEmpty()) {
            try {
                File file = new File(this.baseFileName);
                this.baseFileName = file.getName();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.baseFileName;
    }

    @JsonSetter(value="base_file")
    public void setBaseFileName(String baseFileName) {
        this.baseFileName = baseFileName;
    }

    @JsonGetter(value="labeled_file")
    public String getLabeledFileName() {
        if (this.labeledFileName != null && !this.labeledFileName.isEmpty()) {
            try {
                File file = new File(this.labeledFileName);
                this.labeledFileName = file.getName();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.labeledFileName;
    }

    @JsonSetter(value="labeled_file")
    public void setLabeledFileName(String labeledFileName) {
        this.labeledFileName = labeledFileName;
    }

    public boolean addUserMarker(UserMarker userMarker) {
        return this.userMarkers.add(userMarker);
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (FileUserMarkers.class.isAssignableFrom(obj.getClass())) {
            FileUserMarkers fileUserMarkers = (FileUserMarkers)obj;
            return this.baseFileName.equals(fileUserMarkers.baseFileName);
        }
        return false;
    }

    public int hashCode() {
        return this.baseFileName.hashCode();
    }

    public UserMarker removeUserMarker(int labelIndex) {
        return StarePokePlugin.findAndRemove(this.userMarkers, userMarker -> userMarker.getLabelIndex() == labelIndex);
    }

    public List<UserMarker> removeAllUserMarkers(int labelIndex) {
        return StarePokePlugin.findAndRemoveAll(this.userMarkers, userMarker -> userMarker.getLabelIndex() == labelIndex);
    }

    @JsonGetter(value="user_markers")
    public List<UserMarker> getUserMarkers() {
        return this.userMarkers;
    }

    @JsonSetter(value="user_markers")
    public void setUserMarkers(List<UserMarker> userMarkers) {
        this.userMarkers = userMarkers;
    }

    public List<UserMarker> findUserMarkers(int labelIndex) {
        return this.userMarkers.stream().filter(userMarker -> userMarker.getLabelIndex() == labelIndex).collect(Collectors.toList());
    }

    public Optional<UserMarker> findUserMarker(int labelIndex) {
        return this.userMarkers.stream().filter(userMarker -> userMarker.getLabelIndex() == labelIndex).findFirst();
    }
}

