/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.help;

import com.siams.cv.monitor.model.SimplePrimitive;
import com.siams.cv.monitor.model.node.UIBlockModel;
import com.siams.cv.monitor.model.node.UIPortModel;
import com.siams.cv.monitor.model.worker.SPort;
import com.siams.cv.monitor.model.worker.WorkerStructure;
import com.siams.cv.monitor.model.worker.WorkerType;
import com.siams.cv.monitor.model.worker.control.SControl;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class HelpExecutor {
    private String uuid;
    private String caption;
    private String systemName;
    private String comment;
    private Language language;
    private Model model;
    private List<Port> input;
    private List<Port> output;
    private List<Control> controls;

    public void setProperties(List<SimplePrimitive> properties) {
    }

    public void setDataProcessModel(WorkerType mdl) {
        WorkerStructure structure = mdl.getStructure();
        this.model = new Model(this);
        this.model.category = structure.getCategory();
        this.model.name = structure.getName();
        this.model.description = structure.getDescription();
        this.model.uuid = structure.getUuid().toString();
        this.model.tags = structure.getTags();
        if (structure.getLanguage().equals("java")) {
            Java java = new Java(this);
            java.name = structure.getLanguage();
            java.clazz = structure.getLanguageDetails();
            this.language = java;
        } else if (structure.getLanguage().equals("cpp") || structure.getLanguage().equals("c++")) {
            this.language = new Language(this);
            this.language.name = "c++";
        }
        this.controls = mdl.getStructure().getControls().stream().map(x$0 -> new Control(this, (SControl)x$0)).collect(Collectors.toList());
        this.input = mdl.getStructure().getInPorts().stream().map(x$0 -> new Port(this, (SPort)x$0)).collect(Collectors.toList());
        this.output = mdl.getStructure().getOutPorts().stream().map(x$0 -> new Port(this, (SPort)x$0)).collect(Collectors.toList());
    }

    public void setBlockModel(UIBlockModel blockModel) {
        this.uuid = blockModel.getUuid().toString();
        this.caption = blockModel.getCaption();
        this.comment = blockModel.getComment();
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public String getComment() {
        return this.comment;
    }

    public Language getLanguage() {
        return this.language;
    }

    public Model getModel() {
        return this.model;
    }

    public List<Port> getInput() {
        return this.input;
    }

    public List<Port> getOutput() {
        return this.output;
    }

    public List<Control> getControls() {
        return this.controls;
    }

    public Set<String> getTags() {
        return this.model.getTags();
    }

    public class Model {
        String uuid;
        String category;
        String name;
        String description;
        private Set<String> tags;

        public Model(HelpExecutor this$0) {
        }

        public String getUuid() {
            return this.uuid;
        }

        public String getCategory() {
            return this.category;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public Set<String> getTags() {
            return this.tags;
        }
    }

    public class Java
    extends Language {
        String clazz;

        public Java(HelpExecutor this$0) {
            super(this$0);
        }

        public String getClazz() {
            return this.clazz;
        }
    }

    public class Language {
        String name;

        public Language(HelpExecutor this$0) {
        }

        public String getName() {
            return this.name;
        }
    }

    public class Port {
        String uuid;
        String name;
        String type;
        String caption;
        String hint;

        Port(HelpExecutor this$0, UIPortModel port) {
            this.setPort(port);
        }

        Port(HelpExecutor this$0, SPort port) {
            this.setPort(port);
        }

        void setPort(UIPortModel port) {
            this.uuid = port.getUuid().toString();
            this.name = port.getName();
            this.type = port.getDataType().getName();
            this.caption = port.getCaption();
            this.hint = port.getHint();
        }

        void setPort(SPort port) {
            this.name = port.getName();
            this.type = port.getValueType().toString();
            this.caption = port.getCaption();
            this.hint = port.getHint();
        }

        public String getUuid() {
            return this.uuid;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getCaption() {
            return this.caption;
        }

        public String getHint() {
            return this.hint;
        }
    }

    public class Control {
        String name;
        String caption;
        String description;
        String hint;
        String type;
        String defaultValue;

        Control(HelpExecutor this$0, SControl control) {
            this.name = control.getName();
            this.caption = control.getCaption();
            this.description = control.getDescription();
            this.hint = control.getHint();
            this.type = control.getValueType().name();
            this.defaultValue = control.getDef();
        }

        public String getName() {
            return this.name;
        }

        public String getCaption() {
            return this.caption;
        }

        public String getDescription() {
            return this.description.replace("\n", "<br>\n");
        }

        public String getHint() {
            return this.hint;
        }

        public String getType() {
            return this.type;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

