/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.export.poke;

import com.siams.cv.monitor.plugin.poke.model.FileUserMarkers;
import com.siams.cv.monitor.plugin.poke.model.LabelFeature;
import com.siams.cv.monitor.plugin.poke.model.StarePokePlugin;
import com.siams.cv.monitor.plugin.poke.model.UserMarker;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ExportUserMarkersCsv {
    private String delimiter = new String(",");

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void exportAs(File saveTo, StarePokePlugin data) throws IOException {
        if (!Files.exists(saveTo.toPath(), new LinkOption[0])) {
            saveTo.createNewFile();
        }
        List<LabelFeature> exportFeatures = data.getExportLabelFeatures();
        int columnCount = exportFeatures.size() + 1;
        try (FileOutputStream out = new FileOutputStream(saveTo);){
            ArrayList<String> headers = new ArrayList<String>(columnCount);
            for (int column = 0; column < columnCount - 1; ++column) {
                headers.add(exportFeatures.get(column).getName());
            }
            headers.add("Class");
            String lineHeader = String.join((CharSequence)this.delimiter, headers);
            out.write(lineHeader.getBytes());
            out.write("\r\n".getBytes());
            ArrayList<String> stringFeatures = new ArrayList<String>();
            Set<FileUserMarkers> fileUserMarkers = data.getBaseFileUserMakers();
            for (FileUserMarkers fileMarkers : fileUserMarkers) {
                for (UserMarker userMarker : fileMarkers.getUserMarkers()) {
                    double[] features = userMarker.getFeatures();
                    stringFeatures.clear();
                    for (LabelFeature labelFeature : exportFeatures) {
                        double featureValue = features[labelFeature.getIndex()];
                        stringFeatures.add(String.valueOf(featureValue));
                    }
                    stringFeatures.add(String.valueOf(userMarker.getMarkerClassId()));
                    out.write(String.join((CharSequence)this.delimiter, stringFeatures).getBytes());
                    out.write("\r\n".getBytes());
                }
            }
        }
    }
}

